/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util;

import java.util.List;
import java.util.Locale;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.util.EntityDamageResistance;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.ItemDamageResistance;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public enum PhysicalDamageType implements StringRepresentable
{
    CRUSHING,
    SLASHING,
    PIERCING;

    public static final TagKey<DamageType> BYPASSES_DAMAGE_RESISTANCES;
    public static final TagKey<DamageType> IS_PIERCING;
    public static final TagKey<DamageType> IS_CRUSHING;
    public static final TagKey<DamageType> IS_SLASHING;
    private final String serializedName = this.name().toLowerCase(Locale.ROOT);

    public static void addTooltipInfo(ItemStack stack, List<Component> tooltips) {
        Multiplier resistanceType;
        PhysicalDamageType damageType = PhysicalDamageType.getTypeForItem(stack);
        if (damageType != null) {
            tooltips.add((Component)Component.m_237115_((String)("tfc.tooltip.deals_damage." + damageType.m_7912_())));
        }
        if ((resistanceType = PhysicalDamageType.getResistanceForItem(stack)) != null) {
            tooltips.add((Component)Component.m_237110_((String)"tfc.tooltip.resists_damage", (Object[])new Object[]{PhysicalDamageType.calculatePercentageForDisplay(resistanceType.slashing()), PhysicalDamageType.calculatePercentageForDisplay(resistanceType.piercing()), PhysicalDamageType.calculatePercentageForDisplay(resistanceType.crushing())}));
        }
    }

    public static float calculateMultiplier(DamageSource source, Entity entityUnderAttack) {
        EntityDamageResistance naturalMultiplier;
        PhysicalDamageType type = PhysicalDamageType.getTypeForSource(source);
        float resistance = 0.0f;
        if (type != null && (naturalMultiplier = EntityDamageResistance.get(entityUnderAttack)) != null) {
            resistance += naturalMultiplier.value(type);
        }
        for (ItemStack stack : entityUnderAttack.m_6168_()) {
            Multiplier armorMultiplier = PhysicalDamageType.getResistanceForItem(stack);
            if (armorMultiplier == null) continue;
            resistance += armorMultiplier.value(type);
        }
        return (float)Math.pow(Math.E, -0.01 * (double)resistance);
    }

    @Nullable
    public static PhysicalDamageType getTypeForSource(DamageSource source) {
        if (source.m_269533_(BYPASSES_DAMAGE_RESISTANCES)) {
            return null;
        }
        if (source.m_269533_(IS_PIERCING)) {
            return PIERCING;
        }
        if (source.m_269533_(IS_CRUSHING)) {
            return CRUSHING;
        }
        if (source.m_269533_(IS_SLASHING)) {
            return CRUSHING;
        }
        Entity entity = source.m_7639_();
        if (entity != null) {
            PhysicalDamageType weaponDamageType;
            LivingEntity livingEntity;
            ItemStack heldItem;
            if (entity instanceof LivingEntity && !(heldItem = (livingEntity = (LivingEntity)entity).m_21205_()).m_41619_() && (weaponDamageType = PhysicalDamageType.getTypeForItem(heldItem)) != null) {
                return weaponDamageType;
            }
            if (Helpers.isEntity(entity, TFCTags.Entities.DEALS_PIERCING_DAMAGE)) {
                return PIERCING;
            }
            if (Helpers.isEntity(entity, TFCTags.Entities.DEALS_SLASHING_DAMAGE)) {
                return SLASHING;
            }
            if (Helpers.isEntity(entity, TFCTags.Entities.DEALS_CRUSHING_DAMAGE)) {
                return CRUSHING;
            }
        }
        return null;
    }

    @Nullable
    public static PhysicalDamageType getTypeForItem(ItemStack stack) {
        if (Helpers.isItem(stack, TFCTags.Items.DEALS_PIERCING_DAMAGE)) {
            return PIERCING;
        }
        if (Helpers.isItem(stack, TFCTags.Items.DEALS_SLASHING_DAMAGE)) {
            return SLASHING;
        }
        if (Helpers.isItem(stack, TFCTags.Items.DEALS_CRUSHING_DAMAGE)) {
            return CRUSHING;
        }
        return null;
    }

    @Nullable
    public static Multiplier getResistanceForItem(ItemStack stack) {
        ArmorItem armor;
        ItemDamageResistance res = ItemDamageResistance.get(stack);
        if (res != null) {
            return res;
        }
        Item item = stack.m_41720_();
        if (item instanceof ArmorItem && (item = (armor = (ArmorItem)item).m_40401_()) instanceof Multiplier) {
            Multiplier armorMultiplier = (Multiplier)item;
            return armorMultiplier;
        }
        return null;
    }

    private static Component calculatePercentageForDisplay(float resistance) {
        float multiplier = 1.0f - (float)Math.pow(Math.E, -0.01 * (double)resistance);
        if ((double)multiplier >= 0.999999) {
            return Component.m_237115_((String)"tfc.tooltip.immune_to_damage");
        }
        return Component.m_237113_((String)String.format("%.0f%%", Float.valueOf(multiplier * 100.0f)));
    }

    public String m_7912_() {
        return this.serializedName;
    }

    static {
        BYPASSES_DAMAGE_RESISTANCES = TagKey.m_203882_((ResourceKey)Registries.f_268580_, (ResourceLocation)Helpers.identifier("bypasses_damage_resistances"));
        IS_PIERCING = TagKey.m_203882_((ResourceKey)Registries.f_268580_, (ResourceLocation)Helpers.identifier("is_piercing"));
        IS_CRUSHING = TagKey.m_203882_((ResourceKey)Registries.f_268580_, (ResourceLocation)Helpers.identifier("is_crushing"));
        IS_SLASHING = TagKey.m_203882_((ResourceKey)Registries.f_268580_, (ResourceLocation)Helpers.identifier("is_slashing"));
    }

    public static interface Multiplier {
        public float crushing();

        public float piercing();

        public float slashing();

        default public float value(@Nullable PhysicalDamageType type) {
            if (type == null) {
                return Math.max(this.crushing(), Math.max(this.piercing(), this.slashing()));
            }
            return switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case CRUSHING -> this.crushing();
                case SLASHING -> this.slashing();
                case PIERCING -> this.piercing();
            };
        }
    }
}

