/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.dries007.tfc.common.TFCArmorMaterials;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.TFCTiers;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.TFCChainBlock;
import net.dries007.tfc.common.blocks.devices.AnvilBlock;
import net.dries007.tfc.common.blocks.devices.LampBlock;
import net.dries007.tfc.common.items.ChiselItem;
import net.dries007.tfc.common.items.HammerItem;
import net.dries007.tfc.common.items.IngotItem;
import net.dries007.tfc.common.items.JavelinItem;
import net.dries007.tfc.common.items.LampBlockItem;
import net.dries007.tfc.common.items.MaceItem;
import net.dries007.tfc.common.items.PropickItem;
import net.dries007.tfc.common.items.ScytheItem;
import net.dries007.tfc.common.items.TFCFishingRodItem;
import net.dries007.tfc.common.items.TFCHoeItem;
import net.dries007.tfc.common.items.TFCShieldItem;
import net.dries007.tfc.common.items.ToolItem;
import net.dries007.tfc.network.DataManagerSyncPacket;
import net.dries007.tfc.util.DataManager;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.JsonHelpers;
import net.dries007.tfc.util.registry.RegistryMetal;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.HorseArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class Metal {
    public static final ResourceLocation UNKNOWN_ID = Helpers.identifier("unknown");
    public static final ResourceLocation WROUGHT_IRON_ID = Helpers.identifier("wrought_iron");
    public static final DataManager<Metal> MANAGER = new DataManager<Metal>(Helpers.identifier("metals"), "metal", Metal::fromJson, Metal::fromNetwork, Metal::encode, Packet::new);
    private static final Map<Fluid, Metal> METAL_FLUIDS = new HashMap<Fluid, Metal>();
    private final int tier;
    private final Fluid fluid;
    private final float meltTemperature;
    private final float specificHeatCapacity;
    private final ResourceLocation id;
    private final ResourceLocation textureId;
    private final ResourceLocation softTextureId;
    private final String translationKey;
    @Nullable
    private final Ingredient ingots;
    @Nullable
    private final Ingredient doubleIngots;
    @Nullable
    private final Ingredient sheets;

    @Nullable
    public static Metal get(Fluid fluid) {
        return METAL_FLUIDS.get(fluid);
    }

    public static Metal unknown() {
        return MANAGER.getOrThrow(UNKNOWN_ID);
    }

    @Nullable
    public static Metal getFromIngot(ItemStack stack) {
        for (Metal metal : MANAGER.getValues()) {
            if (!metal.isIngot(stack) && !metal.isDoubleIngot(stack)) continue;
            return metal;
        }
        return null;
    }

    @Nullable
    public static Metal getFromSheet(ItemStack stack) {
        for (Metal metal : MANAGER.getValues()) {
            if (!metal.isSheet(stack)) continue;
            return metal;
        }
        return null;
    }

    public static void updateMetalFluidMap() {
        Metal.unknown();
        METAL_FLUIDS.clear();
        for (Metal metal : MANAGER.getValues()) {
            METAL_FLUIDS.put(metal.getFluid(), metal);
        }
    }

    private static Metal fromJson(ResourceLocation id, JsonObject json) {
        int tier = JsonHelpers.m_13824_((JsonObject)json, (String)"tier", (int)0);
        Fluid fluid = (Fluid)JsonHelpers.getRegistryEntry(json, "fluid", BuiltInRegistries.f_257020_);
        float specificHeatCapacity = JsonHelpers.m_13915_((JsonObject)json, (String)"specific_heat_capacity");
        float meltTemperature = JsonHelpers.m_13915_((JsonObject)json, (String)"melt_temperature");
        Ingredient ingots = json.has("ingots") ? Ingredient.m_43917_((JsonElement)JsonHelpers.get(json, "ingots")) : null;
        Ingredient doubleIngots = json.has("double_ingots") ? Ingredient.m_43917_((JsonElement)JsonHelpers.get(json, "double_ingots")) : null;
        Ingredient sheets = json.has("sheets") ? Ingredient.m_43917_((JsonElement)JsonHelpers.get(json, "sheets")) : null;
        return new Metal(id, tier, fluid, meltTemperature, specificHeatCapacity, ingots, doubleIngots, sheets);
    }

    private static Metal fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
        int tier = buffer.m_130242_();
        Fluid fluid = (Fluid)BuiltInRegistries.f_257020_.m_7942_(buffer.m_130242_());
        float meltTemperature = buffer.readFloat();
        float specificHeatCapacity = buffer.readFloat();
        Ingredient ingots = Helpers.decodeNullable(buffer, Ingredient::m_43940_);
        Ingredient doubleIngots = Helpers.decodeNullable(buffer, Ingredient::m_43940_);
        Ingredient sheets = Helpers.decodeNullable(buffer, Ingredient::m_43940_);
        return new Metal(id, tier, fluid, meltTemperature, specificHeatCapacity, ingots, doubleIngots, sheets);
    }

    public Metal(ResourceLocation id) {
        this(id, 0, Fluids.f_76191_, 0.0f, 0.0f, Ingredient.f_43901_, Ingredient.f_43901_, Ingredient.f_43901_);
    }

    private Metal(ResourceLocation id, int tier, Fluid fluid, float meltTemperature, float specificHeatCapacity, @Nullable Ingredient ingots, @Nullable Ingredient doubleIngots, @Nullable Ingredient sheets) {
        this.id = id;
        this.textureId = Helpers.resourceLocation(id.m_135827_(), "block/metal/block/" + id.m_135815_());
        this.softTextureId = Helpers.resourceLocation(id.m_135827_(), "block/metal/smooth/" + id.m_135815_());
        this.tier = tier;
        this.fluid = fluid;
        this.meltTemperature = meltTemperature;
        this.specificHeatCapacity = specificHeatCapacity;
        this.translationKey = "metal." + id.m_135827_() + "." + id.m_135815_();
        this.ingots = ingots;
        this.doubleIngots = doubleIngots;
        this.sheets = sheets;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.tier);
        buffer.m_130130_(BuiltInRegistries.f_257020_.m_7447_((Object)this.fluid));
        buffer.writeFloat(this.meltTemperature);
        buffer.writeFloat(this.specificHeatCapacity);
        Helpers.encodeNullable(this.ingots, buffer, Ingredient::m_43923_);
        Helpers.encodeNullable(this.doubleIngots, buffer, Ingredient::m_43923_);
        Helpers.encodeNullable(this.sheets, buffer, Ingredient::m_43923_);
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public ResourceLocation getTextureId() {
        return this.textureId;
    }

    public ResourceLocation getSoftTextureId() {
        return this.softTextureId;
    }

    public int getTier() {
        return this.tier;
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    public float getMeltTemperature() {
        return this.meltTemperature;
    }

    public float getHeatCapacity(float mB) {
        return this.getSpecificHeatCapacity() * mB;
    }

    public float getSpecificHeatCapacity() {
        return this.specificHeatCapacity;
    }

    public MutableComponent getDisplayName() {
        return Component.m_237115_((String)this.translationKey);
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    public boolean isIngot(ItemStack stack) {
        return this.ingots != null && this.ingots.test(stack);
    }

    public boolean isDoubleIngot(ItemStack stack) {
        return this.doubleIngots != null && this.doubleIngots.test(stack);
    }

    public boolean isSheet(ItemStack stack) {
        return this.sheets != null && this.sheets.test(stack);
    }

    @Nullable
    @VisibleForTesting
    public Ingredient getIngotIngredient() {
        return this.ingots;
    }

    @Nullable
    @VisibleForTesting
    public Ingredient getDoubleIngotIngredient() {
        return this.doubleIngots;
    }

    @Nullable
    @VisibleForTesting
    public Ingredient getSheetIngredient() {
        return this.sheets;
    }

    public static class Packet
    extends DataManagerSyncPacket<Metal> {
    }

    private static enum Type {
        DEFAULT(metal -> true),
        PART(Default::hasParts),
        TOOL(Default::hasTools),
        ARMOR(Default::hasArmor),
        UTILITY(Default::hasUtilities);

        private final Predicate<Default> predicate;

        private Type(Predicate<Default> predicate) {
            this.predicate = predicate;
        }

        boolean hasType(Default metal) {
            return this.predicate.test(metal);
        }
    }

    public static enum ItemType {
        INGOT(Type.DEFAULT, true, metal -> new IngotItem(ItemType.properties(metal))),
        DOUBLE_INGOT(Type.PART, false),
        SHEET(Type.PART, false),
        DOUBLE_SHEET(Type.PART, false),
        ROD(Type.PART, false),
        TUYERE(Type.TOOL, metal -> new TieredItem(metal.toolTier(), ItemType.properties(metal))),
        FISH_HOOK(Type.TOOL, false),
        FISHING_ROD(Type.TOOL, metal -> new TFCFishingRodItem(ItemType.properties(metal).m_41499_(metal.toolTier().m_6609_()), metal.toolTier())),
        UNFINISHED_LAMP(Type.UTILITY, metal -> new Item(ItemType.properties(metal))),
        PICKAXE(Type.TOOL, metal -> new PickaxeItem(metal.toolTier(), (int)ToolItem.calculateVanillaAttackDamage(0.75f, metal.toolTier()), -2.8f, ItemType.properties(metal))),
        PICKAXE_HEAD(Type.TOOL, true),
        PROPICK(Type.TOOL, metal -> new PropickItem(metal.toolTier(), ToolItem.calculateVanillaAttackDamage(0.5f, metal.toolTier()), -2.8f, ItemType.properties(metal))),
        PROPICK_HEAD(Type.TOOL, true),
        AXE(Type.TOOL, metal -> new AxeItem(metal.toolTier(), ToolItem.calculateVanillaAttackDamage(1.5f, metal.toolTier()), -3.1f, ItemType.properties(metal))),
        AXE_HEAD(Type.TOOL, true),
        SHOVEL(Type.TOOL, metal -> new ShovelItem(metal.toolTier(), ToolItem.calculateVanillaAttackDamage(0.875f, metal.toolTier()), -3.0f, ItemType.properties(metal))),
        SHOVEL_HEAD(Type.TOOL, true),
        HOE(Type.TOOL, metal -> new TFCHoeItem(metal.toolTier(), -1, -2.0f, ItemType.properties(metal))),
        HOE_HEAD(Type.TOOL, true),
        CHISEL(Type.TOOL, metal -> new ChiselItem(metal.toolTier(), ToolItem.calculateVanillaAttackDamage(0.27f, metal.toolTier()), -1.5f, ItemType.properties(metal))),
        CHISEL_HEAD(Type.TOOL, true),
        HAMMER(Type.TOOL, metal -> new HammerItem(metal.toolTier(), ToolItem.calculateVanillaAttackDamage(1.0f, metal.toolTier()), -3.0f, ItemType.properties(metal), metal.m_7912_())),
        HAMMER_HEAD(Type.TOOL, true),
        SAW(Type.TOOL, metal -> new AxeItem(metal.toolTier(), ToolItem.calculateVanillaAttackDamage(0.5f, metal.toolTier()), -3.0f, ItemType.properties(metal))),
        SAW_BLADE(Type.TOOL, true),
        JAVELIN(Type.TOOL, metal -> new JavelinItem(metal.toolTier(), ToolItem.calculateVanillaAttackDamage(0.7f, metal.toolTier()), 1.5f * metal.toolTier().m_6631_(), -2.6f, ItemType.properties(metal), metal.m_7912_())),
        JAVELIN_HEAD(Type.TOOL, true),
        SWORD(Type.TOOL, metal -> new SwordItem(metal.toolTier(), (int)ToolItem.calculateVanillaAttackDamage(1.0f, metal.toolTier()), -2.4f, ItemType.properties(metal))),
        SWORD_BLADE(Type.TOOL, true),
        MACE(Type.TOOL, metal -> new MaceItem(metal.toolTier(), (int)ToolItem.calculateVanillaAttackDamage(1.3f, metal.toolTier()), -3.0f, ItemType.properties(metal))),
        MACE_HEAD(Type.TOOL, true),
        KNIFE(Type.TOOL, metal -> new ToolItem(metal.toolTier(), ToolItem.calculateVanillaAttackDamage(0.6f, metal.toolTier()), -2.0f, TFCTags.Blocks.MINEABLE_WITH_KNIFE, ItemType.properties(metal))),
        KNIFE_BLADE(Type.TOOL, true),
        SCYTHE(Type.TOOL, metal -> new ScytheItem(metal.toolTier(), ToolItem.calculateVanillaAttackDamage(0.7f, metal.toolTier()), -3.2f, TFCTags.Blocks.MINEABLE_WITH_SCYTHE, ItemType.properties(metal))),
        SCYTHE_BLADE(Type.TOOL, true),
        SHEARS(Type.TOOL, metal -> new ShearsItem(ItemType.properties(metal).m_41499_(metal.toolTier().m_6609_()))),
        UNFINISHED_HELMET(Type.ARMOR, false),
        HELMET(Type.ARMOR, metal -> new ArmorItem(metal.armorTier(), ArmorItem.Type.HELMET, ItemType.properties(metal))),
        UNFINISHED_CHESTPLATE(Type.ARMOR, false),
        CHESTPLATE(Type.ARMOR, metal -> new ArmorItem(metal.armorTier(), ArmorItem.Type.CHESTPLATE, ItemType.properties(metal))),
        UNFINISHED_GREAVES(Type.ARMOR, false),
        GREAVES(Type.ARMOR, metal -> new ArmorItem(metal.armorTier(), ArmorItem.Type.LEGGINGS, ItemType.properties(metal))),
        UNFINISHED_BOOTS(Type.ARMOR, false),
        BOOTS(Type.ARMOR, metal -> new ArmorItem(metal.armorTier(), ArmorItem.Type.BOOTS, ItemType.properties(metal))),
        HORSE_ARMOR(Type.ARMOR, metal -> new HorseArmorItem(Mth.m_14107_((double)((double)metal.armorTier().m_7366_(ArmorItem.Type.CHESTPLATE) * 1.5)), Helpers.identifier("textures/entity/animal/horse_armor/" + metal.m_7912_() + ".png"), ItemType.properties(metal))),
        SHIELD(Type.TOOL, metal -> new TFCShieldItem(metal.toolTier(), ItemType.properties(metal)));

        private final Function<RegistryMetal, Item> itemFactory;
        private final Type type;
        private final boolean mold;

        public static Item.Properties properties(RegistryMetal metal) {
            return new Item.Properties().m_41497_(metal.getRarity());
        }

        private ItemType(Type type, boolean mold) {
            this(type, mold, metal -> new Item(ItemType.properties(metal)));
        }

        private ItemType(Type type, Function<RegistryMetal, Item> itemFactory) {
            this(type, false, itemFactory);
        }

        private ItemType(Type type, boolean mold, Function<RegistryMetal, Item> itemFactory) {
            this.type = type;
            this.mold = mold;
            this.itemFactory = itemFactory;
        }

        public Item create(RegistryMetal metal) {
            return this.itemFactory.apply(metal);
        }

        public boolean has(Default metal) {
            return this.type.hasType(metal);
        }

        public boolean hasMold() {
            return this.mold;
        }
    }

    public static enum BlockType {
        ANVIL(Type.UTILITY, metal -> new AnvilBlock(ExtendedProperties.of().mapColor(metal.mapColor()).noOcclusion().sound(SoundType.f_56749_).strength(10.0f, 10.0f).requiresCorrectToolForDrops().blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.ANVIL), metal.metalTier())),
        BLOCK(Type.PART, metal -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(metal.mapColor()).m_280658_(NoteBlockInstrument.IRON_XYLOPHONE).m_60999_().m_60913_(5.0f, 6.0f).m_60918_(SoundType.f_56743_))),
        BLOCK_SLAB(Type.PART, metal -> new SlabBlock(BlockBehaviour.Properties.m_284310_().m_284180_(metal.mapColor()).m_280658_(NoteBlockInstrument.IRON_XYLOPHONE).m_60999_().m_60913_(5.0f, 6.0f).m_60918_(SoundType.f_56743_))),
        BLOCK_STAIRS(Type.PART, metal -> new StairBlock(() -> metal.getFullBlock().get().m_49966_(), BlockBehaviour.Properties.m_284310_().m_284180_(metal.mapColor()).m_280658_(NoteBlockInstrument.IRON_XYLOPHONE).m_60999_().m_60913_(5.0f, 6.0f).m_60918_(SoundType.f_56743_))),
        BARS(Type.UTILITY, metal -> new IronBarsBlock(BlockBehaviour.Properties.m_284310_().m_284180_(metal.mapColor()).m_60999_().m_60913_(6.0f, 7.0f).m_60918_(SoundType.f_56743_).m_60955_())),
        CHAIN(Type.UTILITY, metal -> new TFCChainBlock(BlockBehaviour.Properties.m_284310_().m_284180_(metal.mapColor()).m_60999_().m_60913_(5.0f, 6.0f).m_60918_(SoundType.f_56728_).m_60953_(TFCBlocks.lavaLoggedBlockEmission()))),
        LAMP(Type.UTILITY, metal -> new LampBlock(ExtendedProperties.of().mapColor(metal.mapColor()).noOcclusion().sound(SoundType.f_56762_).strength(4.0f, 10.0f).randomTicks().pushReaction(PushReaction.DESTROY).lightLevel(state -> (Boolean)state.m_61143_((Property)LampBlock.LIT) != false ? 15 : 0).blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.LAMP)), (block, properties) -> new LampBlockItem((Block)block, properties.m_41487_(1))),
        TRAPDOOR(Type.UTILITY, metal -> new TrapDoorBlock(BlockBehaviour.Properties.m_284310_().m_284180_(metal.mapColor()).m_60999_().m_60978_(5.0f).m_60918_(SoundType.f_56743_).m_60955_().m_60922_(TFCBlocks::never), BlockSetType.f_271132_));

        private final Function<RegistryMetal, Block> blockFactory;
        private final BiFunction<Block, Item.Properties, ? extends BlockItem> blockItemFactory;
        private final Type type;
        private final String serializedName;

        private BlockType(Type type, Function<RegistryMetal, Block> blockFactory, BiFunction<Block, Item.Properties, ? extends BlockItem> blockItemFactory) {
            this.type = type;
            this.blockFactory = blockFactory;
            this.blockItemFactory = blockItemFactory;
            this.serializedName = this.name().toLowerCase(Locale.ROOT);
        }

        private BlockType(Type type, Function<RegistryMetal, Block> blockFactory) {
            this(type, blockFactory, BlockItem::new);
        }

        public Supplier<Block> create(RegistryMetal metal) {
            return () -> this.blockFactory.apply(metal);
        }

        public Function<Block, BlockItem> createBlockItem(Item.Properties properties) {
            return block -> this.blockItemFactory.apply((Block)block, properties);
        }

        public boolean has(Default metal) {
            return this.type.hasType(metal);
        }

        public String createName(RegistryMetal metal) {
            if (this == BLOCK_SLAB || this == BLOCK_STAIRS) {
                return BLOCK.createName(metal) + (this == BLOCK_SLAB ? "_slab" : "_stairs");
            }
            return "metal/" + this.serializedName + "/" + metal.m_7912_();
        }
    }

    public static enum Default implements StringRepresentable,
    RegistryMetal
    {
        BISMUTH(-12031118, MapColor.f_283856_, Rarity.COMMON, true, false, false),
        BISMUTH_BRONZE(-12480945, MapColor.f_283908_, Rarity.COMMON, Tier.TIER_II, TFCTiers.BISMUTH_BRONZE, TFCArmorMaterials.BISMUTH_BRONZE, true, true, true),
        BLACK_BRONZE(-12900810, MapColor.f_283870_, Rarity.COMMON, Tier.TIER_II, TFCTiers.BLACK_BRONZE, TFCArmorMaterials.BLACK_BRONZE, true, true, true),
        BRONZE(-6911698, MapColor.f_283895_, Rarity.COMMON, Tier.TIER_II, TFCTiers.BRONZE, TFCArmorMaterials.BRONZE, true, true, true),
        BRASS(-8626637, MapColor.f_283757_, Rarity.COMMON, true, false, false),
        COPPER(-4833241, MapColor.f_283750_, Rarity.COMMON, Tier.TIER_I, TFCTiers.COPPER, TFCArmorMaterials.COPPER, true, true, true),
        GOLD(-2310373, MapColor.f_283757_, Rarity.COMMON, true, false, false),
        NICKEL(-11645380, MapColor.f_283947_, Rarity.COMMON, true, false, false),
        ROSE_GOLD(-1347273, MapColor.f_283765_, Rarity.COMMON, true, false, false),
        SILVER(-7039851, MapColor.f_283779_, Rarity.COMMON, true, false, false),
        TIN(-7297861, MapColor.f_283779_, Rarity.COMMON, true, false, false),
        ZINC(-4474428, MapColor.f_283779_, Rarity.COMMON, true, false, false),
        STERLING_SILVER(-5467525, MapColor.f_283779_, Rarity.COMMON, true, false, false),
        WROUGHT_IRON(-6776681, MapColor.f_283906_, Rarity.COMMON, Tier.TIER_III, TFCTiers.WROUGHT_IRON, TFCArmorMaterials.WROUGHT_IRON, true, true, true),
        CAST_IRON(-6776681, MapColor.f_283748_, Rarity.COMMON, true, false, false),
        PIG_IRON(-9807524, MapColor.f_283818_, Rarity.COMMON, false, false, false),
        STEEL(-10526881, MapColor.f_283779_, Rarity.UNCOMMON, Tier.TIER_IV, TFCTiers.STEEL, TFCArmorMaterials.STEEL, true, true, true),
        BLACK_STEEL(-15658735, MapColor.f_283927_, Rarity.RARE, Tier.TIER_V, TFCTiers.BLACK_STEEL, TFCArmorMaterials.BLACK_STEEL, true, true, true),
        BLUE_STEEL(-13806186, MapColor.f_283743_, Rarity.EPIC, Tier.TIER_VI, TFCTiers.BLUE_STEEL, TFCArmorMaterials.BLUE_STEEL, true, true, true),
        RED_STEEL(-9435901, MapColor.f_283913_, Rarity.EPIC, Tier.TIER_VI, TFCTiers.RED_STEEL, TFCArmorMaterials.RED_STEEL, true, true, true),
        WEAK_STEEL(-15658735, MapColor.f_283818_, Rarity.COMMON, false, false, false),
        WEAK_BLUE_STEEL(-13806186, MapColor.f_283743_, Rarity.COMMON, false, false, false),
        WEAK_RED_STEEL(-9435901, MapColor.f_283913_, Rarity.COMMON, false, false, false),
        HIGH_CARBON_STEEL(-10526881, MapColor.f_283818_, Rarity.COMMON, false, false, false),
        HIGH_CARBON_BLACK_STEEL(-15658735, MapColor.f_283927_, Rarity.COMMON, false, false, false),
        HIGH_CARBON_BLUE_STEEL(-13806186, MapColor.f_283743_, Rarity.COMMON, false, false, false),
        HIGH_CARBON_RED_STEEL(-9435901, MapColor.f_283913_, Rarity.COMMON, false, false, false),
        UNKNOWN(-13685977, MapColor.f_283927_, Rarity.COMMON, false, false, false);

        private final String serializedName = this.name().toLowerCase(Locale.ROOT);
        private final boolean parts;
        private final boolean armor;
        private final boolean utility;
        private final Tier metalTier;
        @Nullable
        private final net.minecraft.world.item.Tier toolTier;
        @Nullable
        private final ArmorMaterial armorTier;
        private final MapColor mapColor;
        private final Rarity rarity;
        private final int color;

        private Default(int color, MapColor mapColor, Rarity rarity, boolean parts, boolean armor, boolean utility) {
            this(color, mapColor, rarity, Tier.TIER_0, null, null, parts, armor, utility);
        }

        private Default(int color, MapColor mapColor, @Nullable Rarity rarity, @Nullable Tier metalTier, net.minecraft.world.item.Tier toolTier, ArmorMaterial armorTier, boolean parts, boolean armor, boolean utility) {
            this.metalTier = metalTier;
            this.toolTier = toolTier;
            this.armorTier = armorTier;
            this.rarity = rarity;
            this.mapColor = mapColor;
            this.color = color;
            this.parts = parts;
            this.armor = armor;
            this.utility = utility;
        }

        public String m_7912_() {
            return this.serializedName;
        }

        public int getColor() {
            return this.color;
        }

        @Override
        public Rarity getRarity() {
            return this.rarity;
        }

        public boolean hasParts() {
            return this.parts;
        }

        public boolean hasArmor() {
            return this.armor;
        }

        public boolean hasTools() {
            return this.toolTier != null;
        }

        public boolean hasUtilities() {
            return this.utility;
        }

        @Override
        public net.minecraft.world.item.Tier toolTier() {
            return Objects.requireNonNull(this.toolTier, "Tried to get non-existent tier from " + this.name());
        }

        @Override
        public ArmorMaterial armorTier() {
            return Objects.requireNonNull(this.armorTier, "Tried to get non-existent armor tier from " + this.name());
        }

        @Override
        public Tier metalTier() {
            return this.metalTier;
        }

        @Override
        public MapColor mapColor() {
            return this.mapColor;
        }

        @Override
        public Supplier<Block> getFullBlock() {
            return (Supplier)TFCBlocks.METALS.get(this).get((Object)BlockType.BLOCK);
        }
    }

    public static enum Tier {
        TIER_0,
        TIER_I,
        TIER_II,
        TIER_III,
        TIER_IV,
        TIER_V,
        TIER_VI;

        private static final Tier[] VALUES;

        public static Tier valueOf(int tier) {
            return tier < 0 || tier > VALUES.length ? TIER_I : VALUES[tier];
        }

        public Tier next() {
            return this == TIER_VI ? TIER_VI : VALUES[this.ordinal() + 1];
        }

        public Tier previous() {
            return this == TIER_0 ? TIER_0 : VALUES[this.ordinal() - 1];
        }

        public Component getDisplayName() {
            return Helpers.translateEnum(this);
        }

        static {
            VALUES = Tier.values();
        }
    }
}

