/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util;

import com.google.gson.JsonObject;
import net.dries007.tfc.common.recipes.ingredients.ItemStackIngredient;
import net.dries007.tfc.network.DataManagerSyncPacket;
import net.dries007.tfc.util.DataManager;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.JsonHelpers;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public final class KnappingType {
    public static final DataManager<KnappingType> MANAGER = new DataManager<KnappingType>(Helpers.identifier("knapping_types"), "knapping_types", KnappingType::new, KnappingType::new, KnappingType::encode, Packet::new);
    private final ResourceLocation id;
    private final ItemStackIngredient inputItem;
    private final int amountToConsume;
    private final SoundEvent clickSound;
    private final boolean consumeAfterComplete;
    private final boolean useDisabledTexture;
    private final boolean spawnsParticles;
    private final ItemStack jeiIconItem;

    @Nullable
    public static KnappingType get(Player player) {
        ItemStack stack = player.m_21205_();
        for (KnappingType type : MANAGER.getValues()) {
            if (!type.inputItem.test(stack)) continue;
            return type;
        }
        return null;
    }

    KnappingType(ResourceLocation id, JsonObject json) {
        this.id = id;
        this.inputItem = ItemStackIngredient.fromJson(JsonHelpers.m_13930_((JsonObject)json, (String)"input"));
        this.amountToConsume = json.has("amount_to_consume") ? JsonHelpers.m_13927_((JsonObject)json, (String)"amount_to_consume") : this.inputItem.count();
        this.clickSound = (SoundEvent)JsonHelpers.getRegistryEntry(json, "click_sound", BuiltInRegistries.f_256894_);
        this.consumeAfterComplete = JsonHelpers.m_13912_((JsonObject)json, (String)"consume_after_complete");
        this.useDisabledTexture = JsonHelpers.m_13912_((JsonObject)json, (String)"use_disabled_texture");
        this.spawnsParticles = JsonHelpers.m_13912_((JsonObject)json, (String)"spawns_particles");
        this.jeiIconItem = JsonHelpers.getItemStack(json, "jei_icon_item");
    }

    KnappingType(ResourceLocation id, FriendlyByteBuf buffer) {
        this.id = id;
        this.inputItem = ItemStackIngredient.fromNetwork(buffer);
        this.amountToConsume = buffer.m_130242_();
        this.clickSound = (SoundEvent)BuiltInRegistries.f_256894_.m_200957_(buffer.m_130242_());
        this.consumeAfterComplete = buffer.readBoolean();
        this.useDisabledTexture = buffer.readBoolean();
        this.spawnsParticles = buffer.readBoolean();
        this.jeiIconItem = buffer.m_130267_();
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public ItemStackIngredient inputItem() {
        return this.inputItem;
    }

    public boolean consumeAfterComplete() {
        return this.consumeAfterComplete;
    }

    public int amountToConsume() {
        return this.amountToConsume;
    }

    public boolean spawnsParticles() {
        return this.spawnsParticles;
    }

    public boolean usesDisabledTexture() {
        return this.useDisabledTexture;
    }

    public SoundEvent clickSound() {
        return this.clickSound;
    }

    public ItemStack jeiIcon() {
        return this.jeiIconItem;
    }

    void encode(FriendlyByteBuf buffer) {
        this.inputItem.toNetwork(buffer);
        buffer.m_130130_(this.amountToConsume);
        buffer.m_130130_(BuiltInRegistries.f_256894_.m_7447_((Object)this.clickSound));
        buffer.writeBoolean(this.consumeAfterComplete);
        buffer.writeBoolean(this.useDisabledTexture);
        buffer.writeBoolean(this.spawnsParticles);
        buffer.m_130055_(this.jeiIconItem);
    }

    public static final class Packet
    extends DataManagerSyncPacket<KnappingType> {
    }
}

