/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.dries007.tfc.network.DataManagerSyncPacket;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.SelfTests;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class DataManager<T>
extends SimpleJsonResourceReloadListener {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final Gson GSON = new Gson();
    private static final Map<Class<?>, DataManager<?>> NETWORK_TYPES = new HashMap();
    protected final BiMap<ResourceLocation, T> types;
    protected final String typeName;
    @Nullable
    protected final BiFunction<ResourceLocation, FriendlyByteBuf, T> networkFactory;
    @Nullable
    protected final BiConsumer<T, FriendlyByteBuf> networkEncoder;
    @Nullable
    protected final Supplier<? extends DataManagerSyncPacket<T>> networkPacketFactory;
    private final BiFunction<ResourceLocation, JsonObject, T> factory;
    private final Map<ResourceLocation, Reference<T>> references;
    private final Object referencesLock = new Object();

    private static <T> void assertUniquePacketTypes(DataManager<?> instance, @Nullable Supplier<? extends DataManagerSyncPacket<T>> networkPacketFactory) {
        Class<?> packetType;
        DataManager<?> old;
        if (Helpers.ASSERTIONS_ENABLED && networkPacketFactory != null && (old = NETWORK_TYPES.put(packetType = networkPacketFactory.get().getClass(), instance)) != null) {
            throw new IllegalStateException("Packet class " + packetType.getSimpleName() + " registered for managers for " + old.typeName + " and " + instance.typeName);
        }
    }

    public DataManager(ResourceLocation domain, String typeName, BiFunction<ResourceLocation, JsonObject, T> factory) {
        this(domain, typeName, factory, null, null, null);
    }

    public DataManager(ResourceLocation domain, String typeName, BiFunction<ResourceLocation, JsonObject, T> factory, @Nullable BiFunction<ResourceLocation, FriendlyByteBuf, T> networkFactory, @Nullable BiConsumer<T, FriendlyByteBuf> networkEncoder, @Nullable Supplier<? extends DataManagerSyncPacket<T>> networkPacketFactory) {
        super(GSON, domain.m_135827_() + "/" + domain.m_135815_());
        DataManager.assertUniquePacketTypes(this, networkPacketFactory);
        this.factory = factory;
        this.references = new HashMap<ResourceLocation, Reference<T>>();
        this.networkFactory = networkFactory;
        this.networkEncoder = networkEncoder;
        this.networkPacketFactory = networkPacketFactory;
        this.types = HashBiMap.create();
        this.typeName = typeName;
    }

    @Nullable
    public T get(ResourceLocation id) {
        return (T)this.types.get((Object)id);
    }

    public T getOrThrow(ResourceLocation id) {
        Object t = this.types.get((Object)id);
        if (t == null) {
            throw new IllegalArgumentException("No " + this.typeName + " with id " + id);
        }
        return (T)t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reference<T> getReference(ResourceLocation id) {
        Reference ref;
        Object object = this.referencesLock;
        synchronized (object) {
            ref = this.references.computeIfAbsent(id, key -> new Reference<Object>((ResourceLocation)key, this.types.get(key)));
        }
        return ref;
    }

    public Set<T> getValues() {
        return this.types.values();
    }

    public DataManagerSyncPacket<T> createSyncPacket() {
        return this.createEmptyPacket().with((Map<ResourceLocation, T>)this.types);
    }

    public DataManagerSyncPacket<T> createEmptyPacket() {
        assert (this.networkPacketFactory != null);
        return this.networkPacketFactory.get();
    }

    public T read(ResourceLocation id, JsonObject obj) {
        return this.factory.apply(id, obj);
    }

    public void rawToNetwork(FriendlyByteBuf buffer, T element) {
        assert (this.networkEncoder != null);
        this.networkEncoder.accept(element, buffer);
    }

    public T rawFromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
        assert (this.networkFactory != null);
        return this.networkFactory.apply(id, buffer);
    }

    public void onSync(NetworkEvent.Context context, Map<ResourceLocation, T> elements) {
        if (context.getNetworkManager().m_129531_()) {
            LOGGER.info("Ignored {}(s) sync from logical server", (Object)this.typeName);
        } else {
            this.types.clear();
            this.types.putAll(elements);
            this.updateReferences();
            LOGGER.info("Received {} {}(s) from physical server", (Object)this.types.size(), (Object)this.typeName);
        }
    }

    protected void apply(Map<ResourceLocation, JsonElement> elements, ResourceManager resourceManagerIn, ProfilerFiller profilerIn) {
        this.types.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : elements.entrySet()) {
            ResourceLocation name = entry.getKey();
            JsonObject json = GsonHelper.m_13918_((JsonElement)entry.getValue(), (String)this.typeName);
            try {
                if (CraftingHelper.processConditions((JsonObject)json, (String)"conditions", (ICondition.IContext)ICondition.IContext.EMPTY)) {
                    T object = this.read(name, json);
                    this.types.put((Object)name, object);
                    continue;
                }
                LOGGER.debug("Skipping loading {} '{}' as it's conditions were not met", (Object)this.typeName, (Object)name);
            }
            catch (JsonParseException | IllegalArgumentException e) {
                LOGGER.error("{} '{}' failed to parse. {}: {}", new Object[]{this.typeName, name, e.getClass().getSimpleName(), e.getMessage()});
                SelfTests.reportExternalError();
            }
        }
        this.updateReferences();
        LOGGER.info("Loaded {} {}(s).", (Object)this.types.size(), (Object)this.typeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateReferences() {
        Object object = this.referencesLock;
        synchronized (object) {
            ArrayList<ResourceLocation> unboundReferences = new ArrayList<ResourceLocation>();
            for (Map.Entry<ResourceLocation, Reference<T>> entry : this.references.entrySet()) {
                T value = this.get(entry.getKey());
                if (value == null) {
                    unboundReferences.add(entry.getKey());
                }
                entry.getValue().value = Optional.ofNullable(value);
            }
            if (!unboundReferences.isEmpty()) {
                LOGGER.error("There were {} '{}' that were used but not defined: {}", new Object[]{unboundReferences.size(), this.typeName, unboundReferences});
                SelfTests.reportExternalError();
            }
        }
    }

    public static class Reference<T>
    implements Supplier<T> {
        private final ResourceLocation id;
        private Optional<T> value;

        Reference(ResourceLocation id, @Nullable T value) {
            this.id = id;
            this.value = Optional.ofNullable(value);
        }

        public ResourceLocation id() {
            return this.id;
        }

        @Override
        public T get() {
            return this.value.orElseThrow(() -> new IllegalStateException("Referencing value before loaded"));
        }
    }
}

