/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.network;

import net.dries007.tfc.client.ClientHelpers;
import net.dries007.tfc.common.capabilities.food.Nutrient;
import net.dries007.tfc.common.capabilities.food.TFCFoodData;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;

public record FoodDataUpdatePacket(float[] nutrients, float thirst) {
    FoodDataUpdatePacket(FriendlyByteBuf buffer) {
        this(FoodDataUpdatePacket.readNutrients(buffer), buffer.readFloat());
    }

    private static float[] readNutrients(FriendlyByteBuf buffer) {
        float[] nutrients = new float[Nutrient.TOTAL];
        for (int i = 0; i < nutrients.length; ++i) {
            nutrients[i] = buffer.readFloat();
        }
        return nutrients;
    }

    void encode(FriendlyByteBuf buffer) {
        for (float nutrient : this.nutrients) {
            buffer.writeFloat(nutrient);
        }
        buffer.writeFloat(this.thirst);
    }

    void handle() {
        FoodData foodData;
        Player player = ClientHelpers.getPlayer();
        if (player != null && (foodData = player.m_36324_()) instanceof TFCFoodData) {
            TFCFoodData data = (TFCFoodData)foodData;
            data.onClientUpdate(this.nutrients, this.thirst);
        }
    }
}

