/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.network;

import net.dries007.tfc.client.ClientHelpers;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.dries007.tfc.world.chunkdata.ForestType;
import net.dries007.tfc.world.chunkdata.LerpFloatLayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;

public record ChunkWatchPacket(int chunkX, int chunkZ, LerpFloatLayer rainfallLayer, LerpFloatLayer temperatureLayer, ForestType forestType, float forestWeirdness, float forestDensity) {
    ChunkWatchPacket(FriendlyByteBuf buffer) {
        this(buffer.m_130242_(), buffer.m_130242_(), new LerpFloatLayer(buffer), new LerpFloatLayer(buffer), ForestType.valueOf(buffer.readByte()), buffer.readFloat(), buffer.readFloat());
    }

    void encode(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.chunkX);
        buffer.m_130130_(this.chunkZ);
        this.rainfallLayer.encode(buffer);
        this.temperatureLayer.encode(buffer);
        buffer.writeByte(this.forestType.ordinal());
        buffer.writeFloat(this.forestDensity);
        buffer.writeFloat(this.forestWeirdness);
    }

    void handle() {
        Level level = ClientHelpers.getLevel();
        ChunkPos chunkPos = new ChunkPos(this.chunkX, this.chunkZ);
        if (level != null) {
            ChunkData data = ChunkData.get((LevelReader)level, chunkPos);
            if (data.status() == ChunkData.Status.INVALID) {
                data = ChunkData.queueClientChunkDataForLoad(chunkPos);
            }
            data.onUpdatePacket(this.rainfallLayer, this.temperatureLayer, this.forestType, this.forestDensity, this.forestWeirdness);
        }
    }
}

