/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.mixin;

import net.dries007.tfc.client.ClimateRenderCache;
import net.dries007.tfc.util.EnvironmentHelpers;
import net.dries007.tfc.util.climate.Climate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Level.class})
public abstract class LevelMixin {
    @Redirect(method={"isRainingAt"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/biome/Biome;getPrecipitationAt(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/biome/Biome$Precipitation;"))
    private Biome.Precipitation isRainingAtCheckClimateAndEnvironment(Biome biome, BlockPos pos) {
        Level level = (Level)this;
        return EnvironmentHelpers.isRainingOrSnowing(level, pos) ? Climate.getPrecipitation(level, pos) : Biome.Precipitation.NONE;
    }

    @Inject(method={"getRainLevel"}, at={@At(value="HEAD")}, cancellable=true)
    private void getEnvironmentAdjustedRainLevelOnClient(float partialTick, CallbackInfoReturnable<Float> cir) {
        if (((Level)this).m_5776_()) {
            cir.setReturnValue((Object)Float.valueOf(ClimateRenderCache.INSTANCE.getRainLevel(partialTick)));
        }
    }
}

