/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.mixin;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.util.Helpers;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.material.Fluid;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class EntityMixin {
    @Inject(method={"updateFluidHeightAndDoFluidPushing(Lnet/minecraft/tags/TagKey;D)Z"}, at={@At(value="RETURN")}, cancellable=true)
    private void fixUpdateFluidPushingToTreatWaterLikeFluidsAsWater(TagKey<Fluid> fluidTag, double motionScale, CallbackInfoReturnable<Boolean> cir) {
        if (fluidTag == TFCTags.Fluids.WATER_LIKE) {
            cir.setReturnValue((Object)(cir.getReturnValueZ() || FluidHelpers.isInWaterLikeFluid((Entity)this) ? 1 : 0));
        }
    }

    @Inject(method={"isEyeInFluid"}, at={@At(value="RETURN")}, cancellable=true)
    private void fixIsEyeInFluidToTreatWaterLikeFluidsAsWater(TagKey<Fluid> fluidTag, CallbackInfoReturnable<Boolean> cir) {
        if (fluidTag == TFCTags.Fluids.WATER_LIKE) {
            cir.setReturnValue((Object)(cir.getReturnValueZ() || FluidHelpers.isEyeInWaterLikeFluid((Entity)this) ? 1 : 0));
        }
    }

    @Inject(method={"checkInsideBlocks"}, at={@At(value="HEAD")})
    private void checkInsideBlocksForCustomSlowEffects(CallbackInfo ci) {
        Helpers.slowEntityInsideBlocks((Entity)this);
    }
}

