/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.mixin;

import java.util.Optional;
import java.util.function.Supplier;
import net.dries007.tfc.util.climate.Climate;
import net.dries007.tfc.world.biome.BiomeBridge;
import net.dries007.tfc.world.biome.BiomeExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={Biome.class})
public abstract class BiomeMixin
implements BiomeBridge {
    @Nullable
    private Optional<BiomeExtension> tfc$cachedExtension;

    @Override
    @Nullable
    public BiomeExtension tfc$getExtension(@NotNull Supplier<BiomeExtension> init) {
        if (this.tfc$cachedExtension == null) {
            this.tfc$cachedExtension = Optional.ofNullable(init.get());
        }
        return this.tfc$cachedExtension.orElse(null);
    }

    @Redirect(method={"shouldSnow"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/biome/Biome;warmEnoughToRain(Lnet/minecraft/core/BlockPos;)Z"))
    private boolean betterShouldSnowCheck(Biome biome, BlockPos pos, LevelReader level) {
        return Climate.warmEnoughToRain(level, pos, biome);
    }

    @Redirect(method={"shouldFreeze(Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;Z)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/biome/Biome;warmEnoughToRain(Lnet/minecraft/core/BlockPos;)Z"))
    private boolean shouldFreezeWithClimate(Biome biome, BlockPos pos, LevelReader level) {
        return Climate.warmEnoughToRain(level, pos, biome);
    }
}

