/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.config;

import net.dries007.tfc.common.capabilities.heat.Heat;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.Nullable;

public enum TemperatureDisplayStyle {
    COLOR(temperature -> {
        Heat heat = Heat.getHeat(temperature);
        if (heat != null) {
            MutableComponent base = heat.getDisplayName();
            if (heat != Heat.BRILLIANT_WHITE) {
                for (int i = 1; i <= 4; ++i) {
                    if (temperature <= heat.getMin() + (float)i * 0.2f * (heat.getMax() - heat.getMin())) continue;
                    base.m_130946_("\u066d");
                }
            }
            return base;
        }
        return null;
    }),
    CELSIUS(temperature -> Component.m_237110_((String)"tfc.tooltip.temperature_celsius", (Object[])new Object[]{String.format("%.0f", Float.valueOf(temperature))})),
    FAHRENHEIT(temperature -> Component.m_237110_((String)"tfc.tooltip.temperature_fahrenheit", (Object[])new Object[]{String.format("%.0f", Float.valueOf(temperature * 1.8f + 32.0f))})),
    RANKINE(temperature -> Component.m_237110_((String)"tfc.tooltip.temperature_rankine", (Object[])new Object[]{String.format("%.0f", Float.valueOf(temperature * 1.8f + 32.0f - 459.67f))})),
    KELVIN(temperature -> Component.m_237110_((String)"tfc.tooltip.temperature_kelvin", (Object[])new Object[]{String.format("%.0f", Float.valueOf(temperature + 273.15f))}));

    private final Function formatter;

    private TemperatureDisplayStyle(Function formatter) {
        this.formatter = formatter;
    }

    @Nullable
    public MutableComponent format(float temperature) {
        return this.format(temperature, false);
    }

    @Nullable
    public MutableComponent format(float temperature, boolean fullRange) {
        if (temperature > 1.0f || fullRange) {
            return this.formatter.format(temperature);
        }
        return null;
    }

    @Nullable
    public MutableComponent formatColored(float temperature) {
        Heat heat = Heat.getHeat(temperature);
        MutableComponent tooltip = this.format(temperature, false);
        if (tooltip != null && heat != null) {
            tooltip.m_130940_(heat.getColor());
        }
        return tooltip;
    }

    @FunctionalInterface
    static interface Function {
        @Nullable
        public MutableComponent format(float var1);
    }
}

