/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.config;

import com.mojang.logging.LogUtils;
import net.dries007.tfc.config.ConfigBuilder;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.slf4j.Logger;

public class CommonConfig {
    private static final Logger LOGGER = LogUtils.getLogger();
    public final ForgeConfigSpec.ConfigValue<String> defaultWorldPreset;
    public final ForgeConfigSpec.IntValue defaultMonthLength;
    public final ForgeConfigSpec.IntValue defaultCalendarStartDay;
    private final ForgeConfigSpec.BooleanValue enableNetworkDebugging;
    private boolean hasLoggedNetworkDebugInfoMessage = false;
    public final ForgeConfigSpec.BooleanValue enableDatapackTests;

    CommonConfig(ConfigBuilder builder) {
        builder.push("general");
        this.defaultWorldPreset = builder.comment("If the TFC world preset 'tfc:overworld' should be set as the default world generation when creating a new world.").define("defaultWorldPreset", "tfc:overworld");
        builder.swap("calendar");
        this.defaultMonthLength = builder.comment("The number of days in a month, for newly created worlds.", "This can be modified in existing worlds using the /time command").define("defaultMonthLength", 8, 1, Integer.MAX_VALUE);
        this.defaultCalendarStartDay = builder.comment("The start date for newly created worlds, in a number of ticks, for newly created worlds", "This represents a number of days offset from January 1, 1000", "The default is (5 * daysInMonth) = 40, which starts at June 1, 1000 (with the default daysInMonth = 8)").define("defaultCalendarStartDay", 40, -1, Integer.MAX_VALUE);
        builder.swap("debug");
        this.enableNetworkDebugging = builder.comment("Enables a series of network fail-safes that are used to debug network connections between client and servers.", "Important: this MUST BE THE SAME as what the server has set, otherwise you are liable to see even stranger errors.").define("enableNetworkDebugging", !FMLEnvironment.production);
        this.enableDatapackTests = builder.comment("If enabled, TFC will validate that certain pieces of reloadable data fit the conditions we expect, for example heating recipes having heatable items. It will error or warn in the log if these conditions are not met.").define("enableDatapackTests", !FMLEnvironment.production);
    }

    public boolean enableNetworkDebugging() {
        if (!this.hasLoggedNetworkDebugInfoMessage) {
            this.hasLoggedNetworkDebugInfoMessage = true;
            LOGGER.info("TFC Network Debugging = {}", this.enableNetworkDebugging.get());
        }
        return (Boolean)this.enableNetworkDebugging.get();
    }
}

