/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.patchouli.component;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.SerializedName;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;
import net.dries007.tfc.compat.patchouli.PatchouliIntegration;
import net.dries007.tfc.compat.patchouli.component.CustomComponent;
import net.dries007.tfc.util.JsonHelpers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import vazkii.patchouli.api.IComponentRenderContext;
import vazkii.patchouli.api.IVariable;

public class TableComponent
extends CustomComponent {
    private static final Logger LOGGER = LogUtils.getLogger();
    @SerializedName(value="strings")
    JsonElement jsonStrings;
    @SerializedName(value="columns")
    String columnsString;
    @SerializedName(value="first_column_width")
    String firstColumnWidthString;
    @SerializedName(value="column_width")
    String columnWidthString;
    @SerializedName(value="row_height")
    String rowHeightString;
    @SerializedName(value="left_buffer")
    String leftBufferString;
    @SerializedName(value="top_buffer")
    String topBufferString;
    @SerializedName(value="title")
    JsonElement titleString;
    @SerializedName(value="legend")
    JsonElement legendString;
    @SerializedName(value="draw_background")
    String drawBackgroundString;
    @Nullable
    protected transient List<TableEntry> entries;
    protected transient int columns;
    protected transient int firstColumnWidth;
    protected transient int columnWidth;
    protected transient int rowHeight;
    protected transient int leftBuffer;
    protected transient int topBuffer;
    protected transient boolean drawBackground;
    @Nullable
    protected transient Component title;
    @Nullable
    protected transient List<TableEntry> legend;

    private static int convert(int color) {
        return FastColor.ARGB32.m_13660_((int)255, (int)FastColor.ARGB32.m_13665_((int)color), (int)FastColor.ARGB32.m_13667_((int)color), (int)FastColor.ARGB32.m_13669_((int)color));
    }

    @Override
    public void onVariablesAvailable(UnaryOperator<IVariable> lookup) {
        this.columns = ((IVariable)lookup.apply(IVariable.wrap((String)this.columnsString))).asNumber().intValue();
        this.firstColumnWidth = ((IVariable)lookup.apply(IVariable.wrap((String)this.firstColumnWidthString))).asNumber().intValue();
        this.columnWidth = ((IVariable)lookup.apply(IVariable.wrap((String)this.columnWidthString))).asNumber().intValue();
        this.rowHeight = ((IVariable)lookup.apply(IVariable.wrap((String)this.rowHeightString))).asNumber().intValue();
        this.leftBuffer = ((IVariable)lookup.apply(IVariable.wrap((String)this.leftBufferString))).asNumber().intValue();
        this.topBuffer = ((IVariable)lookup.apply(IVariable.wrap((String)this.topBufferString))).asNumber().intValue();
        this.drawBackground = ((IVariable)lookup.apply(IVariable.wrap((String)this.drawBackgroundString))).asBoolean();
        this.jsonStrings = ((IVariable)lookup.apply(IVariable.wrap((JsonElement)this.jsonStrings))).unwrap();
        this.titleString = ((IVariable)lookup.apply(IVariable.wrap((JsonElement)this.titleString))).unwrap();
        this.legendString = ((IVariable)lookup.apply(IVariable.wrap((JsonElement)this.legendString))).unwrap();
    }

    @Override
    public void build(int componentX, int componentY, int pageNum) {
        super.build(componentX, componentY, pageNum);
        this.entries = new ArrayList<TableEntry>();
        this.legend = new ArrayList<TableEntry>();
        try {
            JsonObject json;
            this.title = Component.Serializer.m_130691_((JsonElement)this.titleString);
            for (JsonElement element : this.jsonStrings.getAsJsonArray()) {
                json = element.getAsJsonObject();
                if (json.has("fill")) {
                    int color = Integer.decode(JsonHelpers.m_13906_((JsonObject)json, (String)"fill"));
                    this.entries.add(new TableEntry((Component)Component.m_237119_(), TableComponent.convert(color)));
                    continue;
                }
                this.asTextComponent(element).map(text -> new TableEntry((Component)text.m_6881_().m_130938_(style -> style.m_131150_(Minecraft.f_91058_)), 0)).ifPresent(this.entries::add);
            }
            for (JsonElement entry : this.legendString.getAsJsonArray()) {
                json = entry.getAsJsonObject();
                this.asTextComponent(json.get("text")).map(text -> {
                    int color = Integer.decode(JsonHelpers.m_13906_((JsonObject)json, (String)"color"));
                    return new TableEntry((Component)text.m_6881_().m_130948_(Style.f_131099_.m_131150_(Minecraft.f_91058_)), TableComponent.convert(color));
                }).ifPresent(this.legend::add);
            }
        }
        catch (JsonSyntaxException e) {
            LOGGER.error("Cannot parse table entries", (Throwable)e);
            this.entries.clear();
            this.legend.clear();
        }
    }

    @Override
    public void render(GuiGraphics graphics, IComponentRenderContext context, float partialTicks, int mouseX, int mouseY) {
        if (this.entries != null && !this.entries.isEmpty()) {
            this.renderSetup(graphics);
            graphics.m_280168_().m_252880_((float)this.x, (float)this.y, 0.0f);
            Font font = Minecraft.m_91087_().f_91062_;
            int leftStart = this.leftBuffer;
            int regularWidth = this.columnWidth;
            int totalWidth = this.columns * regularWidth + this.firstColumnWidth;
            int totalHeight = (Mth.m_14167_((float)((float)this.entries.size() / (float)this.columns)) - 1) * this.rowHeight;
            int xo = leftStart;
            int yo = this.topBuffer;
            graphics.m_280218_(PatchouliIntegration.TEXTURE, 86, -8, 186, 0, 70, 162);
            if (this.drawBackground) {
                graphics.m_280509_(xo + this.firstColumnWidth, yo + this.rowHeight, xo + totalWidth + 1, yo + totalHeight + 1, -13356240);
            }
            if (this.title != null) {
                graphics.m_280614_(font, this.title, 122 - font.m_92852_((FormattedText)this.title) / 2, 2, 0, false);
            }
            int index = 0;
            for (TableEntry entry : this.entries) {
                int width;
                int n = width = index == 0 ? this.firstColumnWidth : regularWidth;
                if (entry.text.m_214077_() != ComponentContents.f_237124_) {
                    if (!this.drawBackground) {
                        graphics.m_280637_(xo, yo, width + 1, this.rowHeight + 1, -13356240);
                    }
                    graphics.m_280614_(font, entry.text, xo + 2, yo, entry.color, false);
                } else {
                    int color = entry.color;
                    if (color != 0) {
                        graphics.m_280509_(xo + 1, yo + 1, xo + width, yo + this.rowHeight, color);
                    }
                }
                xo += width;
                if (++index <= this.columns) continue;
                index = 0;
                xo = leftStart;
                yo += this.rowHeight;
            }
            if (this.legend != null && !this.legend.isEmpty()) {
                int legendX = 130;
                int legendY = totalHeight + 14 + 2;
                graphics.m_280614_(font, (Component)Component.m_237115_((String)"tfc.tooltip.legend").m_130948_(Style.f_131099_.m_131150_(Minecraft.f_91058_).m_131136_(Boolean.valueOf(true))), 130, legendY, 0, false);
                legendY += 9;
                for (TableEntry entry : this.legend) {
                    graphics.m_280509_(131, legendY + 1, 140, legendY + 8, entry.color);
                    graphics.m_280614_(font, entry.text, 142, legendY, 0, false);
                    legendY += 9;
                }
            }
            graphics.m_280168_().m_85849_();
        }
    }

    public record TableEntry(Component text, int color) {
    }
}

