/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.patchouli.component;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;
import net.dries007.tfc.client.screen.KnappingScreen;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.recipes.KnappingRecipe;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.dries007.tfc.compat.patchouli.component.CustomComponent;
import net.dries007.tfc.compat.patchouli.component.KnappingComponent;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.api.IComponentRenderContext;
import vazkii.patchouli.api.IVariable;

public class RockKnappingComponent
extends CustomComponent {
    @SerializedName(value="recipes")
    String recipeVariable;
    private transient String @Nullable [] resolvedRecipeNames;
    private transient Entry @Nullable [] recipes;

    @Override
    public void build(int componentX, int componentY, int pageNum) {
        super.build(componentX, componentY, pageNum);
        List<Item> allInputs = Helpers.allItems(TFCTags.Items.ROCK_KNAPPING).toList();
        ArrayList<Entry> recipes = new ArrayList<Entry>();
        if (this.resolvedRecipeNames == null) {
            return;
        }
        for (String recipeName : this.resolvedRecipeNames) {
            KnappingRecipe recipe = this.asRecipe(recipeName, (RecipeType)TFCRecipeTypes.KNAPPING.get()).orElse(null);
            if (recipe == null) continue;
            for (Item input : allInputs) {
                ItemStack inputStack = new ItemStack((ItemLike)input);
                if (!recipe.matchesItem(inputStack)) continue;
                ResourceLocation texture = KnappingScreen.getButtonLocation(input, false);
                recipes.add(new Entry(recipe, recipe.m_8043_(null), texture));
            }
        }
        this.recipes = recipes.toArray(new Entry[0]);
    }

    @Override
    public void render(GuiGraphics graphics, IComponentRenderContext context, float partialTicks, int mouseX, int mouseY) {
        if (this.recipes != null && this.recipes.length > 0) {
            Entry recipe = this.recipes[context.getTicksInBook() / 20 % this.recipes.length];
            this.renderSetup(graphics);
            KnappingComponent.render(graphics, context, mouseX, mouseY, recipe.recipe(), recipe.outputStack(), recipe.texture(), null, this.x, this.y);
            graphics.m_280168_().m_85849_();
        }
    }

    @Override
    public void onVariablesAvailable(UnaryOperator<IVariable> lookup) {
        this.resolvedRecipeNames = (String[])((IVariable)lookup.apply(IVariable.wrap((String)this.recipeVariable))).asStream().map(IVariable::asString).toArray(String[]::new);
    }

    record Entry(KnappingRecipe recipe, ItemStack outputStack, ResourceLocation texture) {
    }
}

