/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.patchouli;

import com.mojang.logging.LogUtils;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.CharcoalPileBlock;
import net.dries007.tfc.common.blocks.DirectionPropertyBlock;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.devices.BlastFurnaceBlock;
import net.dries007.tfc.common.blocks.devices.BloomeryBlock;
import net.dries007.tfc.common.blocks.devices.CharcoalForgeBlock;
import net.dries007.tfc.common.blocks.devices.SheetPileBlock;
import net.dries007.tfc.common.blocks.rock.Rock;
import net.dries007.tfc.common.blocks.rock.RockCategory;
import net.dries007.tfc.common.blocks.rotation.AxleBlock;
import net.dries007.tfc.common.blocks.rotation.ClutchBlock;
import net.dries007.tfc.common.blocks.rotation.CrankshaftBlock;
import net.dries007.tfc.common.blocks.rotation.WindmillBlock;
import net.dries007.tfc.common.blocks.wood.Wood;
import net.dries007.tfc.common.items.Powder;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.Metal;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RedstoneSide;
import net.minecraft.world.level.material.Fluids;
import org.slf4j.Logger;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.IStateMatcher;
import vazkii.patchouli.api.PatchouliAPI;

public final class PatchouliIntegration {
    public static final ResourceLocation BOOK_ID = Helpers.identifier("field_guide");
    public static final ResourceLocation TEXTURE = Helpers.identifier("textures/gui/book/icons.png");
    private static final Logger LOGGER = LogUtils.getLogger();

    public static ItemStack getFieldGuide(boolean useHotReloadedBook) {
        return PatchouliAPI.get().getBookStack(useHotReloadedBook ? Helpers.resourceLocation("patchouli", "field_guide") : BOOK_ID);
    }

    public static void ifEnabled(Runnable action) {
        if (((Boolean)TFCConfig.CLIENT.showGuideBookTabInInventory.get()).booleanValue()) {
            action.run();
        }
    }

    public static void openGui(ServerPlayer player) {
        PatchouliAPI.get().openBookGUI(player, BOOK_ID);
    }

    public static void openGui(ServerPlayer player, ResourceLocation entry, int page) {
        PatchouliAPI.get().openBookEntry(player, BOOK_ID, entry, page);
    }

    public static void registerMultiBlocks() {
        PatchouliIntegration.registerMultiblock("bloomery", PatchouliIntegration::bloomery);
        PatchouliIntegration.registerMultiblock("blast_furnace", api -> PatchouliIntegration.blastFurnace(api, false));
        PatchouliIntegration.registerMultiblock("full_blast_furnace", api -> PatchouliIntegration.blastFurnace(api, true));
        PatchouliIntegration.registerMultiblock("rock_anvil", PatchouliIntegration::rockAnvil);
        PatchouliIntegration.registerMultiblock("charcoal_forge", PatchouliIntegration::charcoalForge);
        PatchouliIntegration.registerMultiblock("windmill", PatchouliIntegration::windmill);
        PatchouliIntegration.registerMultiblock("water_wheel", PatchouliIntegration::waterWheel);
        PatchouliIntegration.registerMultiblock("clutch_off", api -> PatchouliIntegration.clutch(api, false));
        PatchouliIntegration.registerMultiblock("clutch_on", api -> PatchouliIntegration.clutch(api, true));
        PatchouliIntegration.registerMultiblock("crankshaft", PatchouliIntegration::crankshaft);
        PatchouliIntegration.registerMultiblock("rotating_quern", PatchouliIntegration::rotatingQuern);
    }

    private static IMultiblock blastFurnace(PatchouliAPI.IPatchouliAPI api, boolean fullSize) {
        String[][] stringArray;
        Block sheetPile = (Block)TFCBlocks.SHEET_PILE.get();
        Function<Direction, IStateMatcher> oneSheet = face -> api.predicateMatcher((BlockState)sheetPile.m_49966_().m_61124_((Property)DirectionPropertyBlock.getProperty(face), (Comparable)Boolean.valueOf(true)), state -> Helpers.isBlock(state, sheetPile) && SheetPileBlock.countSheets(state, (Predicate<Direction>)Direction.Plane.HORIZONTAL) >= 1);
        BiFunction<Direction, Direction, IStateMatcher> twoSheets = (face1, face2) -> api.predicateMatcher((BlockState)((BlockState)sheetPile.m_49966_().m_61124_((Property)DirectionPropertyBlock.getProperty(face1), (Comparable)Boolean.valueOf(true))).m_61124_((Property)DirectionPropertyBlock.getProperty(face2), (Comparable)Boolean.valueOf(true)), state -> Helpers.isBlock(state, sheetPile) && SheetPileBlock.countSheets(state, (Predicate<Direction>)Direction.Plane.HORIZONTAL) >= 2);
        if (fullSize) {
            String[][] stringArrayArray = new String[7][];
            stringArrayArray[0] = new String[]{"  1  ", " 2S3 ", "4SAS5", " 6S7 ", "  8  "};
            stringArrayArray[1] = new String[]{"  1  ", " 2S3 ", "4SAS5", " 6S7 ", "  8  "};
            stringArrayArray[2] = new String[]{"  1  ", " 2S3 ", "4SAS5", " 6S7 ", "  8  "};
            stringArrayArray[3] = new String[]{"  1  ", " 2S3 ", "4SAS5", " 6S7 ", "  8  "};
            stringArrayArray[4] = new String[]{"  1  ", " 2S3 ", "4SAS5", " 6S7 ", "  8  "};
            stringArrayArray[5] = new String[]{"     ", "     ", "  0B ", "     ", "     "};
            stringArray = stringArrayArray;
            stringArrayArray[6] = new String[]{"     ", "     ", "  C  ", "     ", "     "};
        } else {
            String[][] stringArray2 = new String[2][];
            stringArray2[0] = new String[]{"  1  ", " 2S3 ", "4SAS5", " 6S7 ", "  8  "};
            stringArray = stringArray2;
            stringArray2[1] = new String[]{"     ", "     ", "  0  ", "     ", "     "};
        }
        String[][] pattern = stringArray;
        IMultiblock multiblock = api.makeMultiblock(pattern, new Object[]{Character.valueOf('0'), api.looseBlockMatcher((Block)TFCBlocks.BLAST_FURNACE.get()), Character.valueOf(' '), api.anyMatcher(), Character.valueOf('A'), api.airMatcher(), Character.valueOf('S'), api.predicateMatcher((Block)TFCBlocks.FIRE_BRICKS.get(), BlastFurnaceBlock::isBlastFurnaceInsulationBlock), Character.valueOf('1'), oneSheet.apply(Direction.EAST), Character.valueOf('2'), twoSheets.apply(Direction.EAST, Direction.SOUTH), Character.valueOf('3'), twoSheets.apply(Direction.EAST, Direction.NORTH), Character.valueOf('4'), oneSheet.apply(Direction.SOUTH), Character.valueOf('5'), oneSheet.apply(Direction.NORTH), Character.valueOf('6'), twoSheets.apply(Direction.WEST, Direction.SOUTH), Character.valueOf('7'), twoSheets.apply(Direction.WEST, Direction.NORTH), Character.valueOf('8'), oneSheet.apply(Direction.WEST), Character.valueOf('B'), api.looseBlockMatcher((Block)TFCBlocks.BELLOWS.get()), Character.valueOf('C'), api.looseBlockMatcher((Block)TFCBlocks.CRUCIBLE.get())});
        PatchouliIntegration.sneakIntoMultiblock(multiblock).ifPresent(access -> {
            Metal wroughtIron = new Metal(Metal.WROUGHT_IRON_ID);
            for (int x = 0; x < 5; ++x) {
                for (int z = 0; z < 5; ++z) {
                    if (fullSize) {
                        for (int y = 2; y <= 6; ++y) {
                            access.m_141902_(new BlockPos(x, y, z), (BlockEntityType)TFCBlockEntities.SHEET_PILE.get()).ifPresent(pile -> pile.setAllMetalsFromOutsideWorld(wroughtIron));
                        }
                        continue;
                    }
                    access.m_141902_(new BlockPos(x, 1, z), (BlockEntityType)TFCBlockEntities.SHEET_PILE.get()).ifPresent(pile -> pile.setAllMetalsFromOutsideWorld(wroughtIron));
                }
            }
        });
        return multiblock;
    }

    private static IMultiblock bloomery(PatchouliAPI.IPatchouliAPI api) {
        IStateMatcher bloomeryInsulation = api.predicateMatcher((Block)TFCBlocks.ROCK_BLOCKS.get(Rock.GRANITE).get((Object)Rock.BlockType.BRICKS).get(), BloomeryBlock::isBloomeryInsulationBlock);
        return api.makeMultiblock((String[][])new String[][]{{" S ", "SAS", " S "}, {"SBS", "SAS", " S "}, {" S ", " 0 ", "   "}}, new Object[]{Character.valueOf('0'), bloomeryInsulation, Character.valueOf('A'), api.airMatcher(), Character.valueOf('S'), bloomeryInsulation, Character.valueOf('B'), api.predicateMatcher((BlockState)((Block)TFCBlocks.BLOOMERY.get()).m_49966_().m_61124_((Property)BloomeryBlock.FACING, (Comparable)Direction.NORTH), state -> Helpers.isBlock(state, (Block)TFCBlocks.BLOOMERY.get())), Character.valueOf(' '), api.anyMatcher()});
    }

    private static IMultiblock charcoalForge(PatchouliAPI.IPatchouliAPI api) {
        IStateMatcher forgeInsulation = api.predicateMatcher((Block)TFCBlocks.ROCK_BLOCKS.get(Rock.QUARTZITE).get((Object)Rock.BlockType.COBBLE).get(), CharcoalForgeBlock::isForgeInsulationBlock);
        BlockState charcoalPile = ((Block)TFCBlocks.CHARCOAL_PILE.get()).m_49966_();
        return api.makeMultiblock((String[][])new String[][]{{" S ", "S0S", " S "}, {"   ", " S ", "   "}}, new Object[]{Character.valueOf('0'), api.predicateMatcher((BlockState)charcoalPile.m_61124_((Property)CharcoalPileBlock.LAYERS, (Comparable)Integer.valueOf(7)), state -> Helpers.isBlock(state, (Block)TFCBlocks.CHARCOAL_PILE.get()) && (Integer)state.m_61143_((Property)CharcoalPileBlock.LAYERS) >= 7), Character.valueOf(' '), api.anyMatcher(), Character.valueOf('S'), forgeInsulation});
    }

    private static IMultiblock rockAnvil(PatchouliAPI.IPatchouliAPI api) {
        IMultiblock multiblock = api.makeMultiblock((String[][])new String[][]{{" 0 "}, {"RAR"}}, new Object[]{Character.valueOf('0'), api.airMatcher(), Character.valueOf(' '), api.anyMatcher(), Character.valueOf('R'), api.strictBlockMatcher((Block)TFCBlocks.ROCK_BLOCKS.get(Rock.GABBRO).get((Object)Rock.BlockType.RAW).get()), Character.valueOf('A'), api.strictBlockMatcher((Block)TFCBlocks.ROCK_ANVILS.get(Rock.GABBRO).get())});
        PatchouliIntegration.sneakIntoMultiblock(multiblock).flatMap(access -> access.m_141902_(new BlockPos(0, 0, 1), (BlockEntityType)TFCBlockEntities.ANVIL.get())).ifPresent(anvil -> anvil.setInventoryFromOutsideWorld(new ItemStack((ItemLike)TFCItems.METAL_ITEMS.get(Metal.Default.COPPER).get((Object)Metal.ItemType.INGOT).get()), new ItemStack((ItemLike)TFCItems.ROCK_TOOLS.get((Object)RockCategory.IGNEOUS_EXTRUSIVE).get((Object)RockCategory.ItemType.HAMMER).get()), new ItemStack((ItemLike)TFCItems.POWDERS.get((Object)Powder.FLUX).get())));
        return multiblock;
    }

    private static IMultiblock windmill(PatchouliAPI.IPatchouliAPI api) {
        IMultiblock multiblock = api.makeMultiblock((String[][])new String[][]{{"             "}, {"             "}, {"             "}, {"             "}, {"             "}, {"             "}, {"      0      "}, {"             "}, {"             "}, {"             "}, {"             "}, {"             "}, {"             "}}, new Object[]{Character.valueOf('0'), api.predicateMatcher((BlockState)((Block)TFCBlocks.WOODS.get(Wood.OAK).get((Object)Wood.BlockType.WINDMILL).get()).m_49966_().m_61124_((Property)WindmillBlock.COUNT, (Comparable)Integer.valueOf(5)), state -> state.m_60734_() instanceof WindmillBlock), Character.valueOf(' '), api.airMatcher()});
        PatchouliIntegration.sneakIntoMultiblock(multiblock).flatMap(access -> access.m_141902_(new BlockPos(0, 6, 6), (BlockEntityType)TFCBlockEntities.WINDMILL.get())).ifPresent(entity -> entity.getRotationNode().setRotationFromOutsideWorld());
        return multiblock;
    }

    private static IMultiblock waterWheel(PatchouliAPI.IPatchouliAPI api) {
        IMultiblock multiblock = api.makeMultiblock((String[][])new String[][]{{"     "}, {"     "}, {"  0  "}, {"WWWWW"}, {"WWWWW"}}, new Object[]{Character.valueOf('0'), api.stateMatcher(((Block)TFCBlocks.WOODS.get(Wood.OAK).get((Object)Wood.BlockType.WATER_WHEEL).get()).m_49966_()), Character.valueOf('W'), api.predicateMatcher(Blocks.f_49990_, state -> state.m_60819_().m_76152_() == Fluids.f_76193_), Character.valueOf(' '), api.airMatcher()});
        PatchouliIntegration.sneakIntoMultiblock(multiblock).flatMap(access -> access.m_141902_(new BlockPos(0, 2, 2), (BlockEntityType)TFCBlockEntities.WATER_WHEEL.get())).ifPresent(entity -> entity.getRotationNode().setRotationFromOutsideWorld());
        return multiblock;
    }

    private static IMultiblock clutch(PatchouliAPI.IPatchouliAPI api, boolean powered) {
        IMultiblock multiblock = api.makeMultiblock((String[][])new String[][]{{"     ", "     ", "     "}, {"  RL ", "  0  ", "AACAA"}}, new Object[]{Character.valueOf('L'), api.stateMatcher((BlockState)((BlockState)((BlockState)Blocks.f_50164_.m_49966_().m_61124_((Property)LeverBlock.f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)LeverBlock.f_53179_, (Comparable)AttachFace.FLOOR)).m_61124_((Property)LeverBlock.f_54622_, (Comparable)Boolean.valueOf(powered))), Character.valueOf('R'), api.stateMatcher((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)Blocks.f_50088_.m_49966_().m_61124_((Property)RedStoneWireBlock.f_55497_, (Comparable)RedstoneSide.SIDE)).m_61124_((Property)RedStoneWireBlock.f_55496_, (Comparable)RedstoneSide.NONE)).m_61124_((Property)RedStoneWireBlock.f_55498_, (Comparable)RedstoneSide.SIDE)).m_61124_((Property)RedStoneWireBlock.f_55499_, (Comparable)RedstoneSide.NONE)).m_61124_((Property)RedStoneWireBlock.f_55500_, (Comparable)Integer.valueOf(powered ? 15 : 0))), Character.valueOf('0'), api.stateMatcher((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)Blocks.f_50088_.m_49966_().m_61124_((Property)RedStoneWireBlock.f_55497_, (Comparable)RedstoneSide.SIDE)).m_61124_((Property)RedStoneWireBlock.f_55496_, (Comparable)RedstoneSide.NONE)).m_61124_((Property)RedStoneWireBlock.f_55498_, (Comparable)RedstoneSide.NONE)).m_61124_((Property)RedStoneWireBlock.f_55499_, (Comparable)RedstoneSide.SIDE)).m_61124_((Property)RedStoneWireBlock.f_55500_, (Comparable)Integer.valueOf(powered ? 14 : 0))), Character.valueOf('C'), api.stateMatcher((BlockState)((BlockState)((Block)TFCBlocks.WOODS.get(Wood.OAK).get((Object)Wood.BlockType.CLUTCH).get()).m_49966_().m_61124_((Property)ClutchBlock.f_55923_, (Comparable)Direction.Axis.Z)).m_61124_((Property)ClutchBlock.POWERED, (Comparable)Boolean.valueOf(powered))), Character.valueOf('A'), api.stateMatcher((BlockState)((Block)TFCBlocks.WOODS.get(Wood.OAK).get((Object)Wood.BlockType.AXLE).get()).m_49966_().m_61124_((Property)AxleBlock.f_55923_, (Comparable)Direction.Axis.Z)), Character.valueOf(' '), api.airMatcher()});
        PatchouliIntegration.sneakIntoMultiblock(multiblock).ifPresent(access -> {
            for (int z = 0; z < (powered ? 3 : 5); ++z) {
                access.m_141902_(new BlockPos(2, 0, z), (BlockEntityType)TFCBlockEntities.AXLE.get()).ifPresent(axle -> axle.getRotationNode().setRotationFromOutsideWorld());
            }
        });
        return multiblock;
    }

    private static IMultiblock crankshaft(PatchouliAPI.IPatchouliAPI api) {
        IMultiblock multiblock = api.makeMultiblock((String[][])new String[][]{{" A ", "S0 ", "   "}}, new Object[]{Character.valueOf('A'), api.stateMatcher((BlockState)((Block)TFCBlocks.WOODS.get(Wood.OAK).get((Object)Wood.BlockType.AXLE).get()).m_49966_().m_61124_((Property)AxleBlock.f_55923_, (Comparable)Direction.Axis.X)), Character.valueOf('0'), api.stateMatcher((BlockState)((BlockState)((Block)TFCBlocks.CRANKSHAFT.get()).m_49966_().m_61124_(CrankshaftBlock.PART, (Comparable)((Object)CrankshaftBlock.Part.BASE))).m_61124_(CrankshaftBlock.FACING, (Comparable)Direction.NORTH)), Character.valueOf('S'), api.stateMatcher((BlockState)((BlockState)((Block)TFCBlocks.CRANKSHAFT.get()).m_49966_().m_61124_(CrankshaftBlock.PART, (Comparable)((Object)CrankshaftBlock.Part.SHAFT))).m_61124_(CrankshaftBlock.FACING, (Comparable)Direction.NORTH)), Character.valueOf(' '), api.airMatcher()});
        PatchouliIntegration.sneakIntoMultiblock(multiblock).ifPresent(access -> {
            access.m_141902_(new BlockPos(0, 0, 1), (BlockEntityType)TFCBlockEntities.AXLE.get()).ifPresent(axle -> axle.getRotationNode().setRotationFromOutsideWorld());
            access.m_141902_(new BlockPos(1, 0, 1), (BlockEntityType)TFCBlockEntities.CRANKSHAFT.get()).ifPresent(shaft -> shaft.getRotationNode().setRotationFromOutsideWorld());
            access.m_141902_(new BlockPos(1, 0, 0), (BlockEntityType)TFCBlockEntities.CRANKSHAFT.get()).ifPresent(shaft -> shaft.getRotationNode().setRotationFromOutsideWorld());
        });
        return multiblock;
    }

    private static IMultiblock rotatingQuern(PatchouliAPI.IPatchouliAPI api) {
        IMultiblock multiblock = api.makeMultiblock((String[][])new String[][]{{"T"}, {"0"}, {" "}}, new Object[]{Character.valueOf(' '), api.airMatcher(), Character.valueOf('0'), api.stateMatcher(((Block)TFCBlocks.QUERN.get()).m_49966_()), Character.valueOf('T'), api.stateMatcher((BlockState)((Block)TFCBlocks.WOODS.get(Wood.OAK).get((Object)Wood.BlockType.AXLE).get()).m_49966_().m_61124_((Property)AxleBlock.f_55923_, (Comparable)Direction.Axis.Y))});
        PatchouliIntegration.sneakIntoMultiblock(multiblock).ifPresent(access -> {
            access.m_141902_(new BlockPos(0, 1, 0), (BlockEntityType)TFCBlockEntities.QUERN.get()).ifPresent(quern -> {
                quern.getRotationNode().setRotationFromOutsideWorld();
                quern.setHandstoneFromOutsideWorld();
            });
            access.m_141902_(new BlockPos(0, 2, 0), (BlockEntityType)TFCBlockEntities.AXLE.get()).ifPresent(axle -> axle.getRotationNode().setRotationFromOutsideWorld());
        });
        return multiblock;
    }

    private static void registerMultiblock(String name, Function<PatchouliAPI.IPatchouliAPI, IMultiblock> factory) {
        PatchouliAPI.IPatchouliAPI api = PatchouliAPI.get();
        api.registerMultiblock(Helpers.identifier(name), factory.apply(api));
    }

    private static Optional<BlockGetter> sneakIntoMultiblock(IMultiblock multiblock) {
        if (multiblock instanceof BlockGetter) {
            BlockGetter access = (BlockGetter)multiblock;
            return Optional.of(access);
        }
        LOGGER.warn("Multiblock of concrete type {} is not a {}, multiblock will be disfigured!", (Object)multiblock.getClass().getName(), (Object)BlockGetter.class.getName());
        return Optional.empty();
    }
}

