/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.jei.transfer;

import java.util.Optional;
import java.util.stream.Collectors;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import net.dries007.tfc.common.blockentities.PotBlockEntity;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.container.PotContainer;
import net.dries007.tfc.common.container.TFCContainerTypes;
import net.dries007.tfc.common.recipes.PotRecipe;
import net.dries007.tfc.common.recipes.ingredients.FluidStackIngredient;
import net.dries007.tfc.compat.jei.transfer.BaseTransferInfo;
import net.dries007.tfc.util.Helpers;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class PotTransferInfo
extends BaseTransferInfo<PotContainer, PotRecipe>
implements IRecipeTransferInfo<PotContainer, PotRecipe> {
    private final IRecipeTransferHandlerHelper transferHelper;

    public PotTransferInfo(IRecipeTransferHandlerHelper transferHelper, RecipeType<PotRecipe> recipeType) {
        super(PotContainer.class, Optional.of((MenuType)TFCContainerTypes.POT.get()), recipeType, 9, 4, 5, 6, 7, 8);
        this.transferHelper = transferHelper;
    }

    public boolean canHandle(PotContainer container, PotRecipe recipe) {
        if (((PotBlockEntity)container.getBlockEntity()).hasRecipeStarted()) {
            return false;
        }
        IFluidHandler capability = Helpers.getCapability(container.getBlockEntity(), Capabilities.FLUID);
        if (capability != null) {
            FluidStackIngredient fluidIngredient = recipe.getFluidIngredient();
            FluidStack fluidInTank = capability.getFluidInTank(0);
            if (!fluidIngredient.ingredient().fluids().contains(fluidInTank.getFluid())) {
                return false;
            }
            return fluidInTank.getAmount() >= fluidIngredient.amount();
        }
        return true;
    }

    @Nullable
    public IRecipeTransferError getHandlingError(PotContainer container, PotRecipe recipe) {
        IFluidHandler capability = Helpers.getCapability(container.getBlockEntity(), Capabilities.FLUID);
        if (capability != null) {
            FluidStackIngredient fluidIngredient = recipe.getFluidIngredient();
            FluidStack fluidInTank = capability.getFluidInTank(0);
            if (!fluidIngredient.ingredient().fluids().contains(fluidInTank.getFluid())) {
                if (fluidInTank.isEmpty()) {
                    String fluidNames = fluidIngredient.ingredient().all().map(fluid -> fluid.getFluidType().getDescription().getString()).collect(Collectors.joining(", "));
                    return this.transferHelper.createUserErrorWithTooltip((Component)Component.m_237110_((String)"tfc.jei.transfer.error.pot_no_fluid", (Object[])new Object[]{fluidIngredient.amount(), fluidNames}));
                }
                return this.transferHelper.createUserErrorWithTooltip((Component)Component.m_237110_((String)"tfc.jei.transfer.error.pot_wrong_fluid", (Object[])new Object[]{fluidInTank.getDisplayName().getString()}));
            }
            if (fluidInTank.getAmount() < fluidIngredient.amount()) {
                int missingFluid = fluidIngredient.amount() - fluidInTank.getAmount();
                return this.transferHelper.createUserErrorWithTooltip((Component)Component.m_237110_((String)"tfc.jei.transfer.error.pot_not_enough_fluid", (Object[])new Object[]{missingFluid, fluidInTank.getDisplayName().getString()}));
            }
        }
        return this.transferHelper.createUserErrorWithTooltip((Component)Component.m_237115_((String)"tfc.jei.transfer.error.pot_started"));
    }
}

