/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.jei.transfer;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;

public abstract class BaseTransferInfo<C extends AbstractContainerMenu, R> {
    private final Class<? extends C> containerClass;
    private final Optional<MenuType<C>> menuType;
    private final RecipeType<R> recipeType;
    private final int[] recipeSlots;
    private final int inventorySlotStart;

    protected BaseTransferInfo(Class<? extends C> containerClass, Optional<MenuType<C>> menuType, RecipeType<R> recipeType, int inventorySlotStart, int ... recipeSlots) {
        this.containerClass = containerClass;
        this.menuType = menuType;
        this.recipeType = recipeType;
        this.recipeSlots = recipeSlots;
        this.inventorySlotStart = inventorySlotStart;
    }

    public final Class<? extends C> getContainerClass() {
        return this.containerClass;
    }

    public final Optional<MenuType<C>> getMenuType() {
        return this.menuType;
    }

    public final RecipeType<R> getRecipeType() {
        return this.recipeType;
    }

    public final List<Slot> getRecipeSlots(C container, R recipe) {
        return Arrays.stream(this.recipeSlots).mapToObj(arg_0 -> container.m_38853_(arg_0)).toList();
    }

    public final List<Slot> getInventorySlots(C container, R recipe) {
        return IntStream.range(this.inventorySlotStart, this.inventorySlotStart + 36).mapToObj(arg_0 -> container.m_38853_(arg_0)).toList();
    }
}

