/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.jei.category;

import com.google.common.collect.ImmutableMap;
import java.awt.Color;
import java.util.Map;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.dries007.tfc.common.blocks.PouredGlassBlock;
import net.dries007.tfc.common.capabilities.glass.GlassOperation;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.common.recipes.GlassworkingRecipe;
import net.dries007.tfc.compat.jei.category.BaseRecipeCategory;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class GlassworkingRecipeCategory
extends BaseRecipeCategory<GlassworkingRecipe> {
    private final Map<GlassOperation, ItemStack> map = ImmutableMap.of((Object)((Object)GlassOperation.SAW), (Object)((Item)TFCItems.GEM_SAW.get()).m_7968_(), (Object)((Object)GlassOperation.ROLL), (Object)((Item)TFCItems.WOOL_CLOTH.get()).m_7968_(), (Object)((Object)GlassOperation.STRETCH), (Object)((Item)TFCItems.BLOWPIPE_WITH_GLASS.get()).m_7968_(), (Object)((Object)GlassOperation.BLOW), (Object)((Item)TFCItems.BLOWPIPE_WITH_GLASS.get()).m_7968_(), (Object)((Object)GlassOperation.TABLE_POUR), (Object)((Item)TFCItems.BLOWPIPE_WITH_GLASS.get()).m_7968_(), (Object)((Object)GlassOperation.BASIN_POUR), (Object)((Item)TFCItems.BLOWPIPE_WITH_GLASS.get()).m_7968_(), (Object)((Object)GlassOperation.FLATTEN), (Object)((Item)TFCItems.PADDLE.get()).m_7968_(), (Object)((Object)GlassOperation.PINCH), (Object)((Item)TFCItems.JACKS.get()).m_7968_());

    public GlassworkingRecipeCategory(RecipeType<GlassworkingRecipe> type, IGuiHelper helper) {
        super(type, helper, (IDrawable)helper.createBlankDrawable(175, 110), new ItemStack((ItemLike)TFCItems.BLOWPIPE_WITH_GLASS.get()));
    }

    public void setRecipe(IRecipeLayoutBuilder builder, GlassworkingRecipe recipe, IFocusGroup focuses) {
        BlockItem bi;
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 6, 5).addIngredients(recipe.getBatchItem())).setBackground((IDrawable)this.slot, -1, -1);
        ItemStack result = recipe.m_8043_(null);
        Item item = result.m_41720_();
        if (item instanceof BlockItem && (item = (bi = (BlockItem)item).m_40614_()) instanceof PouredGlassBlock) {
            PouredGlassBlock block = (PouredGlassBlock)item;
            result = block.getDrop().m_7968_();
        }
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 120, 5).addItemStack(result)).setBackground((IDrawable)this.slot, -1, -1);
        int idx = 0;
        for (GlassOperation operation : recipe.getOperations()) {
            IRecipeSlotBuilder slot = builder.addSlot(RecipeIngredientRole.CATALYST, idx < 3 ? 6 : 90, 25 * (idx % 3 + 1)).setBackground((IDrawable)this.slot, -1, -1);
            if (this.map.containsKey((Object)operation)) {
                slot.addItemStack(this.map.get((Object)operation));
                if (this.map.get((Object)operation).m_41720_() == TFCItems.BLOWPIPE_WITH_GLASS.get()) {
                    slot.addItemStack(((Item)TFCItems.CERAMIC_BLOWPIPE_WITH_GLASS.get()).m_7968_());
                }
            } else if (operation != GlassOperation.TABLE_POUR && operation != GlassOperation.BASIN_POUR) {
                for (Map.Entry<Item, GlassOperation> entry : GlassOperation.POWDERS.get().entrySet()) {
                    if (entry.getValue() != operation) continue;
                    slot.addItemStack(entry.getKey().m_7968_());
                }
            }
            ++idx;
        }
    }

    public void draw(GlassworkingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        this.arrow.draw(graphics, 92, 5);
        this.arrowAnimated.draw(graphics, 92, 5);
        Font font = Minecraft.m_91087_().f_91062_;
        int idx = 0;
        for (GlassOperation operation : recipe.getOperations()) {
            MutableComponent text = Component.m_237113_((String)(idx + 1 + ". ")).m_7220_((Component)Helpers.translateEnum(operation));
            if (idx + 3 < recipe.getOperations().size()) {
                graphics.m_280554_(font, (FormattedText)text, (idx < 3 ? 6 : 90) + 20, 25 * (idx % 3 + 1) + 5, idx < 3 ? 55 : 75, Color.BLACK.getRGB());
            } else {
                graphics.m_280614_(font, (Component)text, (idx < 3 ? 6 : 90) + 20, 25 * (idx % 3 + 1) + 5, Color.BLACK.getRGB(), false);
            }
            ++idx;
        }
    }
}

