/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.jei.category;

import java.util.ArrayList;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.capabilities.heat.Heat;
import net.dries007.tfc.common.capabilities.heat.HeatCapability;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.common.recipes.CastingRecipe;
import net.dries007.tfc.compat.jei.JEIIntegration;
import net.dries007.tfc.compat.jei.category.BaseRecipeCategory;
import net.dries007.tfc.util.Metal;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class CastingRecipeCategory
extends BaseRecipeCategory<CastingRecipe> {
    private static final String INPUT_SLOT = "input";

    public CastingRecipeCategory(RecipeType<CastingRecipe> type, IGuiHelper helper) {
        super(type, helper, (IDrawable)helper.createBlankDrawable(98, 26), new ItemStack((ItemLike)TFCItems.MOLDS.get((Object)Metal.ItemType.INGOT).get()));
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CastingRecipe recipe, IFocusGroup focuses) {
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        for (ItemStack input : recipe.getIngredient().m_43908_()) {
            for (Fluid fluid : recipe.getFluidIngredient().ingredient().fluids()) {
                ItemStack filled = input.m_41777_();
                filled.getCapability(Capabilities.FLUID_ITEM).ifPresent(cap -> cap.fill(new FluidStack(fluid, recipe.getFluidIngredient().amount()), IFluidHandler.FluidAction.EXECUTE));
                inputs.add(filled);
            }
        }
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 6, 5).addItemStacks(inputs)).setSlotName(INPUT_SLOT).setBackground((IDrawable)this.slot, -1, -1);
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 26, 5).addIngredients(JEIIntegration.FLUID_STACK, CastingRecipeCategory.collapse(recipe.getFluidIngredient()))).setFluidRenderer(1L, false, 16, 16).setBackground((IDrawable)this.slot, -1, -1);
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 76, 5).addItemStack(recipe.m_8043_(CastingRecipeCategory.registryAccess()))).setBackground((IDrawable)this.slot, -1, -1);
    }

    public void draw(CastingRecipe recipe, IRecipeSlotsView recipeSlots, GuiGraphics stack, double mouseX, double mouseY) {
        recipeSlots.findSlotByName(INPUT_SLOT).flatMap(IRecipeSlotView::getDisplayedItemStack).ifPresent(filled -> HeatCapability.setTemperature(filled, Heat.maxVisibleTemperature()));
        this.arrow.draw(stack, 48, 5);
        this.arrowAnimated.draw(stack, 48, 5);
    }
}

