/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.jei;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import net.dries007.tfc.client.ClientHelpers;
import net.dries007.tfc.client.screen.AnvilScreen;
import net.dries007.tfc.client.screen.BarrelScreen;
import net.dries007.tfc.client.screen.CalendarScreen;
import net.dries007.tfc.client.screen.ClimateScreen;
import net.dries007.tfc.client.screen.CrucibleScreen;
import net.dries007.tfc.client.screen.FirepitScreen;
import net.dries007.tfc.client.screen.GrillScreen;
import net.dries007.tfc.client.screen.KnappingScreen;
import net.dries007.tfc.client.screen.NutritionScreen;
import net.dries007.tfc.client.screen.PotScreen;
import net.dries007.tfc.client.screen.SewingTableScreen;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.wood.Wood;
import net.dries007.tfc.common.container.CrucibleContainer;
import net.dries007.tfc.common.container.FirepitContainer;
import net.dries007.tfc.common.container.GrillContainer;
import net.dries007.tfc.common.container.TFCContainerTypes;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.common.recipes.AdvancedShapelessRecipe;
import net.dries007.tfc.common.recipes.AlloyRecipe;
import net.dries007.tfc.common.recipes.AnvilRecipe;
import net.dries007.tfc.common.recipes.BlastFurnaceRecipe;
import net.dries007.tfc.common.recipes.BloomeryRecipe;
import net.dries007.tfc.common.recipes.CastingRecipe;
import net.dries007.tfc.common.recipes.ChiselRecipe;
import net.dries007.tfc.common.recipes.ExtraProductsCraftingRecipe;
import net.dries007.tfc.common.recipes.GlassworkingRecipe;
import net.dries007.tfc.common.recipes.HeatingRecipe;
import net.dries007.tfc.common.recipes.InstantBarrelRecipe;
import net.dries007.tfc.common.recipes.InstantFluidBarrelRecipe;
import net.dries007.tfc.common.recipes.KnappingRecipe;
import net.dries007.tfc.common.recipes.LoomRecipe;
import net.dries007.tfc.common.recipes.PotRecipe;
import net.dries007.tfc.common.recipes.QuernRecipe;
import net.dries007.tfc.common.recipes.ScrapingRecipe;
import net.dries007.tfc.common.recipes.SealedBarrelRecipe;
import net.dries007.tfc.common.recipes.SewingRecipe;
import net.dries007.tfc.common.recipes.TFCRecipeSerializers;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.dries007.tfc.common.recipes.WeldingRecipe;
import net.dries007.tfc.common.recipes.ingredients.HeatableIngredient;
import net.dries007.tfc.compat.jei.TFCInventoryGuiHandler;
import net.dries007.tfc.compat.jei.category.AlloyRecipeCategory;
import net.dries007.tfc.compat.jei.category.AnvilRecipeCategory;
import net.dries007.tfc.compat.jei.category.BlastFurnaceRecipeCategory;
import net.dries007.tfc.compat.jei.category.BloomeryRecipeCategory;
import net.dries007.tfc.compat.jei.category.CastingRecipeCategory;
import net.dries007.tfc.compat.jei.category.ChiselRecipeCategory;
import net.dries007.tfc.compat.jei.category.GlassworkingRecipeCategory;
import net.dries007.tfc.compat.jei.category.HeatingRecipeCategory;
import net.dries007.tfc.compat.jei.category.InstantBarrelRecipeCategory;
import net.dries007.tfc.compat.jei.category.InstantFluidBarrelRecipeCategory;
import net.dries007.tfc.compat.jei.category.JamPotRecipeCategory;
import net.dries007.tfc.compat.jei.category.KnappingRecipeCategory;
import net.dries007.tfc.compat.jei.category.LoomRecipeCategory;
import net.dries007.tfc.compat.jei.category.QuernRecipeCategory;
import net.dries007.tfc.compat.jei.category.ScrapingRecipeCategory;
import net.dries007.tfc.compat.jei.category.SealedBarrelRecipeCategory;
import net.dries007.tfc.compat.jei.category.SewingRecipeCategory;
import net.dries007.tfc.compat.jei.category.SimplePotRecipeCategory;
import net.dries007.tfc.compat.jei.category.SoupPotRecipeCategory;
import net.dries007.tfc.compat.jei.category.WeldingRecipeCategory;
import net.dries007.tfc.compat.jei.extension.AdvancedShapelessExtension;
import net.dries007.tfc.compat.jei.extension.ExtraProductsExtension;
import net.dries007.tfc.compat.jei.transfer.AnvilRecipeTransferHandler;
import net.dries007.tfc.compat.jei.transfer.AnvilRecipeTransferInfo;
import net.dries007.tfc.compat.jei.transfer.BarrelTransferInfo;
import net.dries007.tfc.compat.jei.transfer.FluidIgnoringRecipeTransferHandler;
import net.dries007.tfc.compat.jei.transfer.PotTransferInfo;
import net.dries007.tfc.compat.jei.transfer.WeldingRecipeTransferInfo;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.KnappingType;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.RegistryObject;

@JeiPlugin
public final class JEIIntegration
implements IModPlugin {
    public static final IIngredientTypeWithSubtypes<Item, ItemStack> ITEM_STACK = VanillaTypes.ITEM_STACK;
    public static final IIngredientType<FluidStack> FLUID_STACK = ForgeTypes.FLUID_STACK;
    public static final RecipeType<HeatingRecipe> HEATING = JEIIntegration.type("heating", HeatingRecipe.class);
    public static final RecipeType<ScrapingRecipe> SCRAPING = JEIIntegration.type("scraping", ScrapingRecipe.class);
    public static final RecipeType<QuernRecipe> QUERN = JEIIntegration.type("quern", QuernRecipe.class);
    public static final RecipeType<PotRecipe> SOUP_POT = JEIIntegration.type("soup_pot", PotRecipe.class);
    public static final RecipeType<PotRecipe> SIMPLE_POT = JEIIntegration.type("simple_pot", PotRecipe.class);
    public static final RecipeType<PotRecipe> JAM_POT = JEIIntegration.type("jam_pot", PotRecipe.class);
    public static final RecipeType<CastingRecipe> CASTING = JEIIntegration.type("casting", CastingRecipe.class);
    public static final RecipeType<LoomRecipe> LOOM = JEIIntegration.type("loom", LoomRecipe.class);
    public static final RecipeType<AlloyRecipe> ALLOYING = JEIIntegration.type("alloying", AlloyRecipe.class);
    public static final RecipeType<SealedBarrelRecipe> SEALED_BARREL = JEIIntegration.type("sealed_barrel", SealedBarrelRecipe.class);
    public static final RecipeType<InstantBarrelRecipe> INSTANT_BARREL = JEIIntegration.type("instant_barrel", InstantBarrelRecipe.class);
    public static final RecipeType<InstantFluidBarrelRecipe> INSTANT_FLUID_BARREL = JEIIntegration.type("instant_fluid_barrel", InstantFluidBarrelRecipe.class);
    public static final RecipeType<BloomeryRecipe> BLOOMERY = JEIIntegration.type("bloomery", BloomeryRecipe.class);
    public static final RecipeType<WeldingRecipe> WELDING = JEIIntegration.type("welding", WeldingRecipe.class);
    public static final RecipeType<AnvilRecipe> ANVIL = JEIIntegration.type("anvil", AnvilRecipe.class);
    public static final RecipeType<ChiselRecipe> CHISEL = JEIIntegration.type("chisel", ChiselRecipe.class);
    public static final RecipeType<GlassworkingRecipe> GLASSWORKING = JEIIntegration.type("glassworking", GlassworkingRecipe.class);
    public static final RecipeType<BlastFurnaceRecipe> BLAST_FURNACE = JEIIntegration.type("blast_furnace", BlastFurnaceRecipe.class);
    public static final RecipeType<SewingRecipe> SEWING = JEIIntegration.type("sewing", SewingRecipe.class);
    private static final Map<ResourceLocation, RecipeType<KnappingRecipe>> KNAPPING_TYPES = new HashMap<ResourceLocation, RecipeType<KnappingRecipe>>();

    public static RecipeType<KnappingRecipe> getKnappingType(KnappingType type) {
        return KNAPPING_TYPES.computeIfAbsent(type.getId(), key -> JEIIntegration.type(key.m_135815_() + "_knapping", KnappingRecipe.class));
    }

    private static <T> RecipeType<T> type(String name, Class<T> tClass) {
        return RecipeType.create((String)"tfc", (String)name, tClass);
    }

    private static <C extends Container, T extends Recipe<C>> List<T> recipes(net.minecraft.world.item.crafting.RecipeType<T> type) {
        return ClientHelpers.getLevelOrThrow().m_7465_().m_44013_(type);
    }

    private static <C extends Container, T extends Recipe<C>> List<T> recipes(net.minecraft.world.item.crafting.RecipeType<T> type, Predicate<T> filter) {
        return JEIIntegration.recipes(type).stream().filter(filter).collect(Collectors.toList());
    }

    private static void addRecipeCatalyst(IRecipeCatalystRegistration registry, TagKey<Item> tag, RecipeType<?> recipeType) {
        Helpers.allItems(tag).forEach(item -> registry.addRecipeCatalyst(new ItemStack((ItemLike)item), new RecipeType[]{recipeType}));
    }

    private static void addRecipeCatalyst(IRecipeCatalystRegistration registry, Wood.BlockType wood, RecipeType<?> recipeType) {
        TFCBlocks.WOODS.values().stream().map(map -> (RegistryObject)map.get((Object)wood)).forEach(i -> registry.addRecipeCatalyst(new ItemStack((ItemLike)i.get()), new RecipeType[]{recipeType}));
    }

    public ResourceLocation getPluginUid() {
        return Helpers.identifier("jei");
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper gui = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new HeatingRecipeCategory(HEATING, gui), new QuernRecipeCategory(QUERN, gui), new ScrapingRecipeCategory(SCRAPING, gui), new SoupPotRecipeCategory(SOUP_POT, gui), new SimplePotRecipeCategory(SIMPLE_POT, gui), new JamPotRecipeCategory(JAM_POT, gui), new CastingRecipeCategory(CASTING, gui), new LoomRecipeCategory(LOOM, gui), new AlloyRecipeCategory(ALLOYING, gui), new SealedBarrelRecipeCategory(SEALED_BARREL, gui), new InstantBarrelRecipeCategory(INSTANT_BARREL, gui), new InstantFluidBarrelRecipeCategory(INSTANT_FLUID_BARREL, gui), new BloomeryRecipeCategory(BLOOMERY, gui), new WeldingRecipeCategory(WELDING, gui), new AnvilRecipeCategory(ANVIL, gui), new ChiselRecipeCategory(CHISEL, gui), new GlassworkingRecipeCategory(GLASSWORKING, gui), new BlastFurnaceRecipeCategory(BLAST_FURNACE, gui), new SewingRecipeCategory(SEWING, gui)});
        for (KnappingType knappingType : KnappingType.MANAGER.getValues()) {
            RecipeType<KnappingRecipe> recipeType = JEIIntegration.getKnappingType(knappingType);
            registry.addRecipeCategories(new IRecipeCategory[]{new KnappingRecipeCategory<KnappingRecipe>(recipeType, gui, knappingType)});
        }
    }

    public void registerRecipes(IRecipeRegistration registry) {
        registry.addRecipes(HEATING, JEIIntegration.recipes((net.minecraft.world.item.crafting.RecipeType)TFCRecipeTypes.HEATING.get()));
        registry.addRecipes(SCRAPING, JEIIntegration.recipes((net.minecraft.world.item.crafting.RecipeType)TFCRecipeTypes.SCRAPING.get()));
        registry.addRecipes(QUERN, JEIIntegration.recipes((net.minecraft.world.item.crafting.RecipeType)TFCRecipeTypes.QUERN.get()));
        registry.addRecipes(SOUP_POT, JEIIntegration.recipes((net.minecraft.world.item.crafting.RecipeType)TFCRecipeTypes.POT.get(), recipe -> recipe.m_7707_() == TFCRecipeSerializers.POT_SOUP.get()));
        registry.addRecipes(SIMPLE_POT, JEIIntegration.recipes((net.minecraft.world.item.crafting.RecipeType)TFCRecipeTypes.POT.get(), recipe -> recipe.m_7707_() == TFCRecipeSerializers.POT_SIMPLE.get()));
        registry.addRecipes(JAM_POT, JEIIntegration.recipes((net.minecraft.world.item.crafting.RecipeType)TFCRecipeTypes.POT.get(), recipe -> recipe.m_7707_() == TFCRecipeSerializers.POT_JAM.get()));
        registry.addRecipes(CASTING, JEIIntegration.recipes((net.minecraft.world.item.crafting.RecipeType)TFCRecipeTypes.CASTING.get()));
        registry.addRecipes(LOOM, JEIIntegration.recipes((net.minecraft.world.item.crafting.RecipeType)TFCRecipeTypes.LOOM.get()));
        registry.addRecipes(ALLOYING, JEIIntegration.recipes((net.minecraft.world.item.crafting.RecipeType)TFCRecipeTypes.ALLOY.get()));
        registry.addRecipes(SEALED_BARREL, JEIIntegration.recipes((net.minecraft.world.item.crafting.RecipeType)TFCRecipeTypes.BARREL_SEALED.get()));
        registry.addRecipes(INSTANT_BARREL, JEIIntegration.recipes((net.minecraft.world.item.crafting.RecipeType)TFCRecipeTypes.BARREL_INSTANT.get(), recipe -> {
            HeatableIngredient heatable;
            Ingredient patt12864$temp = recipe.getInputItem().ingredient();
            return !(patt12864$temp instanceof HeatableIngredient && (heatable = (HeatableIngredient)patt12864$temp).lacksDelegate());
        }));
        registry.addRecipes(INSTANT_FLUID_BARREL, JEIIntegration.recipes((net.minecraft.world.item.crafting.RecipeType)TFCRecipeTypes.BARREL_INSTANT_FLUID.get()));
        registry.addRecipes(BLOOMERY, JEIIntegration.recipes((net.minecraft.world.item.crafting.RecipeType)TFCRecipeTypes.BLOOMERY.get()));
        registry.addRecipes(WELDING, JEIIntegration.recipes((net.minecraft.world.item.crafting.RecipeType)TFCRecipeTypes.WELDING.get()));
        registry.addRecipes(ANVIL, JEIIntegration.recipes((net.minecraft.world.item.crafting.RecipeType)TFCRecipeTypes.ANVIL.get()));
        registry.addRecipes(CHISEL, JEIIntegration.recipes((net.minecraft.world.item.crafting.RecipeType)TFCRecipeTypes.CHISEL.get()));
        registry.addRecipes(GLASSWORKING, JEIIntegration.recipes((net.minecraft.world.item.crafting.RecipeType)TFCRecipeTypes.GLASSWORKING.get()));
        registry.addRecipes(BLAST_FURNACE, JEIIntegration.recipes((net.minecraft.world.item.crafting.RecipeType)TFCRecipeTypes.BLAST_FURNACE.get()));
        registry.addRecipes(SEWING, JEIIntegration.recipes((net.minecraft.world.item.crafting.RecipeType)TFCRecipeTypes.SEWING.get()));
        KNAPPING_TYPES.forEach((id, type) -> registry.addRecipes(type, JEIIntegration.recipes((net.minecraft.world.item.crafting.RecipeType)TFCRecipeTypes.KNAPPING.get(), r -> r.getKnappingType().getId().toString().replace("_knapping", "").equals(id.toString()))));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        registry.addRecipeCatalyst(new ItemStack((ItemLike)TFCBlocks.FIREPIT.get()), new RecipeType[]{HEATING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)TFCBlocks.QUERN.get()), new RecipeType[]{QUERN});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)TFCItems.POT.get()), new RecipeType[]{SIMPLE_POT});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)TFCItems.POT.get()), new RecipeType[]{SOUP_POT});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)TFCBlocks.CERAMIC_BOWL.get()), new RecipeType[]{SOUP_POT});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)Items.f_42399_), new RecipeType[]{SOUP_POT});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)TFCItems.POT.get()), new RecipeType[]{JAM_POT});
        JEIIntegration.addRecipeCatalyst(registry, TFCTags.Items.EMPTY_JAR_WITH_LID, JAM_POT);
        registry.addRecipeCatalyst(new ItemStack((ItemLike)TFCBlocks.CRUCIBLE.get()), new RecipeType[]{ALLOYING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)TFCItems.VESSEL.get()), new RecipeType[]{ALLOYING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)TFCBlocks.BLOOMERY.get()), new RecipeType[]{BLOOMERY});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)TFCBlocks.BLAST_FURNACE.get()), new RecipeType[]{BLAST_FURNACE});
        JEIIntegration.addRecipeCatalyst(registry, TFCTags.Items.SEWING_NEEDLES, SEWING);
        JEIIntegration.addRecipeCatalyst(registry, TFCTags.Items.SEWING_DARK_CLOTH, SEWING);
        JEIIntegration.addRecipeCatalyst(registry, TFCTags.Items.SEWING_LIGHT_CLOTH, SEWING);
        JEIIntegration.addRecipeCatalyst(registry, Wood.BlockType.SEWING_TABLE, SEWING);
        JEIIntegration.addRecipeCatalyst(registry, TFCTags.Items.ALL_BLOWPIPES, GLASSWORKING);
        JEIIntegration.addRecipeCatalyst(registry, TFCTags.Items.TUYERES, BLAST_FURNACE);
        for (RegistryObject<Item> reg : TFCItems.GLAZED_VESSELS.values()) {
            registry.addRecipeCatalyst(new ItemStack((ItemLike)reg.get()), new RecipeType[]{ALLOYING});
        }
        JEIIntegration.addRecipeCatalyst(registry, TFCTags.Items.KNIVES, SCRAPING);
        JEIIntegration.addRecipeCatalyst(registry, TFCTags.Items.HANDSTONE, QUERN);
        JEIIntegration.addRecipeCatalyst(registry, TFCTags.Items.ANVILS, WELDING);
        JEIIntegration.addRecipeCatalyst(registry, TFCTags.Items.ANVILS, ANVIL);
        JEIIntegration.addRecipeCatalyst(registry, Wood.BlockType.LOOM, LOOM);
        JEIIntegration.addRecipeCatalyst(registry, Wood.BlockType.BARREL, SEALED_BARREL);
        JEIIntegration.addRecipeCatalyst(registry, Wood.BlockType.BARREL, INSTANT_BARREL);
        JEIIntegration.addRecipeCatalyst(registry, Wood.BlockType.BARREL, INSTANT_FLUID_BARREL);
        for (KnappingType knappingType : KnappingType.MANAGER.getValues()) {
            RecipeType<KnappingRecipe> recipeType = JEIIntegration.getKnappingType(knappingType);
            for (ItemStack item : knappingType.inputItem().ingredient().m_43908_()) {
                registry.addRecipeCatalyst(item, new RecipeType[]{recipeType});
            }
        }
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registry) {
        registry.addRecipeClickArea(KnappingScreen.class, 97, 44, 22, 15, KNAPPING_TYPES.values().toArray(new RecipeType[0]));
        registry.addRecipeClickArea(AnvilScreen.class, 26, 24, 9, 14, new RecipeType[]{ANVIL, WELDING});
        registry.addRecipeClickArea(BarrelScreen.class, 92, 21, 9, 14, new RecipeType[]{SEALED_BARREL, INSTANT_BARREL, INSTANT_FLUID_BARREL});
        registry.addRecipeClickArea(CrucibleScreen.class, 82, 100, 10, 15, new RecipeType[]{HEATING});
        registry.addRecipeClickArea(CrucibleScreen.class, 139, 100, 10, 15, new RecipeType[]{ALLOYING, CASTING});
        registry.addRecipeClickArea(FirepitScreen.class, 79, 46, 18, 10, new RecipeType[]{HEATING});
        registry.addRecipeClickArea(GrillScreen.class, 61, 37, 18, 10, new RecipeType[]{HEATING});
        registry.addRecipeClickArea(PotScreen.class, 77, 6, 9, 14, new RecipeType[]{SIMPLE_POT, SOUP_POT, JAM_POT});
        registry.addRecipeClickArea(SewingTableScreen.class, 125, 84, 22, 15, new RecipeType[]{SEWING});
        registry.addGuiContainerHandler(InventoryScreen.class, new TFCInventoryGuiHandler());
        registry.addGuiContainerHandler(CalendarScreen.class, new TFCInventoryGuiHandler());
        registry.addGuiContainerHandler(ClimateScreen.class, new TFCInventoryGuiHandler());
        registry.addGuiContainerHandler(NutritionScreen.class, new TFCInventoryGuiHandler());
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registry) {
        registry.addRecipeTransferHandler(FirepitContainer.class, (MenuType)TFCContainerTypes.FIREPIT.get(), HEATING, 4, 1, 7, 36);
        registry.addRecipeTransferHandler(GrillContainer.class, (MenuType)TFCContainerTypes.GRILL.get(), HEATING, 4, 5, 9, 36);
        registry.addRecipeTransferHandler(CrucibleContainer.class, (MenuType)TFCContainerTypes.CRUCIBLE.get(), HEATING, 0, 9, 10, 36);
        IRecipeTransferHandlerHelper transferHelper = registry.getTransferHelper();
        IRecipeTransferInfo basicRecipeTransferInfo = transferHelper.createBasicRecipeTransferInfo(CrucibleContainer.class, (MenuType)TFCContainerTypes.CRUCIBLE.get(), CASTING, 9, 1, 10, 36);
        registry.addRecipeTransferHandler(new FluidIgnoringRecipeTransferHandler(transferHelper, transferHelper.createUnregisteredRecipeTransferHandler(basicRecipeTransferInfo)), CASTING);
        registry.addRecipeTransferHandler((IRecipeTransferInfo)new WeldingRecipeTransferInfo(transferHelper));
        registry.addRecipeTransferHandler(new AnvilRecipeTransferHandler(transferHelper.createUnregisteredRecipeTransferHandler((IRecipeTransferInfo)new AnvilRecipeTransferInfo(transferHelper))), ANVIL);
        registry.addRecipeTransferHandler(new FluidIgnoringRecipeTransferHandler(transferHelper, transferHelper.createUnregisteredRecipeTransferHandler((IRecipeTransferInfo)new PotTransferInfo(transferHelper, SIMPLE_POT))), SIMPLE_POT);
        registry.addRecipeTransferHandler(new FluidIgnoringRecipeTransferHandler(transferHelper, transferHelper.createUnregisteredRecipeTransferHandler((IRecipeTransferInfo)new PotTransferInfo(transferHelper, SOUP_POT))), SOUP_POT);
        registry.addRecipeTransferHandler(new FluidIgnoringRecipeTransferHandler(transferHelper, transferHelper.createUnregisteredRecipeTransferHandler((IRecipeTransferInfo)new PotTransferInfo(transferHelper, JAM_POT))), JAM_POT);
        registry.addRecipeTransferHandler(new FluidIgnoringRecipeTransferHandler(transferHelper, transferHelper.createUnregisteredRecipeTransferHandler(new BarrelTransferInfo<SealedBarrelRecipe>(SEALED_BARREL))), SEALED_BARREL);
    }

    public void registerVanillaCategoryExtensions(IVanillaCategoryExtensionRegistration registry) {
        registry.getCraftingCategory().addCategoryExtension(AdvancedShapelessRecipe.class, AdvancedShapelessExtension::new);
        registry.getCraftingCategory().addCategoryExtension(ExtraProductsCraftingRecipe.class, ExtraProductsExtension::new);
    }
}

