/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.jade.common;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.dries007.tfc.common.blockentities.AbstractFirepitBlockEntity;
import net.dries007.tfc.common.blockentities.BarrelBlockEntity;
import net.dries007.tfc.common.blockentities.BellowsBlockEntity;
import net.dries007.tfc.common.blockentities.BlastFurnaceBlockEntity;
import net.dries007.tfc.common.blockentities.BloomBlockEntity;
import net.dries007.tfc.common.blockentities.BloomeryBlockEntity;
import net.dries007.tfc.common.blockentities.CharcoalForgeBlockEntity;
import net.dries007.tfc.common.blockentities.ComposterBlockEntity;
import net.dries007.tfc.common.blockentities.CropBlockEntity;
import net.dries007.tfc.common.blockentities.CrucibleBlockEntity;
import net.dries007.tfc.common.blockentities.DecayingBlockEntity;
import net.dries007.tfc.common.blockentities.IngotPileBlockEntity;
import net.dries007.tfc.common.blockentities.LampBlockEntity;
import net.dries007.tfc.common.blockentities.LoomBlockEntity;
import net.dries007.tfc.common.blockentities.NestBoxBlockEntity;
import net.dries007.tfc.common.blockentities.PitKilnBlockEntity;
import net.dries007.tfc.common.blockentities.PotBlockEntity;
import net.dries007.tfc.common.blockentities.PowderkegBlockEntity;
import net.dries007.tfc.common.blockentities.SheetPileBlockEntity;
import net.dries007.tfc.common.blockentities.TickCounterBlockEntity;
import net.dries007.tfc.common.blockentities.rotation.RotatingBlockEntity;
import net.dries007.tfc.common.blocks.BloomBlock;
import net.dries007.tfc.common.blocks.HotPouredGlassBlock;
import net.dries007.tfc.common.blocks.TFCCandleBlock;
import net.dries007.tfc.common.blocks.TFCCandleCakeBlock;
import net.dries007.tfc.common.blocks.TFCTorchBlock;
import net.dries007.tfc.common.blocks.TFCWallTorchBlock;
import net.dries007.tfc.common.blocks.crop.CropBlock;
import net.dries007.tfc.common.blocks.crop.DecayingBlock;
import net.dries007.tfc.common.blocks.devices.BarrelBlock;
import net.dries007.tfc.common.blocks.devices.BellowsBlock;
import net.dries007.tfc.common.blocks.devices.BlastFurnaceBlock;
import net.dries007.tfc.common.blocks.devices.BloomeryBlock;
import net.dries007.tfc.common.blocks.devices.CharcoalForgeBlock;
import net.dries007.tfc.common.blocks.devices.CrucibleBlock;
import net.dries007.tfc.common.blocks.devices.DryingBricksBlock;
import net.dries007.tfc.common.blocks.devices.FirepitBlock;
import net.dries007.tfc.common.blocks.devices.IngotPileBlock;
import net.dries007.tfc.common.blocks.devices.JackOLanternBlock;
import net.dries007.tfc.common.blocks.devices.LampBlock;
import net.dries007.tfc.common.blocks.devices.NestBoxBlock;
import net.dries007.tfc.common.blocks.devices.PitKilnBlock;
import net.dries007.tfc.common.blocks.devices.PowderkegBlock;
import net.dries007.tfc.common.blocks.devices.QuernBlock;
import net.dries007.tfc.common.blocks.devices.SheetPileBlock;
import net.dries007.tfc.common.blocks.devices.TFCComposterBlock;
import net.dries007.tfc.common.blocks.plant.fruit.FruitTreeSaplingBlock;
import net.dries007.tfc.common.blocks.rotation.AbstractShaftAxleBlock;
import net.dries007.tfc.common.blocks.rotation.ClutchBlock;
import net.dries007.tfc.common.blocks.rotation.CrankshaftBlock;
import net.dries007.tfc.common.blocks.rotation.EncasedAxleBlock;
import net.dries007.tfc.common.blocks.rotation.GearBoxBlock;
import net.dries007.tfc.common.blocks.rotation.HandWheelBlock;
import net.dries007.tfc.common.blocks.rotation.WaterWheelBlock;
import net.dries007.tfc.common.blocks.rotation.WindmillBlock;
import net.dries007.tfc.common.blocks.soil.HoeOverlayBlock;
import net.dries007.tfc.common.blocks.wood.TFCLoomBlock;
import net.dries007.tfc.common.blocks.wood.TFCSaplingBlock;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.capabilities.egg.EggCapability;
import net.dries007.tfc.common.capabilities.egg.IEgg;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.heat.HeatCapability;
import net.dries007.tfc.common.capabilities.heat.IHeat;
import net.dries007.tfc.common.items.Powder;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.common.recipes.BarrelRecipe;
import net.dries007.tfc.common.recipes.BloomeryRecipe;
import net.dries007.tfc.common.recipes.LoomRecipe;
import net.dries007.tfc.compat.jade.common.BlockEntityTooltip;
import net.dries007.tfc.compat.jade.common.RegisterCallback;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.config.TemperatureDisplayStyle;
import net.dries007.tfc.util.LampFuel;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.ICalendar;
import net.dries007.tfc.util.rotation.Rotation;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public final class BlockEntityTooltips {
    public static final BlockEntityTooltip HOT_POURED_GLASS = (level, state, pos, entity, tooltip) -> {
        if (state.m_60734_() instanceof HotPouredGlassBlock && !((Boolean)state.m_61143_((Property)HotPouredGlassBlock.FLAT)).booleanValue()) {
            tooltip.accept(Component.m_237115_((String)"tfc.tooltip.glass.flatten_me"));
        }
    };
    public static final BlockEntityTooltip ROTATING = (level, state, pos, entity, tooltip) -> {
        RotatingBlockEntity rotating;
        Rotation rotation;
        if (entity instanceof RotatingBlockEntity && (rotation = (rotating = (RotatingBlockEntity)entity).getRotationNode().rotation()) != null && rotation.speed() != 0.0f) {
            tooltip.accept(Component.m_237110_((String)"tfc.tooltip.rotation.angular_velocity", (Object[])new Object[]{String.format("%.2f", Float.valueOf(Math.abs(rotation.positiveSpeed()) * 20.0f))}));
        }
    };
    public static final BlockEntityTooltip INGOT_PILE = (level, state, pos, entity, tooltip) -> {
        if (entity instanceof IngotPileBlockEntity) {
            IngotPileBlockEntity pile = (IngotPileBlockEntity)entity;
            pile.fillTooltip(tooltip);
        }
    };
    public static final BlockEntityTooltip SHEET_PILE = (level, state, pos, entity, tooltip) -> {
        if (entity instanceof SheetPileBlockEntity) {
            SheetPileBlockEntity pile = (SheetPileBlockEntity)entity;
            pile.fillTooltip(tooltip);
        }
    };
    public static final BlockEntityTooltip BARREL = (level, state, pos, entity, tooltip) -> {
        if (state.m_60734_() instanceof BarrelBlock && entity instanceof BarrelBlockEntity) {
            BarrelRecipe recipe;
            long tickLeft;
            BarrelBlockEntity barrel = (BarrelBlockEntity)entity;
            if (((Boolean)state.m_61143_((Property)BarrelBlock.SEALED)).booleanValue() && (tickLeft = barrel.getRemainingTicks()) > 0L && (recipe = barrel.getRecipe()) != null) {
                tooltip.accept(recipe.getTranslationComponent());
                tooltip.accept(Component.m_237110_((String)"tfc.jade.sealed_date", (Object[])new Object[]{ICalendar.getTimeAndDate(Calendars.get((LevelReader)level).ticksToCalendarTicks(barrel.getSealedTick()), Calendars.get((LevelReader)level).getCalendarDaysInMonth())}));
                BlockEntityTooltips.timeLeft(level, tooltip, tickLeft);
            }
        }
    };
    public static final BlockEntityTooltip BELLOWS = (level, state, pos, entity, tooltip) -> {
        BellowsBlockEntity bellows;
        int step;
        if (entity instanceof BellowsBlockEntity && (step = Mth.m_14045_((int)((int)Mth.m_184637_((float)(bellows = (BellowsBlockEntity)entity).getExtensionLength(0.0f), (float)0.125f, (float)0.625f, (float)0.0f, (float)10.0f)), (int)0, (int)10)) > 0) {
            tooltip.accept(Component.m_237115_((String)("tfc.jade.bellows_" + step)));
        }
    };
    public static final BlockEntityTooltip BLAST_FURNACE = (level, state, pos, entity, tooltip) -> {
        if (entity instanceof BlastFurnaceBlockEntity) {
            BlastFurnaceBlockEntity furnace = (BlastFurnaceBlockEntity)entity;
            furnace.getCapability(HeatCapability.BLOCK_CAPABILITY).ifPresent(cap -> BlockEntityTooltips.heat(tooltip, cap.getTemperature()));
            tooltip.accept(Component.m_237110_((String)"tfc.jade.input_stacks", (Object[])new Object[]{furnace.getInputCount()}));
            tooltip.accept(Component.m_237110_((String)"tfc.jade.catalyst_stacks", (Object[])new Object[]{furnace.getCatalystCount()}));
            tooltip.accept(Component.m_237110_((String)"tfc.jade.fuel_stacks", (Object[])new Object[]{furnace.getFuelCount()}));
        }
    };
    public static final BlockEntityTooltip BLOOMERY = (level, state, pos, entity, tooltip) -> {
        if (entity instanceof BloomeryBlockEntity) {
            BloomeryBlockEntity bloomery = (BloomeryBlockEntity)entity;
            if (state.m_60734_() instanceof BloomeryBlock) {
                BloomeryRecipe recipe;
                long ticksLeft;
                tooltip.accept(Component.m_237110_((String)"tfc.jade.input_stacks", (Object[])new Object[]{bloomery.getInputCount()}));
                if (((Boolean)state.m_61143_((Property)BloomeryBlock.LIT)).booleanValue() && (ticksLeft = bloomery.getRemainingTicks()) > 0L && (recipe = bloomery.getCachedRecipe()) != null) {
                    BlockEntityTooltips.timeLeft(level, tooltip, ticksLeft);
                    tooltip.accept(Component.m_237110_((String)"tfc.jade.creating", (Object[])new Object[]{recipe.m_8043_(level.m_9598_()).m_41786_()}));
                }
                if (((Boolean)TFCConfig.CLIENT.enableDebug.get()).booleanValue()) {
                    Object2IntOpenHashMap items = new Object2IntOpenHashMap();
                    for (ItemStack stack : bloomery.getInputStacks()) {
                        items.mergeInt((Object)stack.m_41720_(), 1, Integer::sum);
                    }
                    for (Map.Entry entry : items.object2IntEntrySet()) {
                        BlockEntityTooltips.itemWithCount(tooltip, new ItemStack((ItemLike)entry.getKey(), ((Integer)entry.getValue()).intValue()));
                    }
                }
            }
        }
    };
    public static final BlockEntityTooltip BLOOM = (level, state, pos, entity, tooltip) -> {
        if (entity instanceof BloomBlockEntity) {
            BloomBlockEntity bloom = (BloomBlockEntity)entity;
            ItemStack item = bloom.getItem();
            ItemStack displayItem = item.m_41777_();
            displayItem.m_41764_(bloom.getCount());
            BlockEntityTooltips.itemWithCount(tooltip, displayItem);
            ArrayList<Component> text = new ArrayList<Component>();
            IHeat heat = HeatCapability.get(item);
            if (heat != null) {
                heat.addTooltipInfo(item, text);
            }
            text.forEach(tooltip);
        }
    };
    public static final BlockEntityTooltip CHARCOAL_FORGE = (level, state, pos, entity, tooltip) -> {
        if (entity instanceof CharcoalForgeBlockEntity) {
            CharcoalForgeBlockEntity forge = (CharcoalForgeBlockEntity)entity;
            BlockEntityTooltips.heat(tooltip, forge.getTemperature());
        }
    };
    public static final BlockEntityTooltip COMPOSTER = (level, state, pos, entity, tooltip) -> {
        Block patt14872$temp = state.m_60734_();
        if (patt14872$temp instanceof TFCComposterBlock) {
            TFCComposterBlock block = (TFCComposterBlock)patt14872$temp;
            if (entity instanceof ComposterBlockEntity) {
                ComposterBlockEntity composter = (ComposterBlockEntity)entity;
                if (composter.isRotten()) {
                    tooltip.accept(Component.m_237115_((String)"tfc.composter.rotten"));
                } else if (!composter.isReady() && (Integer)state.m_61143_((Property)TFCComposterBlock.STAGE) == 8) {
                    BlockEntityTooltips.timeLeft(level, tooltip, composter.getReadyTicks() - composter.getTicksSinceUpdate());
                }
            }
        }
    };
    public static final BlockEntityTooltip CROP = (level, state, pos, entity, tooltip) -> {
        if (entity instanceof CropBlockEntity) {
            CropBlockEntity crop = (CropBlockEntity)entity;
            Block patt15592$temp = state.m_60734_();
            if (patt15592$temp instanceof CropBlock) {
                CropBlock block = (CropBlock)patt15592$temp;
                tooltip.accept(Component.m_237110_((String)"tfc.jade.yield", (Object[])new Object[]{String.format("%.0f", Float.valueOf(crop.getYield() * 100.0f))}));
            }
        }
    };
    public static final BlockEntityTooltip CRUCIBLE = (level, state, pos, entity, tooltip) -> {
        if (entity instanceof CrucibleBlockEntity) {
            CrucibleBlockEntity crucible = (CrucibleBlockEntity)entity;
            crucible.getCapability(HeatCapability.BLOCK_CAPABILITY).ifPresent(cap -> BlockEntityTooltips.heat(tooltip, cap.getTemperature()));
        }
    };
    public static final BlockEntityTooltip FIREPIT = (level, state, pos, entity, tooltip) -> {
        if (entity instanceof AbstractFirepitBlockEntity) {
            AbstractFirepitBlockEntity firepit = (AbstractFirepitBlockEntity)entity;
            BlockEntityTooltips.heat(tooltip, firepit.getTemperature());
            if (state.m_61138_((Property)FirepitBlock.SMOKE_LEVEL)) {
                tooltip.accept(Component.m_237110_((String)"tfc.jade.smoke_level", (Object[])new Object[]{state.m_61143_((Property)FirepitBlock.SMOKE_LEVEL)}));
            }
            if (firepit.getAsh() > 0) {
                BlockEntityTooltips.itemWithCount(tooltip, new ItemStack((ItemLike)TFCItems.POWDERS.get((Object)Powder.WOOD_ASH).get(), firepit.getAsh()));
            }
            if (firepit instanceof PotBlockEntity) {
                PotBlockEntity pot = (PotBlockEntity)firepit;
                if (pot.shouldRenderAsBoiling()) {
                    tooltip.accept(Component.m_237115_((String)"tfc.tooltip.pot_boiling"));
                } else if (pot.getOutput() != null && !pot.getOutput().isEmpty()) {
                    tooltip.accept(Component.m_237115_((String)"tfc.tooltip.pot_finished"));
                    BlockEntityTooltip tt = pot.getOutput().getTooltip();
                    if (tt != null) {
                        tt.display(level, state, pos, entity, tooltip);
                    }
                }
            }
        }
    };
    public static final BlockEntityTooltip FRUIT_TREE_SAPLING = (level, state, pos, entity, tooltip) -> {
        if (entity instanceof TickCounterBlockEntity) {
            TickCounterBlockEntity counter = (TickCounterBlockEntity)entity;
            Block patt17638$temp = state.m_60734_();
            if (patt17638$temp instanceof FruitTreeSaplingBlock) {
                FruitTreeSaplingBlock sapling = (FruitTreeSaplingBlock)patt17638$temp;
                BlockEntityTooltips.timeLeft(level, tooltip, (long)((double)(sapling.getTreeGrowthDays() * 24000) * (Double)TFCConfig.SERVER.globalFruitSaplingGrowthModifier.get()) - counter.getTicksSinceUpdate(), (Component)Component.m_237115_((String)"tfc.jade.ready_to_grow"));
            }
        }
    };
    public static final BlockEntityTooltip HOE_OVERLAY = (level, state, pos, entity, tooltip) -> {
        Block patt18084$temp = state.m_60734_();
        if (patt18084$temp instanceof HoeOverlayBlock) {
            HoeOverlayBlock overlay = (HoeOverlayBlock)patt18084$temp;
            if (((Boolean)TFCConfig.CLIENT.showHoeOverlaysInInfoMods.get()).booleanValue() && entity != null) {
                ArrayList<Component> text = new ArrayList<Component>();
                BlockPos pos1 = entity.m_58899_();
                overlay.addHoeOverlayInfo(level, pos1, level.m_8055_(pos1), text, false);
                text.forEach(tooltip);
            }
        }
    };
    public static final BlockEntityTooltip LAMP = (level, state, pos, entity, tooltip) -> {
        if (entity instanceof LampBlockEntity) {
            LampFuel fuel;
            LampBlockEntity lamp = (LampBlockEntity)entity;
            if (state.m_60734_() instanceof LampBlock && (fuel = lamp.getFuel()) != null) {
                if (fuel.getBurnRate() != -1) {
                    tooltip.accept(Component.m_237110_((String)"tfc.jade.burn_rate", (Object[])new Object[]{fuel.getBurnRate()}));
                }
                if (((Boolean)state.m_61143_((Property)LampBlock.LIT)).booleanValue()) {
                    if (fuel.getBurnRate() == -1) {
                        tooltip.accept(Component.m_237115_((String)"tfc.jade.burn_forever"));
                    } else {
                        lamp.getCapability(Capabilities.FLUID).ifPresent(cap -> {
                            int fluid = cap.getFluidInTank(0).getAmount();
                            if (fluid > 0) {
                                BlockEntityTooltips.timeLeft(level, tooltip, (long)fluid * (long)fuel.getBurnRate());
                            }
                        });
                    }
                }
            }
        }
    };
    public static final BlockEntityTooltip NEST_BOX = (level, state, pos, entity, tooltip) -> {
        if (entity instanceof NestBoxBlockEntity) {
            NestBoxBlockEntity nest = (NestBoxBlockEntity)entity;
            ArrayList text = new ArrayList();
            nest.getCapability(Capabilities.ITEM).ifPresent(inventory -> {
                for (int i = 0; i < inventory.getSlots(); ++i) {
                    ItemStack stack = inventory.getStackInSlot(i);
                    IEgg egg = EggCapability.get(stack);
                    if (egg == null) continue;
                    text.add(stack.m_41786_());
                    egg.addTooltipInfo(text);
                }
            });
            text.forEach(tooltip);
        }
    };
    public static final BlockEntityTooltip PIT_KILN_INTERNAL = (level, state, pos, entity, tooltip) -> BlockEntityTooltips.pitKiln(level, pos, tooltip);
    public static final BlockEntityTooltip PIT_KILN_ABOVE = (level, state, pos, entity, tooltip) -> BlockEntityTooltips.pitKiln(level, pos.m_7495_(), tooltip);
    public static final BlockEntityTooltip POWDER_KEG = (level, state, pos, entity, tooltip) -> {
        if (entity instanceof PowderkegBlockEntity) {
            PowderkegBlockEntity keg = (PowderkegBlockEntity)entity;
            tooltip.accept(Component.m_237110_((String)"tfc.jade.explosion_strength", (Object[])new Object[]{PowderkegBlockEntity.getStrength(keg)}));
        }
    };
    public static final BlockEntityTooltip SAPLING = (level, state, pos, entity, tooltip) -> {
        if (entity instanceof TickCounterBlockEntity) {
            TickCounterBlockEntity counter = (TickCounterBlockEntity)entity;
            Block patt21437$temp = state.m_60734_();
            if (patt21437$temp instanceof TFCSaplingBlock) {
                TFCSaplingBlock sapling = (TFCSaplingBlock)patt21437$temp;
                BlockEntityTooltips.timeLeft(level, tooltip, (long)((double)(sapling.getDaysToGrow() * 24000) * (Double)TFCConfig.SERVER.globalSaplingGrowthModifier.get()) - counter.getTicksSinceUpdate(), (Component)Component.m_237115_((String)"tfc.jade.ready_to_grow"));
            }
        }
    };
    public static final BlockEntityTooltip TORCH = BlockEntityTooltips.tickCounter((Supplier<Integer>)TFCConfig.SERVER.torchTicks);
    public static final BlockEntityTooltip CANDLE = BlockEntityTooltips.tickCounter((Supplier<Integer>)TFCConfig.SERVER.candleTicks);
    public static final BlockEntityTooltip JACK_O_LANTERN = BlockEntityTooltips.tickCounter((Supplier<Integer>)TFCConfig.SERVER.jackOLanternTicks);
    public static final BlockEntityTooltip MUD_BRICKS = (level, state, pos, entity, tooltip) -> {
        if (entity instanceof TickCounterBlockEntity) {
            TickCounterBlockEntity counter = (TickCounterBlockEntity)entity;
            if (state.m_60734_() instanceof DryingBricksBlock) {
                if (((Boolean)state.m_61143_((Property)DryingBricksBlock.DRIED)).booleanValue()) {
                    tooltip.accept(Component.m_237115_((String)"tfc.jade.dried_mud_bricks"));
                } else if (level.m_46758_(entity.m_58899_().m_7494_())) {
                    tooltip.accept(Component.m_237115_((String)"tfc.jade.raining_mud_bricks").m_130940_(ChatFormatting.BLUE));
                } else {
                    BlockEntityTooltips.timeLeft(level, tooltip, (long)((Integer)TFCConfig.SERVER.mudBricksTicks.get()).intValue() - counter.getTicksSinceUpdate(), (Component)Component.m_237115_((String)"tfc.jade.mud_bricks_nearly_done"));
                }
            }
        }
    };
    public static final BlockEntityTooltip DECAYING = (level, state, pos, entity, tooltip) -> {
        if (entity instanceof DecayingBlockEntity) {
            DecayingBlockEntity decaying = (DecayingBlockEntity)entity;
            ItemStack stack = decaying.getStack();
            ArrayList<Component> text = new ArrayList<Component>();
            tooltip.accept(stack.m_41786_());
            FoodCapability.addTooltipInfo(stack, text);
            text.forEach(tooltip);
        }
    };
    public static final BlockEntityTooltip LOOM = (level, state, pos, entity, tooltip) -> {
        LoomBlockEntity loom;
        LoomRecipe recipe;
        if (entity instanceof LoomBlockEntity && (recipe = (loom = (LoomBlockEntity)entity).getRecipe()) != null) {
            tooltip.accept(Component.m_237110_((String)"tfc.jade.loom_progress", (Object[])new Object[]{loom.getProgress(), recipe.getStepCount(), recipe.m_8043_(level.m_9598_()).m_41611_()}));
        }
    };

    public static void register(RegisterCallback<BlockEntityTooltip, Block> callback) {
        callback.register("barrel", BARREL, BarrelBlock.class);
        callback.register("bellows", BELLOWS, BellowsBlock.class);
        callback.register("sapling", SAPLING, TFCSaplingBlock.class);
        callback.register("blast_furnace", BLAST_FURNACE, BlastFurnaceBlock.class);
        callback.register("bloomery", BLOOMERY, BloomeryBlock.class);
        callback.register("bloom", BLOOM, BloomBlock.class);
        callback.register("charcoal_forge", CHARCOAL_FORGE, CharcoalForgeBlock.class);
        callback.register("composter", COMPOSTER, TFCComposterBlock.class);
        callback.register("crop", CROP, CropBlock.class);
        callback.register("crucible", CRUCIBLE, CrucibleBlock.class);
        callback.register("firepit", FIREPIT, FirepitBlock.class);
        callback.register("fruit_tree_sapling", FRUIT_TREE_SAPLING, FruitTreeSaplingBlock.class);
        callback.register("hoe_overlay", HOE_OVERLAY, Block.class);
        callback.register("lamp", LAMP, LampBlock.class);
        callback.register("nest_box", NEST_BOX, NestBoxBlock.class);
        callback.register("pit_kiln_internal", PIT_KILN_INTERNAL, PitKilnBlock.class);
        callback.register("pit_kiln_above", PIT_KILN_ABOVE, FireBlock.class);
        callback.register("powder_keg", POWDER_KEG, PowderkegBlock.class);
        callback.register("torch", TORCH, TFCTorchBlock.class);
        callback.register("wall_torch", TORCH, TFCWallTorchBlock.class);
        callback.register("candle", CANDLE, TFCCandleBlock.class);
        callback.register("candle_cake", CANDLE, TFCCandleCakeBlock.class);
        callback.register("jack_o_lantern", JACK_O_LANTERN, JackOLanternBlock.class);
        callback.register("mud_bricks", MUD_BRICKS, DryingBricksBlock.class);
        callback.register("decaying", DECAYING, DecayingBlock.class);
        callback.register("loom", LOOM, TFCLoomBlock.class);
        callback.register("sheet_pile", SHEET_PILE, SheetPileBlock.class);
        callback.register("ingot_pile", INGOT_PILE, IngotPileBlock.class);
        callback.register("axle", ROTATING, AbstractShaftAxleBlock.class);
        callback.register("encased_axle", ROTATING, EncasedAxleBlock.class);
        callback.register("clutch", ROTATING, ClutchBlock.class);
        callback.register("hand_wheel", ROTATING, HandWheelBlock.class);
        callback.register("gearbox", ROTATING, GearBoxBlock.class);
        callback.register("crankshaft", ROTATING, CrankshaftBlock.class);
        callback.register("quern", ROTATING, QuernBlock.class);
        callback.register("water_wheel", ROTATING, WaterWheelBlock.class);
        callback.register("windmill", ROTATING, WindmillBlock.class);
        callback.register("hot_poured_glass", HOT_POURED_GLASS, HotPouredGlassBlock.class);
    }

    private static void pitKiln(Level level, BlockPos pos, Consumer<Component> tooltip) {
        BlockState state = level.m_8055_(pos);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof PitKilnBlockEntity) {
            PitKilnBlockEntity kiln = (PitKilnBlockEntity)blockEntity;
            if (state.m_60734_() instanceof PitKilnBlock) {
                if ((Integer)state.m_61143_((Property)PitKilnBlock.STAGE) == 16) {
                    BlockEntityTooltips.timeLeft(level, tooltip, kiln.getTicksLeft());
                } else {
                    tooltip.accept((Component)Component.m_237110_((String)"tfc.jade.straws", (Object[])new Object[]{kiln.getStraws().stream().filter(s1 -> !s1.m_41619_()).toList().size()}));
                    tooltip.accept((Component)Component.m_237110_((String)"tfc.jade.logs", (Object[])new Object[]{kiln.getLogs().stream().filter(s -> !s.m_41619_()).toList().size()}));
                }
            }
        }
    }

    public static void itemWithCount(Consumer<Component> tooltip, ItemStack stack) {
        tooltip.accept((Component)Component.m_237113_((String)String.valueOf(stack.m_41613_())).m_130946_("x ").m_7220_(stack.m_41786_()));
    }

    public static void heat(Consumer<Component> tooltip, float temperature) {
        MutableComponent heat = ((TemperatureDisplayStyle)((Object)TFCConfig.CLIENT.heatTooltipStyle.get())).formatColored(temperature);
        if (heat != null) {
            tooltip.accept((Component)heat);
        }
    }

    public static void timeLeft(Level level, Consumer<Component> tooltip, long ticks) {
        BlockEntityTooltips.timeLeft(level, tooltip, ticks, null);
    }

    public static void timeLeft(Level level, Consumer<Component> tooltip, long ticks, @Nullable Component ifNegative) {
        if (ticks > 0L) {
            tooltip.accept((Component)Component.m_237110_((String)"tfc.jade.time_left", (Object[])new Object[]{Calendars.get((LevelReader)level).getTimeDelta(ticks)}));
        } else if (ifNegative != null) {
            tooltip.accept(ifNegative);
        }
    }

    public static BlockEntityTooltip tickCounter(Supplier<Integer> totalTicks) {
        return (level, state, pos, entity, tooltip) -> {
            if (entity instanceof TickCounterBlockEntity) {
                TickCounterBlockEntity counter = (TickCounterBlockEntity)entity;
                BlockEntityTooltips.timeLeft(level, tooltip, (long)((Integer)totalTicks.get()).intValue() - counter.getTicksSinceUpdate());
            }
        };
    }
}

