/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.jade;

import java.util.List;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.soil.SoilBlockType;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.compat.jade.common.BlockEntityTooltip;
import net.dries007.tfc.compat.jade.common.BlockEntityTooltips;
import net.dries007.tfc.compat.jade.common.EntityTooltip;
import net.dries007.tfc.compat.jade.common.EntityTooltips;
import net.dries007.tfc.util.Metal;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import snownee.jade.addon.harvest.HarvestToolProvider;
import snownee.jade.addon.harvest.SimpleToolHandler;
import snownee.jade.addon.harvest.ToolHandler;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;

@WailaPlugin
public class JadeIntegration
implements IWailaPlugin {
    public static void registerToolHandlers() {
        record Info(String name, TagKey<Block> tag, Metal.ItemType itemType) {
        }
        List<Info> toolTypes = List.of(new Info("pickaxe", (TagKey<Block>)BlockTags.f_144282_, Metal.ItemType.PICKAXE), new Info("axe", (TagKey<Block>)BlockTags.f_144280_, Metal.ItemType.AXE), new Info("shovel", (TagKey<Block>)BlockTags.f_144283_, Metal.ItemType.SHOVEL), new Info("hoe", (TagKey<Block>)BlockTags.f_144281_, Metal.ItemType.HOE));
        List<Metal.Default> metalTypes = List.of(Metal.Default.COPPER, Metal.Default.BRONZE, Metal.Default.WROUGHT_IRON, Metal.Default.STEEL, Metal.Default.BLACK_STEEL, Metal.Default.BLUE_STEEL);
        for (Info info : toolTypes) {
            HarvestToolProvider.registerHandler((ToolHandler)new SimpleToolHandler(info.name, info.tag, (Item[])metalTypes.stream().map(metal -> (Item)TFCItems.METAL_ITEMS.get(metal).get((Object)info.itemType).get()).toArray(Item[]::new)));
        }
    }

    public void registerClient(IWailaClientRegistration registry) {
        BlockEntityTooltips.register((name, tooltip, block) -> this.register(registry, name, (BlockEntityTooltip)tooltip, block));
        EntityTooltips.register((name, tooltip, entity) -> this.register(registry, name, (EntityTooltip)tooltip, entity));
        registry.addRayTraceCallback((hit, accessor, originalAccessor) -> {
            BlockAccessor blockAccessor;
            if (accessor instanceof BlockAccessor && (blockAccessor = (BlockAccessor)accessor).getBlock() == TFCBlocks.KAOLIN_CLAY_GRASS.get()) {
                return registry.blockAccessor().from(blockAccessor).blockState(((Block)TFCBlocks.SOIL.get((Object)SoilBlockType.GRASS).get(SoilBlockType.Variant.SILT).get()).m_49966_()).build();
            }
            return accessor;
        });
    }

    private void register(IWailaClientRegistration registry, final ResourceLocation name, final BlockEntityTooltip blockEntityTooltip, Class<? extends Block> block) {
        registry.registerBlockComponent(new IBlockComponentProvider(){

            public void appendTooltip(ITooltip tooltip, BlockAccessor access, IPluginConfig config) {
                blockEntityTooltip.display(access.getLevel(), access.getBlockState(), access.getPosition(), access.getBlockEntity(), arg_0 -> ((ITooltip)tooltip).add(arg_0));
            }

            public ResourceLocation getUid() {
                return name;
            }
        }, block);
    }

    private void register(IWailaClientRegistration registry, final ResourceLocation name, final EntityTooltip entityTooltip, Class<? extends Entity> entityClass) {
        registry.registerEntityComponent(new IEntityComponentProvider(){

            public void appendTooltip(ITooltip tooltip, EntityAccessor access, IPluginConfig config) {
                entityTooltip.display(access.getLevel(), access.getEntity(), arg_0 -> ((ITooltip)tooltip).add(arg_0));
            }

            public ResourceLocation getUid() {
                return name;
            }
        }, entityClass);
    }
}

