/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes.outputs;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.food.FoodData;
import net.dries007.tfc.common.capabilities.food.FoodHandler;
import net.dries007.tfc.common.capabilities.food.IFood;
import net.dries007.tfc.common.capabilities.food.Nutrient;
import net.dries007.tfc.common.capabilities.heat.HeatCapability;
import net.dries007.tfc.common.recipes.RecipeHelpers;
import net.dries007.tfc.common.recipes.outputs.ItemStackModifier;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.JsonHelpers;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

public record MealModifier(FoodData baseFood, List<MealPortion> portions) implements ItemStackModifier
{
    @Override
    public ItemStack apply(ItemStack stack, ItemStack input) {
        @Nullable IFood inputFood = FoodCapability.get(stack);
        if (!(inputFood instanceof FoodHandler.Dynamic)) {
            return stack;
        }
        FoodHandler.Dynamic handler = (FoodHandler.Dynamic)inputFood;
        ArrayList<ItemStack> itemIngredients = new ArrayList<ItemStack>();
        for (ItemStack item2 : RecipeHelpers.getCraftingInput()) {
            if (!FoodCapability.has(item2)) continue;
            boolean alreadyAdded = false;
            for (ItemStack existing : itemIngredients) {
                if (existing.m_41720_() != item2.m_41720_()) continue;
                existing.m_41769_(1);
                alreadyAdded = true;
                break;
            }
            if (alreadyAdded) continue;
            ItemStack tooltipItem = item2.m_255036_(1);
            FoodCapability.setNeverExpires(tooltipItem);
            HeatCapability.setTemperature(tooltipItem, 0.0f);
            itemIngredients.add(tooltipItem);
        }
        if (itemIngredients.isEmpty()) {
            return stack;
        }
        itemIngredients.sort(Comparator.comparing(ItemStack::m_41613_).thenComparing(item -> BuiltInRegistries.f_257033_.m_7981_((Object)item.m_41720_())));
        float[] nutrition = this.baseFood.nutrients();
        float saturation = this.baseFood.saturation();
        float water = this.baseFood.water();
        HashMap<ItemStack, MealPortion> map = new HashMap<ItemStack, MealPortion>();
        for (ItemStack itemStack : itemIngredients) {
            MealPortion selected = null;
            for (MealPortion portion : this.portions) {
                if (!portion.test(itemStack)) continue;
                selected = portion;
                break;
            }
            if (selected == null) continue;
            map.put(itemStack, selected);
        }
        for (Map.Entry entry : map.entrySet()) {
            ItemStack item3 = (ItemStack)entry.getKey();
            MealPortion portion = (MealPortion)entry.getValue();
            @Nullable IFood food = FoodCapability.get(item3);
            if (food == null) continue;
            FoodData data = food.getData();
            for (Nutrient nutrient : Nutrient.VALUES) {
                int n = nutrient.ordinal();
                nutrition[n] = nutrition[n] + data.nutrient(nutrient) * portion.nutrientModifier * (float)item3.m_41613_();
            }
            water += data.water() * portion.waterModifier * (float)item3.m_41613_();
            saturation += data.saturation() * portion.saturationModifier * (float)item3.m_41613_();
        }
        handler.setFood(FoodData.create(this.baseFood.hunger(), water, saturation, nutrition, this.baseFood.decayModifier()));
        handler.setIngredients(itemIngredients);
        handler.setCreationDate(FoodCapability.getRoundedCreationDate());
        return stack;
    }

    public Serializer serializer() {
        return Serializer.INSTANCE;
    }

    public record MealPortion(@Nullable Ingredient ingredient, float nutrientModifier, float waterModifier, float saturationModifier) {
        public boolean test(ItemStack stack) {
            return this.ingredient == null || this.ingredient.test(stack);
        }

        private static MealPortion fromJson(JsonObject json) {
            return new MealPortion(json.has("ingredient") ? Ingredient.m_43917_((JsonElement)json.get("ingredient")) : null, JsonHelpers.m_13820_((JsonObject)json, (String)"nutrient_modifier", (float)1.0f), JsonHelpers.m_13820_((JsonObject)json, (String)"water_modifier", (float)1.0f), JsonHelpers.m_13820_((JsonObject)json, (String)"saturation_modifier", (float)1.0f));
        }

        private static MealPortion fromNetwork(FriendlyByteBuf buffer) {
            return new MealPortion(Helpers.decodeNullable(buffer, Ingredient::m_43940_), buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
        }

        private void toNetwork(FriendlyByteBuf buffer) {
            Helpers.encodeNullable(this.ingredient, buffer, (i, buf) -> i.m_43923_(buffer));
            buffer.writeFloat(this.nutrientModifier);
            buffer.writeFloat(this.waterModifier);
            buffer.writeFloat(this.saturationModifier);
        }
    }

    public static enum Serializer implements ItemStackModifier.Serializer<MealModifier>
    {
        INSTANCE;


        @Override
        public MealModifier fromJson(JsonObject json) {
            FoodData food = FoodData.read(json.getAsJsonObject("food"));
            ArrayList<MealPortion> portions = new ArrayList<MealPortion>();
            JsonArray array = JsonHelpers.m_13832_((JsonObject)json, (String)"portions", (JsonArray)new JsonArray());
            if (!array.isEmpty()) {
                for (JsonElement element : array) {
                    portions.add(MealPortion.fromJson(element.getAsJsonObject()));
                }
            }
            return new MealModifier(food, portions);
        }

        @Override
        public MealModifier fromNetwork(FriendlyByteBuf buffer) {
            FoodData food = FoodData.decode(buffer);
            List portions = Helpers.decodeAll(buffer, new ArrayList(), MealPortion::fromNetwork);
            return new MealModifier(food, portions);
        }

        @Override
        public void toNetwork(MealModifier modifier, FriendlyByteBuf buffer) {
            modifier.baseFood.encode(buffer);
            Helpers.encodeAll(buffer, modifier.portions, (por, buf) -> por.toNetwork(buffer));
        }
    }
}

