/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes.ingredients;

import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.food.FoodTrait;
import net.dries007.tfc.common.capabilities.food.IFood;
import net.dries007.tfc.common.recipes.ingredients.DelegateIngredient;
import net.dries007.tfc.common.recipes.ingredients.TraitIngredient;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import org.jetbrains.annotations.Nullable;

public class LacksTraitIngredient
extends TraitIngredient {
    public static LacksTraitIngredient of(@Nullable Ingredient delegate, FoodTrait trait) {
        return new LacksTraitIngredient(delegate, trait);
    }

    public static LacksTraitIngredient of(FoodTrait trait) {
        return new LacksTraitIngredient(null, trait);
    }

    public LacksTraitIngredient(@Nullable Ingredient delegate, FoodTrait trait) {
        super(delegate, trait);
    }

    @Override
    public boolean test(@Nullable ItemStack stack) {
        return super.test(stack) && stack != null && !FoodCapability.hasTrait(stack, this.trait);
    }

    @Override
    public IIngredientSerializer<? extends DelegateIngredient> getSerializer() {
        return TraitIngredient.TraitSerializer.LACKS_TRAIT;
    }

    @Override
    @Nullable
    protected ItemStack testDefaultItem(ItemStack stack) {
        @Nullable IFood food = FoodCapability.get(stack);
        if (food != null && !food.hasTrait(this.trait)) {
            food.setNonDecaying();
            return stack;
        }
        return null;
    }
}

