/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes.ingredients;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.dries007.tfc.common.capabilities.heat.HeatCapability;
import net.dries007.tfc.common.capabilities.heat.IHeat;
import net.dries007.tfc.common.recipes.ingredients.DelegateIngredient;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.JsonHelpers;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import org.jetbrains.annotations.Nullable;

public class HeatableIngredient
extends DelegateIngredient {
    private final int minTemp;
    private final int maxTemp;

    public static HeatableIngredient of(int minTemp, int maxTemp) {
        return HeatableIngredient.of(null, minTemp, maxTemp);
    }

    public static HeatableIngredient of(@Nullable Ingredient ingredient, int minTemp, int maxTemp) {
        return new HeatableIngredient(ingredient, minTemp, maxTemp);
    }

    protected HeatableIngredient(@Nullable Ingredient delegate, int minTemp, int maxTemp) {
        super(delegate);
        this.minTemp = minTemp;
        this.maxTemp = maxTemp;
    }

    @Override
    public IIngredientSerializer<? extends DelegateIngredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    @Override
    @Nullable
    protected ItemStack testDefaultItem(ItemStack stack) {
        @Nullable IHeat heat = HeatCapability.get(stack);
        if (heat != null) {
            heat.setTemperature(this.minTemp);
            return stack;
        }
        return null;
    }

    @Override
    public boolean test(@Nullable ItemStack stack) {
        if (super.test(stack) && stack != null && !stack.m_41619_()) {
            @Nullable IHeat heat = HeatCapability.get(stack);
            return heat != null && heat.getTemperature() >= (float)this.minTemp && heat.getTemperature() <= (float)this.maxTemp;
        }
        return false;
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = super.toJson();
        if (this.minTemp != Integer.MIN_VALUE) {
            json.addProperty("min_temp", (Number)this.minTemp);
        }
        if (this.maxTemp != Integer.MAX_VALUE) {
            json.addProperty("max_temp", (Number)this.maxTemp);
        }
        return json;
    }

    public static enum Serializer implements IIngredientSerializer<HeatableIngredient>
    {
        INSTANCE;


        public HeatableIngredient parse(FriendlyByteBuf buffer) {
            Ingredient internal = Helpers.decodeNullable(buffer, Ingredient::m_43940_);
            int min = buffer.m_130242_();
            int max = buffer.m_130242_();
            return new HeatableIngredient(internal, min, max);
        }

        public HeatableIngredient parse(JsonObject json) {
            Ingredient internal = json.has("ingredient") ? Ingredient.m_43917_((JsonElement)JsonHelpers.get(json, "ingredient")) : null;
            int min = JsonHelpers.m_13824_((JsonObject)json, (String)"min_temp", (int)Integer.MIN_VALUE);
            int max = JsonHelpers.m_13824_((JsonObject)json, (String)"max_temp", (int)Integer.MAX_VALUE);
            return new HeatableIngredient(internal, min, max);
        }

        public void write(FriendlyByteBuf buffer, HeatableIngredient ingredient) {
            Helpers.encodeNullable(ingredient.delegate, buffer, Ingredient::m_43923_);
            buffer.m_130130_(ingredient.minTemp);
            buffer.m_130130_(ingredient.maxTemp);
        }
    }
}

