/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes.ingredients;

import com.google.gson.JsonElement;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import net.dries007.tfc.common.recipes.ingredients.IngredientType;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public record BlockIngredient(List<IngredientType.Entry<Block>> entries) implements IngredientType<Block>
{
    private static final IngredientType.Factory<Block, BlockIngredient> FACTORY = new IngredientType.Factory("block", BuiltInRegistries.f_256975_, BlockTag::new, BlockIngredient::new);

    public static BlockIngredient fromJson(JsonElement json) {
        return IngredientType.fromJson(json, FACTORY);
    }

    public static BlockIngredient fromNetwork(FriendlyByteBuf buffer) {
        return IngredientType.fromNetwork(buffer, FACTORY);
    }

    @Override
    public boolean test(BlockState state) {
        return this.test(state.m_60734_());
    }

    @Override
    public JsonElement toJson() {
        return IngredientType.toJson(this, FACTORY);
    }

    @Override
    public void toNetwork(FriendlyByteBuf buffer) {
        IngredientType.toNetwork(buffer, this, FACTORY);
    }

    public Collection<Block> blocks() {
        return this.all().toList();
    }

    public record BlockTag(TagKey<Block> tag) implements IngredientType.TagEntry<Block>
    {
        @Override
        public Stream<Block> stream() {
            return Helpers.allBlocks(this.tag);
        }

        @Override
        public boolean test(Block block) {
            return Helpers.isBlock(block, this.tag);
        }
    }
}

