/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.List;
import net.dries007.tfc.common.blockentities.PotBlockEntity;
import net.dries007.tfc.common.recipes.PotRecipe;
import net.dries007.tfc.common.recipes.TFCRecipeSerializers;
import net.dries007.tfc.common.recipes.ingredients.FluidStackIngredient;
import net.dries007.tfc.common.recipes.outputs.ItemStackProvider;
import net.dries007.tfc.util.JsonHelpers;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class SimplePotRecipe
extends PotRecipe {
    protected final FluidStack outputFluid;
    protected final List<ItemStackProvider> outputProviders;

    public SimplePotRecipe(ResourceLocation id, List<Ingredient> itemIngredients, FluidStackIngredient fluidIngredient, int duration, float minTemp, FluidStack outputFluid, List<ItemStackProvider> outputProviders) {
        super(id, itemIngredients, fluidIngredient, duration, minTemp);
        this.outputFluid = outputFluid;
        this.outputProviders = outputProviders;
    }

    public FluidStack getDisplayFluid() {
        return this.outputFluid;
    }

    public List<ItemStackProvider> getOutputProviders() {
        return this.outputProviders;
    }

    @Override
    public PotRecipe.Output getOutput(PotBlockEntity.PotInventory inventory) {
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>(5);
        for (int i = 0; i < Math.min(this.outputProviders.size(), inventory.getSlots()); ++i) {
            ItemStack input = inventory.getStackInSlot(4 + i);
            outputs.add(this.outputProviders.get(i).getSingleStack(input));
        }
        return new SimpleOutput(this.outputFluid.copy(), outputs);
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TFCRecipeSerializers.POT_SIMPLE.get();
    }

    record SimpleOutput(FluidStack fluidOutput, List<ItemStack> itemOutputs) implements PotRecipe.Output
    {
        @Override
        public void onFinish(PotBlockEntity.PotInventory inventory) {
            for (int i = 0; i < this.itemOutputs.size(); ++i) {
                inventory.setStackInSlot(4 + i, this.itemOutputs.get(i));
            }
            inventory.fill(this.fluidOutput, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public static class Serializer
    extends PotRecipe.Serializer<SimplePotRecipe> {
        @Override
        public void toNetwork(FriendlyByteBuf buffer, SimplePotRecipe recipe) {
            super.toNetwork(buffer, recipe);
            buffer.writeFluidStack(recipe.outputFluid);
            buffer.m_130130_(recipe.outputProviders.size());
            recipe.outputProviders.forEach(provider -> provider.toNetwork(buffer));
        }

        @Override
        protected SimplePotRecipe fromJson(ResourceLocation recipeId, JsonObject json, List<Ingredient> ingredients, FluidStackIngredient fluidIngredient, int duration, float minTemp) {
            FluidStack output = json.has("fluid_output") ? JsonHelpers.getFluidStack(json, "fluid_output") : FluidStack.EMPTY;
            ArrayList<ItemStackProvider> stacks = new ArrayList<ItemStackProvider>(5);
            boolean anyProvidersDependOnInput = false;
            if (json.has("item_output")) {
                JsonArray array = json.getAsJsonArray("item_output");
                for (JsonElement element : array) {
                    ItemStackProvider provider = ItemStackProvider.fromJson(element.getAsJsonObject());
                    stacks.add(provider);
                    anyProvidersDependOnInput |= provider.dependsOnInput();
                }
            }
            if (stacks.size() > 5) {
                throw new JsonParseException("Cannot have more than five item stack outputs for pot recipe.");
            }
            if (anyProvidersDependOnInput && stacks.size() != ingredients.size()) {
                throw new JsonParseException("At least one output is an ItemStackProvider that depends on the input. This is only allowed if there are (1) equal number of inputs and outputs, and (2) All inputs and outputs are the same");
            }
            return new SimplePotRecipe(recipeId, ingredients, fluidIngredient, duration, minTemp, output, stacks);
        }

        @Override
        protected SimplePotRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer, List<Ingredient> ingredients, FluidStackIngredient fluidIngredient, int duration, float minTemp) {
            FluidStack fluid = buffer.readFluidStack();
            int size = buffer.m_130242_();
            ArrayList<ItemStackProvider> stacks = new ArrayList<ItemStackProvider>(size);
            if (size > 0) {
                for (int i = 0; i < size; ++i) {
                    stacks.add(ItemStackProvider.fromNetwork(buffer));
                }
            }
            return new SimplePotRecipe(recipeId, ingredients, fluidIngredient, duration, minTemp, fluid, stacks);
        }
    }
}

