/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import net.dries007.tfc.common.recipes.ISimpleRecipe;
import net.dries007.tfc.common.recipes.RecipeSerializerImpl;
import net.dries007.tfc.common.recipes.inventory.ItemStackInventory;
import net.dries007.tfc.common.recipes.outputs.ItemStackProvider;
import net.dries007.tfc.util.JsonHelpers;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public abstract class SimpleItemRecipe
implements ISimpleRecipe<ItemStackInventory> {
    protected final ResourceLocation id;
    protected final Ingredient ingredient;
    protected final ItemStackProvider result;

    public SimpleItemRecipe(ResourceLocation id, Ingredient ingredient, ItemStackProvider result) {
        this.id = id;
        this.ingredient = ingredient;
        this.result = result;
    }

    public Collection<Item> getValidItems() {
        return Arrays.stream(this.getIngredient().m_43908_()).map(ItemStack::m_41720_).collect(Collectors.toSet());
    }

    public boolean matches(ItemStackInventory wrapper, Level level) {
        return this.getIngredient().test(wrapper.getStack());
    }

    public ItemStack m_8043_(@Nullable RegistryAccess access) {
        return this.result.getEmptyStack();
    }

    public ItemStackProvider getResult() {
        return this.result;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Override
    public boolean m_5598_() {
        return this.result.dependsOnInput();
    }

    public ItemStack assemble(ItemStackInventory wrapper, RegistryAccess access) {
        return this.result.getSingleStack(wrapper.getStack());
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public static class Serializer<R extends SimpleItemRecipe>
    extends RecipeSerializerImpl<R> {
        private final Factory<R> factory;

        public Serializer(Factory<R> factory) {
            this.factory = factory;
        }

        public R fromJson(ResourceLocation recipeId, JsonObject json) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)JsonHelpers.get(json, "ingredient"));
            ItemStackProvider result = ItemStackProvider.fromJson(GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            return this.factory.create(recipeId, ingredient, result);
        }

        @Nullable
        public R fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStackProvider result = ItemStackProvider.fromNetwork(buffer);
            return this.factory.create(recipeId, ingredient, result);
        }

        public void toNetwork(FriendlyByteBuf buffer, R recipe) {
            ((SimpleItemRecipe)recipe).getIngredient().m_43923_(buffer);
            ((SimpleItemRecipe)recipe).getResult().toNetwork(buffer);
        }

        public static interface Factory<R extends SimpleItemRecipe> {
            public R create(ResourceLocation var1, Ingredient var2, ItemStackProvider var3);
        }
    }
}

