/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.List;
import net.dries007.tfc.common.container.SewingTableContainer;
import net.dries007.tfc.common.recipes.ISimpleRecipe;
import net.dries007.tfc.common.recipes.RecipeSerializerImpl;
import net.dries007.tfc.common.recipes.TFCRecipeSerializers;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.JsonHelpers;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class SewingRecipe
implements ISimpleRecipe<SewingTableContainer.RecipeWrapper> {
    private final ResourceLocation id;
    private final List<Integer> stitches;
    private final List<Integer> squares;
    private final ItemStack result;

    public SewingRecipe(ResourceLocation id, List<Integer> stitches, List<Integer> squares, ItemStack result) {
        this.id = id;
        this.stitches = stitches;
        this.squares = squares;
        this.result = result;
    }

    public List<Integer> getStitches() {
        return this.stitches;
    }

    public List<Integer> getSquares() {
        return this.squares;
    }

    public boolean matches(SewingTableContainer.RecipeWrapper inventory, Level level) {
        return inventory.squaresMatch(this.squares) && inventory.stitchesMatch(this.stitches);
    }

    public ItemStack m_8043_(RegistryAccess access) {
        return this.result.m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TFCRecipeSerializers.SEWING.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)TFCRecipeTypes.SEWING.get();
    }

    public static class Serializer
    extends RecipeSerializerImpl<SewingRecipe> {
        public SewingRecipe fromJson(ResourceLocation id, JsonObject json) {
            JsonArray stitchArray = json.getAsJsonArray("stitches");
            if (stitchArray.size() != 45) {
                throw new JsonParseException("There must be exactly 45 stitches specified, was " + stitchArray.size());
            }
            ArrayList<Integer> stitches = new ArrayList<Integer>(45);
            for (JsonElement element : stitchArray) {
                stitches.add(element.getAsInt());
            }
            JsonArray squareArray = json.getAsJsonArray("squares");
            if (squareArray.size() != 32) {
                throw new JsonParseException("There must be exactly 32 squares specified, was " + squareArray.size());
            }
            ArrayList<Integer> squares = new ArrayList<Integer>(32);
            for (JsonElement element : squareArray) {
                squares.add(element.getAsInt());
            }
            ItemStack result = JsonHelpers.getItemStack(json, "result");
            return new SewingRecipe(id, stitches, squares, result);
        }

        @Nullable
        public SewingRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            List stitches = Helpers.decodeAll(buffer, new ArrayList(45), FriendlyByteBuf::m_130242_);
            List squares = Helpers.decodeAll(buffer, new ArrayList(32), FriendlyByteBuf::m_130242_);
            ItemStack item = buffer.m_130267_();
            return new SewingRecipe(id, stitches, squares, item);
        }

        public void toNetwork(FriendlyByteBuf buffer, SewingRecipe recipe) {
            Helpers.encodeAll(buffer, recipe.stitches, (i, buf) -> buf.m_130130_(i.intValue()));
            Helpers.encodeAll(buffer, recipe.squares, (i, buf) -> buf.m_130130_(i.intValue()));
            buffer.m_130055_(recipe.result);
        }
    }
}

