/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.NonNullList;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public final class RecipeHelpers {
    private static final CraftingInput EMPTY = new CraftingInput(null, Collections::emptyIterator);
    private static final ThreadLocal<CraftingInput> CRAFTING_INPUT = ThreadLocal.withInitial(() -> EMPTY);

    @Deprecated
    public static void setCraftingContainer(@Nullable CraftingContainer container) {
        CRAFTING_INPUT.set(container == null ? EMPTY : new CraftingInput(container, Helpers.iterate((Container)container)));
    }

    public static void clearCraftingInput() {
        CRAFTING_INPUT.set(EMPTY);
    }

    public static void setCraftingInput(CraftingContainer container) {
        CRAFTING_INPUT.set(new CraftingInput(container, Helpers.iterate((Container)container)));
    }

    public static void setCraftingInput(@Nullable IItemHandler inventory, int startSlotInclusive, int endSlotExclusive) {
        CRAFTING_INPUT.set(inventory == null ? EMPTY : new CraftingInput(null, Helpers.iterate(inventory, startSlotInclusive, endSlotExclusive)));
    }

    @Deprecated
    @Nullable
    public static CraftingContainer getCraftingContainer() {
        return CRAFTING_INPUT.get().container();
    }

    public static Iterable<ItemStack> getCraftingInput() {
        return CRAFTING_INPUT.get().iterator();
    }

    public static NonNullList<Ingredient> dissolvePattern(String[] pattern, Map<String, Ingredient> keys, int patternWidth, int patternHeight) {
        NonNullList recipeItems = NonNullList.m_122780_((int)(patternWidth * patternHeight), (Object)Ingredient.f_43901_);
        HashSet keySet = Sets.newHashSet(keys.keySet());
        keySet.remove(" ");
        for (int row = 0; row < pattern.length; ++row) {
            for (int column = 0; column < pattern[row].length(); ++column) {
                String key = pattern[row].substring(column, column + 1);
                Ingredient ingredient = keys.get(key);
                if (ingredient == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + key + "' but it's not defined in the key");
                }
                keySet.remove(key);
                recipeItems.set(RecipeHelpers.dissolveRowColumn(row, column, patternWidth), (Object)ingredient);
            }
        }
        if (!keySet.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + keySet);
        }
        return recipeItems;
    }

    public static String[] shrink(String ... pattern) {
        int i = Integer.MAX_VALUE;
        int j = 0;
        int k = 0;
        int l = 0;
        for (int i1 = 0; i1 < pattern.length; ++i1) {
            String s = pattern[i1];
            i = Math.min(i, RecipeHelpers.firstNonSpace(s));
            int j1 = RecipeHelpers.lastNonSpace(s);
            j = Math.max(j, j1);
            if (j1 < 0) {
                if (k == i1) {
                    ++k;
                }
                ++l;
                continue;
            }
            l = 0;
        }
        if (pattern.length == l) {
            return new String[0];
        }
        String[] newPattern = new String[pattern.length - l - k];
        for (int k1 = 0; k1 < newPattern.length; ++k1) {
            newPattern[k1] = pattern[k1 + k].substring(i, j + 1);
        }
        return newPattern;
    }

    public static String[] patternFromJson(JsonArray array) {
        return RecipeHelpers.patternFromJson(array, 3, 3);
    }

    public static String[] patternFromJson(JsonArray array, int maxHeight, int maxWidth) {
        String[] pattern = new String[array.size()];
        if (pattern.length > maxHeight) {
            throw new JsonSyntaxException("Invalid pattern: too many rows, " + maxHeight + " is maximum");
        }
        if (pattern.length == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        for (int i = 0; i < pattern.length; ++i) {
            String row = GsonHelper.m_13805_((JsonElement)array.get(i), (String)("pattern[" + i + "]"));
            if (row.length() > maxWidth) {
                throw new JsonSyntaxException("Invalid pattern: too many columns, " + maxWidth + " is maximum");
            }
            if (i > 0 && pattern[0].length() != row.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
            }
            pattern[i] = row;
        }
        return pattern;
    }

    public static Map<String, Ingredient> keyFromJson(JsonObject json) {
        HashMap keys = Maps.newHashMap();
        for (Map.Entry entry : json.entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            keys.put((String)entry.getKey(), Ingredient.m_43917_((JsonElement)((JsonElement)entry.getValue())));
        }
        keys.put(" ", Ingredient.f_43901_);
        return keys;
    }

    public static int dissolveRowColumn(int row, int column, int width) {
        return column + row * width;
    }

    public static int translateMatch(ShapedRecipe recipe, int targetIndex, CraftingContainer inventory) {
        return RecipeHelpers.translateMatch((NonNullList<Ingredient>)recipe.m_7527_(), inventory, recipe.m_44220_(), recipe.m_44221_(), targetIndex);
    }

    public static int translateMatch(NonNullList<Ingredient> recipeItems, CraftingContainer inventory, int width, int height, int targetIndex) {
        for (int startCol = 0; startCol <= inventory.m_39347_() - width; ++startCol) {
            for (int startRow = 0; startRow <= inventory.m_39346_() - height; ++startRow) {
                if (RecipeHelpers.matches(recipeItems, inventory, startCol, startRow, true, width, height)) {
                    return width - 1 - targetIndex % width + startCol + (targetIndex / width + startRow) * inventory.m_39347_();
                }
                if (!RecipeHelpers.matches(recipeItems, inventory, startCol, startRow, false, width, height)) continue;
                return targetIndex % width + startCol + (targetIndex / width + startRow) * inventory.m_39347_();
            }
        }
        return -1;
    }

    public static NonNullList<Ingredient> itemsFromJson(JsonArray array) {
        NonNullList list = NonNullList.m_122779_();
        for (int i = 0; i < array.size(); ++i) {
            list.add((Object)Ingredient.m_43917_((JsonElement)array.get(i)));
        }
        return list;
    }

    private static boolean matches(NonNullList<Ingredient> recipeItems, CraftingContainer inventory, int startCol, int startRow, boolean mirrored, int width, int height) {
        for (int invCol = 0; invCol < inventory.m_39347_(); ++invCol) {
            for (int invRow = 0; invRow < inventory.m_39346_(); ++invRow) {
                int col = invCol - startCol;
                int row = invRow - startRow;
                Ingredient ingredient = Ingredient.f_43901_;
                if (col >= 0 && row >= 0 && col < width && row < height) {
                    ingredient = mirrored ? (Ingredient)recipeItems.get(width - col - 1 + row * width) : (Ingredient)recipeItems.get(col + row * width);
                }
                if (ingredient.test(inventory.m_8020_(invCol + invRow * inventory.m_39347_()))) continue;
                return false;
            }
        }
        return true;
    }

    private static int firstNonSpace(String line) {
        int i;
        for (i = 0; i < line.length() && line.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    private static int lastNonSpace(String line) {
        int i;
        for (i = line.length() - 1; i >= 0 && line.charAt(i) == ' '; --i) {
        }
        return i;
    }

    record CraftingInput(@Nullable CraftingContainer container, Iterable<ItemStack> iterator) {
    }
}

