/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Supplier;
import net.dries007.tfc.common.container.KnappingContainer;
import net.dries007.tfc.common.recipes.ISimpleRecipe;
import net.dries007.tfc.common.recipes.RecipeSerializerImpl;
import net.dries007.tfc.common.recipes.TFCRecipeSerializers;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.dries007.tfc.util.DataManager;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.JsonHelpers;
import net.dries007.tfc.util.KnappingPattern;
import net.dries007.tfc.util.KnappingType;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class KnappingRecipe
implements ISimpleRecipe<KnappingContainer.Query> {
    private final ResourceLocation id;
    private final KnappingPattern pattern;
    private final ItemStack result;
    @Nullable
    private final Ingredient ingredient;
    private final Supplier<KnappingType> knappingType;

    public KnappingRecipe(ResourceLocation id, KnappingPattern pattern, ItemStack result, @Nullable Ingredient ingredient, Supplier<KnappingType> knappingType) {
        this.id = id;
        this.pattern = pattern;
        this.result = result;
        this.ingredient = ingredient;
        this.knappingType = knappingType;
    }

    public boolean matches(KnappingContainer.Query query, Level level) {
        return query.container().getKnappingType() == this.knappingType.get() && query.container().getPattern().matches(this.getPattern()) && this.matchesItem(query.container().getOriginalStack());
    }

    public boolean matchesItem(ItemStack stack) {
        return this.ingredient == null || this.ingredient.test(stack);
    }

    public ItemStack m_8043_(@Nullable RegistryAccess access) {
        return this.result;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TFCRecipeSerializers.KNAPPING.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)TFCRecipeTypes.KNAPPING.get();
    }

    public KnappingPattern getPattern() {
        return this.pattern;
    }

    @Nullable
    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public KnappingType getKnappingType() {
        return this.knappingType.get();
    }

    public static class Serializer
    extends RecipeSerializerImpl<KnappingRecipe> {
        public KnappingRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            DataManager.Reference<KnappingType> knappingType = JsonHelpers.getReference(json, "knapping_type", KnappingType.MANAGER);
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            Ingredient ingredient = json.has("ingredient") ? Ingredient.m_43917_((JsonElement)json.get("ingredient")) : null;
            KnappingPattern pattern = KnappingPattern.fromJson(json);
            return new KnappingRecipe(recipeId, pattern, result, ingredient, knappingType);
        }

        @Nullable
        public KnappingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            KnappingPattern pattern = KnappingPattern.fromNetwork(buffer);
            ItemStack stack = buffer.m_130267_();
            @Nullable Ingredient ingredient = Helpers.decodeNullable(buffer, Ingredient::m_43940_);
            DataManager.Reference<KnappingType> knappingType = KnappingType.MANAGER.getReference(buffer.m_130281_());
            return new KnappingRecipe(recipeId, pattern, stack, ingredient, knappingType);
        }

        public void toNetwork(FriendlyByteBuf buffer, KnappingRecipe recipe) {
            recipe.getPattern().toNetwork(buffer);
            buffer.m_130055_(recipe.result);
            Helpers.encodeNullable(recipe.ingredient, buffer, Ingredient::m_43923_);
            buffer.m_130085_(recipe.knappingType.get().getId());
        }
    }
}

