/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.PotBlockEntity;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.recipes.PotRecipe;
import net.dries007.tfc.common.recipes.TFCRecipeSerializers;
import net.dries007.tfc.common.recipes.ingredients.FluidStackIngredient;
import net.dries007.tfc.compat.jade.common.BlockEntityTooltip;
import net.dries007.tfc.compat.jade.common.BlockEntityTooltips;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.JsonHelpers;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.items.ItemHandlerHelper;

public class JamPotRecipe
extends PotRecipe {
    public static final PotRecipe.OutputType OUTPUT_TYPE = nbt -> {
        ItemStack stack = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("item"));
        ResourceLocation texture = Helpers.resourceLocation(nbt.m_128461_("texture"));
        return new JamOutput(stack, texture);
    };
    private final ItemStack jarredStack;
    private final ResourceLocation texture;

    public JamPotRecipe(ResourceLocation id, List<Ingredient> itemIngredients, FluidStackIngredient fluidIngredient, int duration, float minTemp, ItemStack jarredStack, ResourceLocation texture) {
        super(id, itemIngredients, fluidIngredient, duration, minTemp);
        this.jarredStack = jarredStack;
        this.texture = texture;
    }

    @Override
    public ItemStack m_8043_(RegistryAccess access) {
        return this.jarredStack;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    @Override
    public PotRecipe.Output getOutput(PotBlockEntity.PotInventory inventory) {
        return new JamOutput(this.jarredStack.m_41777_(), this.texture);
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TFCRecipeSerializers.POT_JAM.get();
    }

    public record JamOutput(ItemStack stack, ResourceLocation texture) implements PotRecipe.Output
    {
        @Override
        public boolean isEmpty() {
            return this.stack.m_41619_();
        }

        @Override
        public InteractionResult onInteract(PotBlockEntity entity, Player player, ItemStack clickedWith) {
            if (Helpers.isItem(clickedWith, TFCTags.Items.EMPTY_JAR_WITH_LID) && !this.stack.m_41619_()) {
                clickedWith.m_41774_(1);
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)this.stack.m_41620_(1));
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }

        @Override
        public ResourceLocation getRenderTexture() {
            return this.texture;
        }

        @Override
        public float getFluidYLevel() {
            return Mth.m_184631_((float)this.stack.m_41613_(), (float)0.0f, (float)4.0f, (float)0.4375f, (float)0.625f);
        }

        @Override
        public void write(CompoundTag nbt) {
            nbt.m_128365_("item", (Tag)this.stack.m_41739_(new CompoundTag()));
            nbt.m_128359_("texture", this.texture.toString());
        }

        @Override
        public PotRecipe.OutputType getType() {
            return OUTPUT_TYPE;
        }

        @Override
        public BlockEntityTooltip getTooltip() {
            return (level, state, pos, entity, tooltip) -> {
                ArrayList<Component> text = new ArrayList<Component>();
                BlockEntityTooltips.itemWithCount(tooltip, this.stack);
                FoodCapability.addTooltipInfo(this.stack, text);
                text.forEach(tooltip);
            };
        }
    }

    public static class Serializer
    extends PotRecipe.Serializer<JamPotRecipe> {
        @Override
        protected JamPotRecipe fromJson(ResourceLocation recipeId, JsonObject json, List<Ingredient> ingredients, FluidStackIngredient fluidIngredient, int duration, float minTemp) {
            return new JamPotRecipe(recipeId, ingredients, fluidIngredient, duration, minTemp, JsonHelpers.getItemStack(json, "result"), JsonHelpers.getResourceLocation(json, "texture"));
        }

        @Override
        protected JamPotRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer, List<Ingredient> ingredients, FluidStackIngredient fluidIngredient, int duration, float minTemp) {
            ItemStack stack = buffer.m_130267_();
            ResourceLocation texture = buffer.m_130281_();
            return new JamPotRecipe(recipeId, ingredients, fluidIngredient, duration, minTemp, stack, texture);
        }

        @Override
        public void toNetwork(FriendlyByteBuf buffer, JamPotRecipe recipe) {
            super.toNetwork(buffer, recipe);
            buffer.m_130055_(recipe.jarredStack);
            buffer.m_130085_(recipe.texture);
        }
    }
}

