/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.function.BiFunction;
import net.dries007.tfc.common.recipes.IRecipeDelegate;
import net.dries007.tfc.common.recipes.RecipeSerializerImpl;
import net.dries007.tfc.util.Helpers;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundUpdateRecipesPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.common.crafting.conditions.ICondition;
import org.jetbrains.annotations.Nullable;

public abstract class DelegateRecipe<R extends Recipe<C>, C extends Container>
implements IRecipeDelegate<C> {
    public static final ResourceLocation DELEGATE = Helpers.identifier("delegate");
    private final ResourceLocation id;
    private final R recipe;

    protected DelegateRecipe(ResourceLocation id, R recipe) {
        this.id = id;
        this.recipe = recipe;
    }

    public R getDelegate() {
        return this.recipe;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public static class Serializer<C extends Container>
    extends RecipeSerializerImpl<DelegateRecipe<?, C>> {
        private final BiFunction<ResourceLocation, Recipe<C>, DelegateRecipe<?, C>> factory;

        public static <C extends Container> Serializer<C> shapeless(BiFunction<ResourceLocation, Recipe<C>, DelegateRecipe<Recipe<C>, C>> factory) {
            return new Serializer<C>((id, delegate) -> {
                if (delegate instanceof IShapedRecipe) {
                    throw new JsonParseException("Mixing shapeless delegate recipe type with shaped delegate, not allowed!");
                }
                return (DelegateRecipe)factory.apply((ResourceLocation)id, (Recipe)delegate);
            });
        }

        public static <C extends Container> Serializer<C> shaped(BiFunction<ResourceLocation, IShapedRecipe<C>, DelegateRecipe<IShapedRecipe<C>, C>> factory) {
            return new Serializer<C>((id, delegate) -> {
                if (!(delegate instanceof IShapedRecipe)) {
                    throw new JsonParseException("Mixing shaped delegate recipe type with shapeless delegate, not allowed!");
                }
                return (DelegateRecipe)factory.apply((ResourceLocation)id, (IShapedRecipe)((IShapedRecipe)delegate));
            });
        }

        protected Serializer(BiFunction<ResourceLocation, Recipe<C>, DelegateRecipe<?, C>> factory) {
            this.factory = factory;
        }

        public DelegateRecipe<?, C> fromJson(ResourceLocation recipeId, JsonObject json, ICondition.IContext context) {
            Recipe internal = RecipeManager.fromJson((ResourceLocation)DELEGATE, (JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"recipe"), (ICondition.IContext)context);
            return this.factory.apply(recipeId, internal);
        }

        public DelegateRecipe<?, C> fromJson(ResourceLocation recipeId, JsonObject json) {
            return this.fromJson(recipeId, json, ICondition.IContext.EMPTY);
        }

        @Nullable
        public DelegateRecipe<?, C> fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            Recipe internal = ClientboundUpdateRecipesPacket.m_133647_((FriendlyByteBuf)buffer);
            return this.factory.apply(recipeId, internal);
        }

        public void toNetwork(FriendlyByteBuf buffer, DelegateRecipe<?, C> recipe) {
            ClientboundUpdateRecipesPacket.m_179469_((FriendlyByteBuf)buffer, recipe.getDelegate());
        }
    }
}

