/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import net.dries007.tfc.common.recipes.DelegateRecipe;
import net.dries007.tfc.common.recipes.IRecipeDelegate;
import net.dries007.tfc.common.recipes.TFCRecipeSerializers;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.common.crafting.IShapedRecipe;

public abstract class DamageInputsCraftingRecipe<R extends Recipe<CraftingContainer>>
extends DelegateRecipe<R, CraftingContainer>
implements CraftingRecipe {
    protected static boolean isUnbreakable(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128471_("Unbreakable");
    }

    protected DamageInputsCraftingRecipe(ResourceLocation id, R recipe) {
        super(id, recipe);
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList items = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < items.size(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41763_()) {
                items.set(i, (Object)Helpers.damageCraftingItem(stack, 1).m_41777_());
                continue;
            }
            if (DamageInputsCraftingRecipe.isUnbreakable(stack)) {
                items.set(i, (Object)stack.m_41777_());
                continue;
            }
            if (!stack.hasCraftingRemainingItem()) continue;
            items.set(i, (Object)stack.getCraftingRemainingItem());
        }
        return items;
    }

    public CraftingBookCategory m_245232_() {
        return CraftingBookCategory.MISC;
    }

    public static class Shaped
    extends DamageInputsCraftingRecipe<IShapedRecipe<CraftingContainer>>
    implements IRecipeDelegate.Shaped<CraftingContainer> {
        public Shaped(ResourceLocation id, IShapedRecipe<CraftingContainer> recipe) {
            super(id, recipe);
        }

        public RecipeSerializer<?> m_7707_() {
            return (RecipeSerializer)TFCRecipeSerializers.DAMAGE_INPUT_SHAPED_CRAFTING.get();
        }
    }

    public static class Shapeless
    extends DamageInputsCraftingRecipe<Recipe<CraftingContainer>> {
        public Shapeless(ResourceLocation id, Recipe<CraftingContainer> recipe) {
            super(id, recipe);
        }

        public RecipeSerializer<?> m_7707_() {
            return (RecipeSerializer)TFCRecipeSerializers.DAMAGE_INPUTS_SHAPELESS_CRAFTING.get();
        }
    }
}

