/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import net.dries007.tfc.common.capabilities.MoldLike;
import net.dries007.tfc.common.recipes.CastingRecipe;
import net.dries007.tfc.common.recipes.ISimpleRecipe;
import net.dries007.tfc.common.recipes.TFCRecipeSerializers;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class CastingCraftingRecipe
extends CustomRecipe
implements ISimpleRecipe<CraftingContainer> {
    public CastingCraftingRecipe(ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
    }

    public boolean matches(CraftingContainer inventory, @Nullable Level level) {
        MoldLike mold = this.getMold(inventory);
        return mold != null && !mold.isMolten() && CastingRecipe.get(mold) != null;
    }

    public ItemStack assemble(CraftingContainer inventory, RegistryAccess access) {
        CastingRecipe recipe;
        MoldLike mold = this.getMold(inventory);
        if (mold != null && (recipe = CastingRecipe.get(mold)) != null) {
            return recipe.assemble(mold, null);
        }
        return ItemStack.f_41583_;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList items = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < inv.m_6643_(); ++i) {
            Player player;
            CastingRecipe recipe;
            ItemStack item = inv.m_8020_(i);
            MoldLike mold = MoldLike.get(item);
            if (item.m_41619_() || mold == null || (recipe = CastingRecipe.get(mold)) == null || (player = ForgeHooks.getCraftingPlayer()) == null || !(player.m_217043_().m_188501_() > recipe.getBreakChance())) continue;
            mold.drainIgnoringTemperature(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE);
            items.set(i, (Object)item.m_41777_());
        }
        return items;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TFCRecipeSerializers.CASTING_CRAFTING.get();
    }

    @Nullable
    private MoldLike getMold(CraftingContainer inventory) {
        MoldLike mold = null;
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (mold == null) {
                mold = MoldLike.get(stack);
                if (mold != null) continue;
                return null;
            }
            return null;
        }
        return mold;
    }
}

