/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Arrays;
import java.util.List;
import net.dries007.tfc.common.capabilities.forge.ForgeRule;
import net.dries007.tfc.common.capabilities.forge.Forging;
import net.dries007.tfc.common.capabilities.forge.ForgingCapability;
import net.dries007.tfc.common.recipes.ISimpleRecipe;
import net.dries007.tfc.common.recipes.RecipeSerializerImpl;
import net.dries007.tfc.common.recipes.TFCRecipeSerializers;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.dries007.tfc.common.recipes.inventory.EmptyInventory;
import net.dries007.tfc.common.recipes.outputs.ItemStackProvider;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.JsonHelpers;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import org.jetbrains.annotations.Nullable;

public class AnvilRecipe
implements ISimpleRecipe<Inventory> {
    private final ResourceLocation id;
    private final Ingredient input;
    private final int minTier;
    private final ForgeRule[] rules;
    private final boolean applyForgingBonus;
    private final ItemStackProvider output;

    public static boolean hasAny(Level level, Inventory inventory) {
        return AnvilRecipe.hasAny(level, inventory.getItem(), inventory.getTier());
    }

    public static boolean hasAny(Level level, ItemStack stack, int tier) {
        return Helpers.getRecipes(level, TFCRecipeTypes.ANVIL).values().stream().anyMatch(r -> r.input.test(stack) && tier >= r.minTier);
    }

    public static List<AnvilRecipe> getAll(Level level, Inventory inventory) {
        return AnvilRecipe.getAll(level, inventory.getItem(), inventory.getTier());
    }

    public static List<AnvilRecipe> getAll(Level level, ItemStack stack, int tier) {
        return Helpers.getRecipes(level, TFCRecipeTypes.ANVIL).values().stream().filter(r -> r.input.test(stack) && tier >= r.minTier).toList();
    }

    public AnvilRecipe(ResourceLocation id, Ingredient input, int minTier, ForgeRule[] rules, boolean applyForgingBonus, ItemStackProvider output) {
        this.id = id;
        this.input = input;
        this.minTier = minTier;
        this.rules = rules;
        this.applyForgingBonus = applyForgingBonus;
        this.output = output;
    }

    public boolean matches(Inventory inventory, @Nullable Level level) {
        return this.input.test(inventory.getItem()) && this.isCorrectTier(inventory.getTier());
    }

    public boolean checkComplete(Inventory inventory) {
        Forging forging = ForgingCapability.get(inventory.getItem());
        return forging != null && forging.matches(this.rules) && this.isWorkMatched(forging.getWork(), this.computeTarget(inventory));
    }

    public ForgeRule[] getRules() {
        return this.rules;
    }

    public boolean shouldApplyForgingBonus() {
        return this.applyForgingBonus;
    }

    public boolean isCorrectTier(int anvilTier) {
        return anvilTier >= this.minTier;
    }

    public int getMinTier() {
        return this.minTier;
    }

    public ItemStack assemble(Inventory inventory, RegistryAccess registryAccess) {
        return this.output.getStack(inventory.getItem());
    }

    public ItemStack m_8043_(@Nullable RegistryAccess access) {
        return this.output.getEmptyStack();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TFCRecipeSerializers.ANVIL.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)TFCRecipeTypes.ANVIL.get();
    }

    public Ingredient getInput() {
        return this.input;
    }

    public int computeTarget(Inventory inventory) {
        return 40 + new XoroshiroRandomSource(inventory.getSeed()).m_188582_().m_224540_(this.id).m_188503_(74);
    }

    private boolean isWorkMatched(int work, int target) {
        int leeway = (Integer)TFCConfig.SERVER.anvilAcceptableWorkRange.get();
        return work >= target - leeway && work <= target + leeway;
    }

    public static interface Inventory
    extends EmptyInventory {
        public ItemStack getItem();

        public int getTier();

        public long getSeed();
    }

    public static class Serializer
    extends RecipeSerializerImpl<AnvilRecipe> {
        public AnvilRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)json.get("input"));
            int tier = JsonHelpers.m_13824_((JsonObject)json, (String)"tier", (int)-1);
            JsonArray rulesJson = JsonHelpers.m_13933_((JsonObject)json, (String)"rules");
            ForgeRule[] rules = new ForgeRule[rulesJson.size()];
            for (int i = 0; i < rules.length; ++i) {
                rules[i] = JsonHelpers.getEnum(rulesJson.get(i), ForgeRule.class);
            }
            if (!ForgeRule.isConsistent(rules)) {
                throw new JsonParseException("The rules " + Arrays.toString((Object[])rules) + " cannot be satisfied by any combination of steps!");
            }
            boolean applyForgingBonus = JsonHelpers.m_13855_((JsonObject)json, (String)"apply_forging_bonus", (boolean)false);
            ItemStackProvider output = ItemStackProvider.fromJson(JsonHelpers.m_13930_((JsonObject)json, (String)"result"));
            return new AnvilRecipe(recipeId, ingredient, tier, rules, applyForgingBonus, output);
        }

        @Nullable
        public AnvilRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int tier = buffer.m_130242_();
            ForgeRule[] rules = Helpers.decodeArray(buffer, ForgeRule[]::new, ForgeRule::fromNetwork);
            boolean applyForgingBonus = buffer.readBoolean();
            ItemStackProvider output = ItemStackProvider.fromNetwork(buffer);
            return new AnvilRecipe(recipeId, input, tier, rules, applyForgingBonus, output);
        }

        public void toNetwork(FriendlyByteBuf buffer, AnvilRecipe recipe) {
            recipe.input.m_43923_(buffer);
            buffer.m_130130_(recipe.minTier);
            Helpers.encodeArray(buffer, recipe.rules, ForgeRule::toNetwork);
            buffer.writeBoolean(recipe.applyForgingBonus);
            recipe.output.toNetwork(buffer);
        }
    }
}

