/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.items;

import java.util.List;
import java.util.Optional;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.capabilities.DelegateHeatHandler;
import net.dries007.tfc.common.capabilities.DelegateItemHandler;
import net.dries007.tfc.common.capabilities.InventoryItemHandler;
import net.dries007.tfc.common.capabilities.SimpleFluidHandler;
import net.dries007.tfc.common.capabilities.VesselLike;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.food.FoodTraits;
import net.dries007.tfc.common.capabilities.heat.HeatCapability;
import net.dries007.tfc.common.capabilities.heat.HeatHandler;
import net.dries007.tfc.common.capabilities.heat.IHeat;
import net.dries007.tfc.common.capabilities.size.ItemSizeManager;
import net.dries007.tfc.common.capabilities.size.Size;
import net.dries007.tfc.common.container.TFCContainerProviders;
import net.dries007.tfc.common.recipes.HeatingRecipe;
import net.dries007.tfc.common.recipes.inventory.ItemStackInventory;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Alloy;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.Metal;
import net.dries007.tfc.util.Tooltips;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VesselItem
extends Item {
    public static final int SLOTS = 4;

    @Nullable
    public static VesselLike getInventoryVessel(ItemStack stack) {
        VesselLike vessel = VesselLike.get(stack);
        return vessel != null && vessel.mode() == VesselLike.Mode.INVENTORY && vessel.getTemperature() == 0.0f ? vessel : null;
    }

    public VesselItem(Item.Properties properties) {
        super(properties);
    }

    public boolean m_142207_(ItemStack stack, Slot slot, ClickAction action, Player player) {
        VesselLike vessel = VesselItem.getInventoryVessel(stack);
        if (vessel != null && ((Boolean)TFCConfig.SERVER.enableSmallVesselInventoryInteraction.get()).booleanValue() && !player.m_7500_() && action == ClickAction.SECONDARY) {
            for (int i = 3; i >= 0; --i) {
                ItemStack extracted;
                ItemStack leftover;
                ItemStack simulate = vessel.extractItem(i, 64, true);
                if (simulate.m_41619_() || (leftover = slot.m_150659_(extracted = vessel.extractItem(i, 64, false))).m_41619_()) continue;
                vessel.insertItem(i, leftover, false);
                player.f_36096_.m_6199_(slot.f_40218_);
                return true;
            }
        }
        return false;
    }

    public boolean m_142305_(ItemStack stack, ItemStack carried, Slot slot, ClickAction action, Player player, SlotAccess carriedSlot) {
        VesselLike vessel = VesselItem.getInventoryVessel(stack);
        if (vessel != null && ((Boolean)TFCConfig.SERVER.enableSmallVesselInventoryInteraction.get()).booleanValue() && !player.m_7500_() && action == ClickAction.SECONDARY && slot.m_150651_(player)) {
            if (!carried.m_41619_()) {
                boolean slotsChanged = false;
                ItemStack oldCarried = carried.m_41777_();
                for (int i = 0; i < 4; ++i) {
                    ItemStack leftover = vessel.insertItem(i, carried, false);
                    if (leftover.m_41613_() != oldCarried.m_41613_() || slotsChanged) {
                        slotsChanged = true;
                        carriedSlot.m_142104_(leftover);
                        carried = leftover;
                    }
                    if (carried.m_41619_()) break;
                }
                if (slotsChanged) {
                    player.f_36096_.m_6199_(slot.f_40218_);
                    return true;
                }
            } else {
                for (int i = 3; i >= 0; --i) {
                    ItemStack current = vessel.getStackInSlot(i);
                    if (current.m_41619_()) continue;
                    carriedSlot.m_142104_(vessel.extractItem(i, 64, false));
                    player.f_36096_.m_6199_(slot.f_40218_);
                    return true;
                }
            }
        }
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!player.m_6144_() && !level.m_5776_() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            VesselLike vessel = VesselLike.get(stack);
            if (vessel != null) {
                if (vessel.mode() == VesselLike.Mode.INVENTORY) {
                    if (vessel.getTemperature() > 0.0f) {
                        player.m_5661_((Component)Component.m_237115_((String)"tfc.tooltip.small_vessel.inventory_too_hot"), true);
                    } else {
                        TFCContainerProviders.SMALL_VESSEL.openScreen(serverPlayer, hand);
                    }
                } else if (vessel.mode() == VesselLike.Mode.MOLTEN_ALLOY) {
                    TFCContainerProviders.MOLD_LIKE_ALLOY.openScreen(serverPlayer, hand);
                } else {
                    player.m_5661_((Component)Component.m_237115_((String)"tfc.tooltip.small_vessel.alloy_solid"), true);
                }
            }
        }
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.m_5776_());
    }

    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        VesselLike vessel;
        if (((Boolean)TFCConfig.CLIENT.displayItemContentsAsImages.get()).booleanValue() && (vessel = VesselLike.get(stack)) != null && vessel.mode() == VesselLike.Mode.INVENTORY) {
            return Helpers.getTooltipImage((IItemHandler)vessel, 2, 2, 0, 3);
        }
        return super.m_142422_(stack);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new VesselCapability(stack);
    }

    public int getMaxStackSize(ItemStack stack) {
        return 1;
    }

    static class VesselCapability
    implements VesselLike,
    ICapabilityProvider,
    INBTSerializable<CompoundTag>,
    DelegateItemHandler,
    DelegateHeatHandler,
    SimpleFluidHandler {
        private final ItemStack stack;
        private final LazyOptional<VesselCapability> capability;
        private final ItemStackHandler inventory;
        private final Alloy alloy;
        private final HeatHandler heat;
        private final int capacity;
        private final HeatingRecipe[] cachedRecipes;
        private boolean initialized = false;

        VesselCapability(ItemStack stack) {
            this.stack = stack;
            this.capability = LazyOptional.of(() -> this);
            this.inventory = new InventoryItemHandler(this, 4);
            this.capacity = (Integer)Helpers.getValueOrDefault(TFCConfig.SERVER.smallVesselCapacity);
            this.alloy = new Alloy(this.capacity);
            this.heat = new HeatHandler(1.0f, 0.0f, 0.0f){

                @Override
                public void setTemperature(float temperature) {
                    super.setTemperature(temperature);
                    this.updateInventoryMelting();
                }
            };
            this.cachedRecipes = new HeatingRecipe[4];
        }

        @Override
        public IHeat getHeatHandler() {
            return this.heat;
        }

        @Override
        public int getSlotStackLimit(int slot) {
            return 16;
        }

        @Override
        public void setAndUpdateSlots(int slot) {
            ItemStack stack = this.inventory.getStackInSlot(slot);
            this.cachedRecipes[slot] = stack.m_41619_() ? null : HeatingRecipe.getRecipe(stack);
            this.updateAndSave();
        }

        @Override
        public void onSlotTake(Player player, int slot, ItemStack stack) {
            FoodCapability.removeTrait(stack, FoodTraits.PRESERVED);
        }

        @Override
        public void onCarried(ItemStack stack) {
            FoodCapability.removeTrait(stack, FoodTraits.PRESERVED);
        }

        @Override
        public VesselLike.Mode mode() {
            if (this.alloy.isEmpty()) {
                return VesselLike.Mode.INVENTORY;
            }
            Metal result = this.alloy.getResult();
            return this.getTemperature() >= result.getMeltTemperature() ? VesselLike.Mode.MOLTEN_ALLOY : VesselLike.Mode.SOLID_ALLOY;
        }

        @Override
        public boolean isItemValid(int slot, ItemStack stack) {
            return ItemSizeManager.get(stack).getSize(stack).isEqualOrSmallerThan((Size)((Object)TFCConfig.SERVER.smallVesselMaximumItemSize.get()));
        }

        @Override
        public void addTooltipInfo(ItemStack stack, List<Component> text) {
            this.heat.addTooltipInfo(stack, text);
            if (!Helpers.isEmpty((IItemHandler)this.inventory) || !this.alloy.isEmpty()) {
                VesselLike.Mode mode = this.mode();
                switch (mode) {
                    case INVENTORY: {
                        if (((Boolean)TFCConfig.CLIENT.displayItemContentsAsImages.get()).booleanValue()) break;
                        text.add((Component)Component.m_237115_((String)"tfc.tooltip.small_vessel.contents").m_130940_(ChatFormatting.DARK_GREEN));
                        Helpers.addInventoryTooltipInfo((IItemHandler)this.inventory, text);
                        break;
                    }
                    case MOLTEN_ALLOY: 
                    case SOLID_ALLOY: {
                        text.add((Component)Component.m_237115_((String)"tfc.tooltip.small_vessel.contents").m_130940_(ChatFormatting.DARK_GREEN));
                        text.add((Component)Tooltips.fluidUnitsAndCapacityOf((Component)this.alloy.getResult().getDisplayName(), this.alloy.getAmount(), this.capacity).m_7220_((Component)Tooltips.moltenOrSolid(this.isMolten())));
                        if (Helpers.isEmpty((IItemHandler)this.inventory)) break;
                        text.add((Component)Component.m_237115_((String)"tfc.tooltip.small_vessel.still_has_unmelted_items").m_130940_(ChatFormatting.RED));
                    }
                }
            }
        }

        @NotNull
        public ItemStack getContainer() {
            return this.stack;
        }

        @Override
        public IItemHandlerModifiable getItemHandler() {
            return this.inventory;
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            if (cap == HeatCapability.NETWORK_CAPABILITY) {
                return this.capability.cast();
            }
            if (cap == HeatCapability.CAPABILITY || cap == Capabilities.ITEM || cap == Capabilities.FLUID || cap == Capabilities.FLUID_ITEM) {
                this.load();
                return this.capability.cast();
            }
            return LazyOptional.empty();
        }

        @NotNull
        public FluidStack getFluidInTank(int tank) {
            return this.alloy.getResultAsFluidStack();
        }

        public int getTankCapacity(int tank) {
            return this.alloy.getMaxUnits();
        }

        public boolean isFluidValid(int tank, FluidStack stack) {
            return Metal.get(stack.getFluid()) != null;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            Metal metal = Metal.get(resource.getFluid());
            if (metal != null) {
                int result = this.alloy.add(metal, resource.getAmount(), action.simulate());
                if (action.execute()) {
                    this.updateAndSave();
                }
                return result;
            }
            return 0;
        }

        @NotNull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return this.mode() == VesselLike.Mode.MOLTEN_ALLOY ? this.drainIgnoringTemperature(maxDrain, action) : FluidStack.EMPTY;
        }

        @Override
        public FluidStack drainIgnoringTemperature(int maxDrain, IFluidHandler.FluidAction action) {
            VesselLike.Mode mode = this.mode();
            if (mode == VesselLike.Mode.MOLTEN_ALLOY || mode == VesselLike.Mode.SOLID_ALLOY) {
                Metal result = this.alloy.getResult();
                int amount = this.alloy.removeAlloy(maxDrain, action.simulate());
                if (action.execute()) {
                    this.updateAndSave();
                }
                return new FluidStack(result.getFluid(), amount);
            }
            return FluidStack.EMPTY;
        }

        @Override
        public void setStackInSlot(int slot, ItemStack stack) {
            FoodCapability.applyTrait(stack, FoodTraits.PRESERVED);
            this.inventory.setStackInSlot(slot, stack);
        }

        @Override
        @NotNull
        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            ItemStack input = stack.m_41777_();
            FoodCapability.applyTrait(input, FoodTraits.PRESERVED);
            ItemStack result = this.inventory.insertItem(slot, input, simulate);
            FoodCapability.removeTrait(result, FoodTraits.PRESERVED);
            return result;
        }

        @Override
        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemStack result = this.inventory.extractItem(slot, amount, simulate);
            FoodCapability.removeTrait(result, FoodTraits.PRESERVED);
            return result;
        }

        @Override
        public CompoundTag serializeNBT() {
            return this.heat.serializeNBT();
        }

        @Override
        public void deserializeNBT(CompoundTag nbt) {
            this.heat.deserializeNBT(nbt);
        }

        private void updateInventoryMelting() {
            boolean updatedAlloy = false;
            ItemStackInventory inventory = new ItemStackInventory();
            for (int i = 0; i < 4; ++i) {
                HeatingRecipe recipe;
                ItemStack stack = this.inventory.getStackInSlot(i);
                inventory.setStack(stack);
                if (this.cachedRecipes[i] == null || !(recipe = this.cachedRecipes[i]).isValidTemperature(this.heat.getTemperature())) continue;
                ItemStack outputStack = recipe.assembleStacked(inventory, this.getSlotStackLimit(i), recipe.getChance());
                FluidStack outputFluid = recipe.assembleFluid(inventory);
                if (!outputFluid.isEmpty()) {
                    outputFluid.setAmount(outputFluid.getAmount() * stack.m_41613_());
                }
                this.inventory.setStackInSlot(i, outputStack);
                Metal metal = Metal.get(outputFluid.getFluid());
                if (metal == null) continue;
                this.alloy.add(metal, outputFluid.getAmount(), false);
                updatedAlloy = true;
            }
            if (updatedAlloy) {
                this.updateAndSave();
            }
        }

        private void load() {
            if (this.initialized) {
                return;
            }
            this.initialized = true;
            CompoundTag tag = this.stack.m_41784_();
            this.inventory.deserializeNBT(tag.m_128469_("inventory"));
            this.alloy.deserializeNBT(tag.m_128469_("alloy"));
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                ItemStack stack = this.inventory.getStackInSlot(i);
                this.cachedRecipes[i] = stack.m_41619_() ? null : HeatingRecipe.getRecipe(stack);
            }
            this.updateHeatCapacity();
        }

        private void updateHeatCapacity() {
            float value = 1.2f;
            float valueFromItems = 0.0f;
            int count = 0;
            for (ItemStack stack : Helpers.iterate((IItemHandler)this.inventory)) {
                @Nullable IHeat heat = HeatCapability.get(stack);
                if (heat == null) continue;
                count += stack.m_41613_();
                valueFromItems += heat.getHeatCapacity() * (float)stack.m_41613_();
            }
            if (count > 0) {
                value += valueFromItems * 0.7f + valueFromItems / (float)count * 0.3f;
            }
            if (!this.alloy.isEmpty()) {
                value += this.alloy.getHeatCapacity(0.7f);
            }
            this.heat.setHeatCapacity(value);
        }

        private void updateAndSave() {
            this.updateHeatCapacity();
            CompoundTag tag = this.stack.m_41784_();
            tag.m_128365_("inventory", (Tag)this.inventory.serializeNBT());
            tag.m_128365_("alloy", (Tag)this.alloy.serializeNBT());
        }
    }
}

