/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.items;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.events.StartFireEvent;
import net.dries007.tfc.util.loot.TFCLoot;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class TorchItem
extends StandingAndWallBlockItem {
    public TorchItem(Block floorBlock, Block wallBlockIn, Item.Properties propertiesIn) {
        super(floorBlock, wallBlockIn, propertiesIn, Direction.DOWN);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos pos;
        Level level = context.m_43725_();
        if (StartFireEvent.startFire(level, pos = context.m_8083_(), level.m_8055_(pos), context.m_43719_(), context.m_43723_(), context.m_43722_(), StartFireEvent.FireStrength.WEAK)) {
            return InteractionResult.SUCCESS;
        }
        return super.m_6225_(context);
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity itemEntity) {
        int ageRequirement;
        BlockPos pos;
        Level level = itemEntity.m_9236_();
        BlockState stateAt = level.m_8055_(pos = itemEntity.m_20183_());
        if (FluidHelpers.canFluidExtinguishFire(stateAt.m_60819_().m_76152_())) {
            int amount;
            int n = amount = stack.m_41613_() > 5 ? 1 + level.f_46441_.m_188503_(5) : stack.m_41613_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (int i = 0; i < amount; ++i) {
                    Helpers.dropWithContext(serverLevel, ((Block)TFCBlocks.TORCH.get()).m_49966_(), pos, builder -> builder.m_287286_(TFCLoot.BURNT_OUT, (Object)true), true);
                }
            }
            Helpers.playSound(level, pos, SoundEvents.f_11937_);
            stack.m_41774_(amount);
            if (stack.m_41619_()) {
                itemEntity.m_146870_();
                return true;
            }
            return false;
        }
        BlockPos downPos = itemEntity.m_20183_().m_7495_();
        boolean isNotInBlock = level.m_46859_(pos);
        BlockState checkState = isNotInBlock ? level.m_8055_(downPos) : stateAt;
        int n = ageRequirement = isNotInBlock ? 20 : 160;
        if (Helpers.isBlock(checkState, TFCTags.Blocks.LIT_BY_DROPPED_TORCH)) {
            if (itemEntity.m_32059_() > ageRequirement && level.f_46441_.m_188501_() < 0.01f && !level.m_5776_()) {
                StartFireEvent.startFire(level, isNotInBlock ? downPos : pos, checkState, Direction.UP, null, ItemStack.f_41583_, StartFireEvent.FireStrength.STRONG);
                itemEntity.m_6074_();
                return true;
            }
            RandomSource rand = level.m_213780_();
            if (rand.m_188500_() <= 0.1) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123756_, itemEntity.m_20185_(), itemEntity.m_20186_(), itemEntity.m_20189_(), -0.5 + rand.m_188500_(), -0.5 + rand.m_188500_(), -0.5 + rand.m_188500_());
            }
        }
        return false;
    }
}

