/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.items;

import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.TFCTiers;
import net.dries007.tfc.common.blocks.Gem;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.crop.Crop;
import net.dries007.tfc.common.blocks.plant.coral.Coral;
import net.dries007.tfc.common.blocks.rock.Ore;
import net.dries007.tfc.common.blocks.rock.Rock;
import net.dries007.tfc.common.blocks.rock.RockCategory;
import net.dries007.tfc.common.blocks.wood.Wood;
import net.dries007.tfc.common.capabilities.food.Nutrient;
import net.dries007.tfc.common.capabilities.glass.GlassOperation;
import net.dries007.tfc.common.entities.TFCEntities;
import net.dries007.tfc.common.entities.aquatic.Fish;
import net.dries007.tfc.common.fluids.FluidId;
import net.dries007.tfc.common.fluids.TFCFluids;
import net.dries007.tfc.common.items.BlowpipeItem;
import net.dries007.tfc.common.items.EmptyPanItem;
import net.dries007.tfc.common.items.FirestarterItem;
import net.dries007.tfc.common.items.FluidContainerItem;
import net.dries007.tfc.common.items.Food;
import net.dries007.tfc.common.items.GemSawItem;
import net.dries007.tfc.common.items.GlassBlowpipeItem;
import net.dries007.tfc.common.items.GlassBottleItem;
import net.dries007.tfc.common.items.GlassworkingItem;
import net.dries007.tfc.common.items.GlowArrowItem;
import net.dries007.tfc.common.items.HideItemType;
import net.dries007.tfc.common.items.JarItem;
import net.dries007.tfc.common.items.JugItem;
import net.dries007.tfc.common.items.MoldItem;
import net.dries007.tfc.common.items.PanItem;
import net.dries007.tfc.common.items.Powder;
import net.dries007.tfc.common.items.RottenCompostItem;
import net.dries007.tfc.common.items.TFCBoatItem;
import net.dries007.tfc.common.items.TFCMinecartItem;
import net.dries007.tfc.common.items.TorchItem;
import net.dries007.tfc.common.items.VesselItem;
import net.dries007.tfc.common.items.WindmillBladeItem;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.mixin.accessor.ItemAccessor;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.Metal;
import net.dries007.tfc.util.registry.RegistryMetal;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.HangingSignItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public final class TFCItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((ResourceKey)Registries.f_256913_, (String)"tfc");
    public static final Map<Ore, RegistryObject<Item>> ORES = Helpers.mapOfKeys(Ore.class, ore -> !ore.isGraded(), type -> TFCItems.register("ore/" + type.name()));
    public static final Map<Ore, Map<Ore.Grade, RegistryObject<Item>>> GRADED_ORES = Helpers.mapOfKeys(Ore.class, Ore::isGraded, ore -> Helpers.mapOfKeys(Ore.Grade.class, grade -> TFCItems.register("ore/" + grade.name() + "_" + ore.name())));
    public static final Map<Gem, RegistryObject<Item>> GEMS = Helpers.mapOfKeys(Gem.class, gem -> TFCItems.register("gem/" + gem.name()));
    public static final Map<RockCategory, Map<RockCategory.ItemType, RegistryObject<Item>>> ROCK_TOOLS = Helpers.mapOfKeys(RockCategory.class, category -> Helpers.mapOfKeys(RockCategory.ItemType.class, type -> TFCItems.register("stone/" + type.name() + "/" + category.name(), () -> type.create((RockCategory)((Object)category)))));
    public static final Map<Rock, RegistryObject<Item>> BRICKS = Helpers.mapOfKeys(Rock.class, type -> TFCItems.register("brick/" + type.name()));
    public static final Map<Metal.Default, Map<Metal.ItemType, RegistryObject<Item>>> METAL_ITEMS = Helpers.mapOfKeys(Metal.Default.class, metal -> Helpers.mapOfKeys(Metal.ItemType.class, type -> type.has((Metal.Default)metal), type -> TFCItems.register("metal/" + type.name() + "/" + metal.name(), () -> type.create((RegistryMetal)metal))));
    public static final Map<Wood, RegistryObject<Item>> LUMBER = Helpers.mapOfKeys(Wood.class, wood -> TFCItems.register("wood/lumber/" + wood.name()));
    public static final Map<Wood, RegistryObject<Item>> SUPPORTS = Helpers.mapOfKeys(Wood.class, wood -> TFCItems.register("wood/support/" + wood.name(), () -> new StandingAndWallBlockItem((Block)TFCBlocks.WOODS.get(wood).get((Object)Wood.BlockType.VERTICAL_SUPPORT).get(), (Block)TFCBlocks.WOODS.get(wood).get((Object)Wood.BlockType.HORIZONTAL_SUPPORT).get(), new Item.Properties(), Direction.DOWN)));
    public static final Map<Wood, RegistryObject<Item>> BOATS = Helpers.mapOfKeys(Wood.class, wood -> TFCItems.register("wood/boat/" + wood.name(), () -> new TFCBoatItem((Supplier)TFCEntities.BOATS.get(wood), new Item.Properties())));
    public static final Map<Wood, RegistryObject<Item>> CHEST_MINECARTS = Helpers.mapOfKeys(Wood.class, wood -> TFCItems.register("wood/chest_minecart/" + wood.name(), () -> new TFCMinecartItem(new Item.Properties(), (Supplier<? extends EntityType<?>>)TFCEntities.CHEST_MINECART, (Supplier<? extends Item>)((Supplier<Item>)() -> ((Block)TFCBlocks.WOODS.get(wood).get((Object)Wood.BlockType.CHEST).get()).m_5456_()))));
    public static final Map<Wood, RegistryObject<Item>> SIGNS = Helpers.mapOfKeys(Wood.class, wood -> TFCItems.register("wood/sign/" + wood.name(), () -> new SignItem(new Item.Properties(), (Block)TFCBlocks.WOODS.get(wood).get((Object)Wood.BlockType.SIGN).get(), (Block)TFCBlocks.WOODS.get(wood).get((Object)Wood.BlockType.WALL_SIGN).get())));
    public static final Map<Wood, Map<Metal.Default, RegistryObject<Item>>> HANGING_SIGNS = Helpers.mapOfKeys(Wood.class, wood -> Helpers.mapOfKeys(Metal.Default.class, Metal.Default::hasUtilities, metal -> TFCItems.register("wood/hanging_sign/" + metal.name() + "/" + wood.name(), () -> new HangingSignItem((Block)TFCBlocks.CEILING_HANGING_SIGNS.get(wood).get(metal).get(), (Block)TFCBlocks.WALL_HANGING_SIGNS.get(wood).get(metal).get(), new Item.Properties()))));
    public static final Map<Food, RegistryObject<Item>> FOOD = Helpers.mapOfKeys(Food.class, food -> TFCItems.register("food/" + food.name(), () -> new Item(food.createProperties())));
    public static final Map<Food, RegistryObject<Item>> FRUIT_PRESERVES = Helpers.mapOfKeys(Food.class, Food::isFruit, food -> TFCItems.register("jar/" + food.name(), () -> new JarItem(new Item.Properties(), food.name().toLowerCase(Locale.ROOT), false)));
    public static final Map<Food, RegistryObject<Item>> UNSEALED_FRUIT_PRESERVES = Helpers.mapOfKeys(Food.class, Food::isFruit, food -> TFCItems.register("jar/" + food.name() + "_unsealed", () -> new JarItem(new Item.Properties(), food.name().toLowerCase(Locale.ROOT) + "_unsealed", true)));
    public static final Map<Nutrient, RegistryObject<Item>> SOUPS = Helpers.mapOfKeys(Nutrient.class, nutrient -> TFCItems.register("food/" + nutrient.name() + "_soup", () -> new Item(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38760_(4).m_38758_(0.3f).m_38767_()))));
    public static final Map<Nutrient, RegistryObject<Item>> SALADS = Helpers.mapOfKeys(Nutrient.class, nutrient -> TFCItems.register("food/" + nutrient.name() + "_salad", () -> new Item(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38760_(4).m_38758_(0.3f).m_38767_()))));
    public static final Map<Crop, RegistryObject<Item>> CROP_SEEDS = Helpers.mapOfKeys(Crop.class, crop -> TFCItems.register("seeds/" + crop.name(), () -> new ItemNameBlockItem((Block)TFCBlocks.CROPS.get(crop).get(), new Item.Properties())));
    public static final Map<Coral, RegistryObject<Item>> CORAL_FANS = Helpers.mapOfKeys(Coral.class, color -> TFCItems.register("coral/" + color.toString() + "_coral_fan", () -> new StandingAndWallBlockItem((Block)TFCBlocks.CORAL.get(color).get((Object)Coral.BlockType.CORAL_FAN).get(), (Block)TFCBlocks.CORAL.get(color).get((Object)Coral.BlockType.CORAL_WALL_FAN).get(), new Item.Properties(), Direction.DOWN)));
    public static final Map<Coral, RegistryObject<Item>> DEAD_CORAL_FANS = Helpers.mapOfKeys(Coral.class, color -> TFCItems.register("coral/" + color.toString() + "_dead_coral_fan", () -> new StandingAndWallBlockItem((Block)TFCBlocks.CORAL.get(color).get((Object)Coral.BlockType.DEAD_CORAL_FAN).get(), (Block)TFCBlocks.CORAL.get(color).get((Object)Coral.BlockType.DEAD_CORAL_WALL_FAN).get(), new Item.Properties(), Direction.DOWN)));
    public static final RegistryObject<Item> LOAM_MUD_BRICK = TFCItems.register("mud_brick/loam");
    public static final RegistryObject<Item> SILTY_LOAM_MUD_BRICK = TFCItems.register("mud_brick/silty_loam");
    public static final RegistryObject<Item> SANDY_LOAM_MUD_BRICK = TFCItems.register("mud_brick/sandy_loam");
    public static final RegistryObject<Item> SILT_MUD_BRICK = TFCItems.register("mud_brick/silt");
    public static final RegistryObject<Item> ALABASTER_BRICK = TFCItems.register("alabaster_brick");
    public static final RegistryObject<Item> TORCH = TFCItems.register("torch", () -> new TorchItem((Block)TFCBlocks.TORCH.get(), (Block)TFCBlocks.WALL_TORCH.get(), new Item.Properties()));
    public static final RegistryObject<Item> DEAD_TORCH = TFCItems.register("dead_torch", () -> new StandingAndWallBlockItem((Block)TFCBlocks.DEAD_TORCH.get(), (Block)TFCBlocks.DEAD_WALL_TORCH.get(), new Item.Properties(), Direction.DOWN));
    public static final Map<HideItemType, Map<HideItemType.Size, RegistryObject<Item>>> HIDES = Helpers.mapOfKeys(HideItemType.class, type -> Helpers.mapOfKeys(HideItemType.Size.class, size -> TFCItems.register(size.name() + "_" + type.name() + "_hide", () -> new Item(new Item.Properties()))));
    public static final Map<Gem, RegistryObject<Item>> GEM_DUST = Helpers.mapOfKeys(Gem.class, gem -> TFCItems.register("powder/" + gem.name()));
    public static final Map<Powder, RegistryObject<Item>> POWDERS = Helpers.mapOfKeys(Powder.class, powder -> TFCItems.register("powder/" + powder.name()));
    public static final Map<Ore, RegistryObject<Item>> ORE_POWDERS = Helpers.mapOfKeys(Ore.class, Ore::isGraded, ore -> TFCItems.register("powder/" + ore.name()));
    public static final RegistryObject<Item> CERAMIC_BLOWPIPE = TFCItems.register("ceramic_blowpipe", () -> new BlowpipeItem(new Item.Properties()));
    public static final RegistryObject<Item> BLOWPIPE = TFCItems.register("blowpipe", () -> new BlowpipeItem(new Item.Properties()));
    public static final RegistryObject<Item> CERAMIC_BLOWPIPE_WITH_GLASS = TFCItems.register("ceramic_blowpipe_with_glass", () -> new GlassBlowpipeItem(new Item.Properties(), 0.1f));
    public static final RegistryObject<Item> BLOWPIPE_WITH_GLASS = TFCItems.register("blowpipe_with_glass", () -> new GlassBlowpipeItem(new Item.Properties(), 0.0f));
    public static final RegistryObject<Item> JACKS = TFCItems.register("jacks", () -> new GlassworkingItem(new Item.Properties(), GlassOperation.PINCH));
    public static final RegistryObject<Item> PADDLE = TFCItems.register("paddle", () -> new GlassworkingItem(new Item.Properties(), GlassOperation.FLATTEN));
    public static final RegistryObject<Item> GEM_SAW = TFCItems.register("gem_saw", () -> new GemSawItem(TFCTiers.BRONZE, new Item.Properties()));
    public static final RegistryObject<Item> SILICA_GLASS_BATCH = TFCItems.register("silica_glass_batch");
    public static final RegistryObject<Item> HEMATITIC_GLASS_BATCH = TFCItems.register("hematitic_glass_batch");
    public static final RegistryObject<Item> OLIVINE_GLASS_BATCH = TFCItems.register("olivine_glass_batch");
    public static final RegistryObject<Item> VOLCANIC_GLASS_BATCH = TFCItems.register("volcanic_glass_batch");
    public static final RegistryObject<Item> LAMP_GLASS = TFCItems.register("lamp_glass");
    public static final RegistryObject<Item> LENS = TFCItems.register("lens");
    public static final RegistryObject<Item> SILICA_GLASS_BOTTLE = TFCItems.register("silica_glass_bottle", () -> new GlassBottleItem(new Item.Properties(), (Supplier<Integer>)TFCConfig.SERVER.silicaGlassBottleCapacity, (Supplier<Double>)TFCConfig.SERVER.silicaGlassBottleBreakChance, TFCTags.Fluids.USABLE_IN_JUG));
    public static final RegistryObject<Item> HEMATITIC_GLASS_BOTTLE = TFCItems.register("hematitic_glass_bottle", () -> new GlassBottleItem(new Item.Properties(), (Supplier<Integer>)TFCConfig.SERVER.hematiticGlassBottleCapacity, (Supplier<Double>)TFCConfig.SERVER.hematiticGlassBottleBreakChance, TFCTags.Fluids.USABLE_IN_JUG));
    public static final RegistryObject<Item> VOLCANIC_GLASS_BOTTLE = TFCItems.register("volcanic_glass_bottle", () -> new GlassBottleItem(new Item.Properties(), (Supplier<Integer>)TFCConfig.SERVER.volcanicGlassBottleCapacity, (Supplier<Double>)TFCConfig.SERVER.volcanicGlassBottleBreakChance, TFCTags.Fluids.USABLE_IN_JUG));
    public static final RegistryObject<Item> OLIVINE_GLASS_BOTTLE = TFCItems.register("olivine_glass_bottle", () -> new GlassBottleItem(new Item.Properties(), (Supplier<Integer>)TFCConfig.SERVER.olivineGlassBottleCapacity, (Supplier<Double>)TFCConfig.SERVER.olivineGlassBottleBreakChance, TFCTags.Fluids.USABLE_IN_JUG));
    public static final RegistryObject<Item> EMPTY_JAR = TFCItems.register("empty_jar", () -> new JarItem(new Item.Properties(), "empty", false));
    public static final RegistryObject<Item> EMPTY_JAR_WITH_LID = TFCItems.register("empty_jar_with_lid", () -> new JarItem(new Item.Properties(), Helpers.identifier("block/jar"), false));
    public static final RegistryObject<Item> JAR_LID = TFCItems.register("jar_lid", () -> new Item(new Item.Properties()));
    public static final RegistryObject<Item> BONE_NEEDLE = TFCItems.register("bone_needle", () -> new Item(new Item.Properties().m_41499_(64)));
    public static final RegistryObject<Item> BLANK_DISC = TFCItems.register("blank_disc");
    public static final RegistryObject<Item> BLUBBER = TFCItems.register("blubber");
    public static final RegistryObject<Item> BRASS_MECHANISMS = TFCItems.register("brass_mechanisms");
    public static final RegistryObject<Item> BURLAP_CLOTH = TFCItems.register("burlap_cloth");
    public static final RegistryObject<Item> COMPOST = TFCItems.register("compost");
    public static final RegistryObject<Item> DAUB = TFCItems.register("daub");
    public static final RegistryObject<Item> DIRTY_JUTE_NET = TFCItems.register("dirty_jute_net");
    public static final RegistryObject<Item> FIRE_CLAY = TFCItems.register("fire_clay");
    public static final RegistryObject<Item> FIRESTARTER = TFCItems.register("firestarter", () -> new FirestarterItem(new Item.Properties().m_41499_(8)));
    public static final RegistryObject<Item> GOAT_HORN = TFCItems.register("goat_horn");
    public static final RegistryObject<Item> GLOW_ARROW = TFCItems.register("glow_arrow", () -> new GlowArrowItem(new Item.Properties()));
    public static final RegistryObject<Item> GLUE = TFCItems.register("glue");
    public static final RegistryObject<Item> HAND_WHEEL = TFCItems.register("hand_wheel", () -> new Item(new Item.Properties().m_41499_(250)));
    public static final RegistryObject<Item> JUTE = TFCItems.register("jute");
    public static final RegistryObject<Item> JUTE_FIBER = TFCItems.register("jute_fiber");
    public static final RegistryObject<Item> JUTE_NET = TFCItems.register("jute_net");
    public static final RegistryObject<Item> KAOLIN_CLAY = TFCItems.register("kaolin_clay");
    public static final RegistryObject<Item> HANDSTONE = TFCItems.register("handstone", () -> new Item(new Item.Properties().m_41499_(250)));
    public static final RegistryObject<Item> MORTAR = TFCItems.register("mortar");
    public static final RegistryObject<Item> OLIVE_PASTE = TFCItems.register("olive_paste");
    public static final RegistryObject<Item> PAPYRUS = TFCItems.register("papyrus");
    public static final RegistryObject<Item> PAPYRUS_STRIP = TFCItems.register("papyrus_strip");
    public static final RegistryObject<Item> PURE_NITROGEN = TFCItems.register("pure_nitrogen");
    public static final RegistryObject<Item> PURE_PHOSPHORUS = TFCItems.register("pure_phosphorus");
    public static final RegistryObject<Item> PURE_POTASSIUM = TFCItems.register("pure_potassium");
    public static final RegistryObject<Item> ROTTEN_COMPOST = TFCItems.register("rotten_compost", () -> new RottenCompostItem(new Item.Properties()));
    public static final RegistryObject<Item> SILK_CLOTH = TFCItems.register("silk_cloth");
    public static final RegistryObject<Item> SANDPAPER = TFCItems.register("sandpaper", () -> new Item(new Item.Properties().m_41499_(40)));
    public static final RegistryObject<Item> SOAKED_PAPYRUS_STRIP = TFCItems.register("soaked_papyrus_strip");
    public static final RegistryObject<Item> SOOT = TFCItems.register("soot");
    public static final RegistryObject<Item> SPINDLE = TFCItems.register("spindle", () -> new Item(new Item.Properties().m_41499_(40)));
    public static final RegistryObject<Item> STICK_BUNCH = TFCItems.register("stick_bunch");
    public static final RegistryObject<Item> STICK_BUNDLE = TFCItems.register("stick_bundle");
    public static final RegistryObject<Item> STRAW = TFCItems.register("straw");
    public static final RegistryObject<Item> TREATED_HIDE = TFCItems.register("treated_hide");
    public static final RegistryObject<Item> UNREFINED_PAPER = TFCItems.register("unrefined_paper");
    public static final RegistryObject<Item> WOODEN_BUCKET = TFCItems.register("wooden_bucket", () -> new FluidContainerItem(new Item.Properties(), (Supplier<Integer>)TFCConfig.SERVER.woodenBucketCapacity, TFCTags.Fluids.USABLE_IN_WOODEN_BUCKET, true, false));
    public static final RegistryObject<Item> WOOL = TFCItems.register("wool");
    public static final RegistryObject<Item> WOOL_CLOTH = TFCItems.register("wool_cloth", () -> new GlassworkingItem(new Item.Properties(), GlassOperation.ROLL));
    public static final RegistryObject<Item> WOOL_YARN = TFCItems.register("wool_yarn");
    public static final RegistryObject<Item> WROUGHT_IRON_GRILL = TFCItems.register("wrought_iron_grill");
    public static final RegistryObject<Item> RAW_IRON_BLOOM = TFCItems.register("raw_iron_bloom");
    public static final RegistryObject<Item> REFINED_IRON_BLOOM = TFCItems.register("refined_iron_bloom");
    public static final RegistryObject<Item> EMPTY_PAN = TFCItems.register("pan/empty", () -> new EmptyPanItem(new Item.Properties()));
    public static final RegistryObject<Item> FILLED_PAN = TFCItems.register("pan/filled", () -> new PanItem(new Item.Properties().m_41487_(1)));
    public static final RegistryObject<Item> WINDMILL_BLADE = TFCItems.register("windmill_blade", () -> new WindmillBladeItem(new Item.Properties()));
    public static final Map<DyeColor, RegistryObject<Item>> COLORED_WINDMILL_BLADES = Helpers.mapOfKeys(DyeColor.class, color -> color != DyeColor.WHITE, color -> TFCItems.register(color.m_7912_() + "_windmill_blade", () -> new WindmillBladeItem(new Item.Properties())));
    public static final RegistryObject<Item> LATTICE_WINDMILL_BLADE = TFCItems.register("lattice_windmill_blade", () -> new WindmillBladeItem(new Item.Properties()));
    public static final RegistryObject<Item> RUSTIC_WINDMILL_BLADE = TFCItems.register("rustic_windmill_blade", () -> new WindmillBladeItem(new Item.Properties()));
    public static final Map<Fish, RegistryObject<Item>> FRESHWATER_FISH_EGGS = Helpers.mapOfKeys(Fish.class, fish -> TFCItems.registerSpawnEgg(TFCEntities.FRESHWATER_FISH.get(fish), fish.getEggColor1(), fish.getEggColor2()));
    public static final RegistryObject<Item> COD_EGG = TFCItems.registerSpawnEgg(TFCEntities.COD, 12691306, 15058059);
    public static final RegistryObject<Item> PUFFERFISH_EGG = TFCItems.registerSpawnEgg(TFCEntities.PUFFERFISH, 16167425, 3654642);
    public static final RegistryObject<Item> TROPICAL_FISH_EGG = TFCItems.registerSpawnEgg(TFCEntities.TROPICAL_FISH, 15690005, 0xFFF9EF);
    public static final RegistryObject<Item> JELLYFISH_EGG = TFCItems.registerSpawnEgg(TFCEntities.JELLYFISH, 15219982, 0x11F2F2);
    public static final RegistryObject<Item> LOBSTER_EGG = TFCItems.registerSpawnEgg(TFCEntities.LOBSTER, 10892577, 3219522);
    public static final RegistryObject<Item> CRAYFISH_EGG = TFCItems.registerSpawnEgg(TFCEntities.CRAYFISH, 7300690, 6898000);
    public static final RegistryObject<Item> ISOPOD_EGG = TFCItems.registerSpawnEgg(TFCEntities.ISOPOD, 12153018, 9868151);
    public static final RegistryObject<Item> HORSESHOE_CRAB_EGG = TFCItems.registerSpawnEgg(TFCEntities.HORSESHOE_CRAB, 4580077, 4580077);
    public static final RegistryObject<Item> DOLPHIN_EGG = TFCItems.registerSpawnEgg(TFCEntities.DOLPHIN, 2243405, 0xF9F9F9);
    public static final RegistryObject<Item> ORCA_EGG = TFCItems.registerSpawnEgg(TFCEntities.ORCA, 0, 0xFFFFFF);
    public static final RegistryObject<Item> MANATEE_EGG = TFCItems.registerSpawnEgg(TFCEntities.MANATEE, 6649964, 0x7FCFCF);
    public static final RegistryObject<Item> TURTLE_EGG = TFCItems.registerSpawnEgg(TFCEntities.TURTLE, 0xE7E7E7, 44975);
    public static final RegistryObject<Item> PENGUIN_EGG = TFCItems.registerSpawnEgg(TFCEntities.PENGUIN, 16771584, 4670764);
    public static final RegistryObject<Item> FROG_EGG = TFCItems.registerSpawnEgg(TFCEntities.FROG, 13661252, 0xFFC77C);
    public static final RegistryObject<Item> POLAR_BEAR_EGG = TFCItems.registerSpawnEgg(TFCEntities.POLAR_BEAR, 0xF2F2F2, 0x959590);
    public static final RegistryObject<Item> GRIZZLY_BEAR_EGG = TFCItems.registerSpawnEgg(TFCEntities.GRIZZLY_BEAR, 9849600, 13808780);
    public static final RegistryObject<Item> BLACK_BEAR_EGG = TFCItems.registerSpawnEgg(TFCEntities.BLACK_BEAR, 0, 0x333333);
    public static final RegistryObject<Item> COUGAR_EGG = TFCItems.registerSpawnEgg(TFCEntities.COUGAR, 11763537, 15058599);
    public static final RegistryObject<Item> PANTHER_EGG = TFCItems.registerSpawnEgg(TFCEntities.PANTHER, 0, 0xFFFF00);
    public static final RegistryObject<Item> LION_EGG = TFCItems.registerSpawnEgg(TFCEntities.LION, 16046472, 6700312);
    public static final RegistryObject<Item> SABERTOOTH_EGG = TFCItems.registerSpawnEgg(TFCEntities.SABERTOOTH, 12749360, 12762802);
    public static final RegistryObject<Item> TIGER_EGG = TFCItems.registerSpawnEgg(TFCEntities.TIGER, 15700550, 2694431);
    public static final RegistryObject<Item> CROCODILE_EGG = TFCItems.registerSpawnEgg(TFCEntities.CROCODILE, 8030828, 16244402);
    public static final RegistryObject<Item> WOLF_EGG = TFCItems.registerSpawnEgg(TFCEntities.WOLF, 0xD7D3D3, 12762802);
    public static final RegistryObject<Item> HYENA_EGG = TFCItems.registerSpawnEgg(TFCEntities.HYENA, 12557937, 4142114);
    public static final RegistryObject<Item> DIREWOLF_EGG = TFCItems.registerSpawnEgg(TFCEntities.DIREWOLF, 7289618, 0xD7D3D3);
    public static final RegistryObject<Item> SQUID_EGG = TFCItems.registerSpawnEgg(TFCEntities.SQUID, 2243405, 7375001);
    public static final RegistryObject<Item> OCTOPOTEUTHIS_EGG = TFCItems.registerSpawnEgg(TFCEntities.OCTOPOTEUTHIS, 611926, 8778172);
    public static final RegistryObject<Item> PIG_EGG = TFCItems.registerSpawnEgg(TFCEntities.PIG, 15771042, 14377823);
    public static final RegistryObject<Item> COW_EGG = TFCItems.registerSpawnEgg(TFCEntities.COW, 4470310, 0xA1A1A1);
    public static final RegistryObject<Item> GOAT_EGG = TFCItems.registerSpawnEgg(TFCEntities.GOAT, 0xDDDDDD, 0x776677);
    public static final RegistryObject<Item> YAK_EGG = TFCItems.registerSpawnEgg(TFCEntities.YAK, 14139790, 7289618);
    public static final RegistryObject<Item> ALPACA_EGG = TFCItems.registerSpawnEgg(TFCEntities.ALPACA, 52326, 26163);
    public static final RegistryObject<Item> SHEEP_EGG = TFCItems.registerSpawnEgg(TFCEntities.SHEEP, 0xFFFFFF, 0xEEEEEE);
    public static final RegistryObject<Item> MUSK_OX_EGG = TFCItems.registerSpawnEgg(TFCEntities.MUSK_OX, 7289618, 14139790);
    public static final RegistryObject<Item> CHICKEN_EGG = TFCItems.registerSpawnEgg(TFCEntities.CHICKEN, 0xA1A1A1, 0xFF0000);
    public static final RegistryObject<Item> DUCK_EGG = TFCItems.registerSpawnEgg(TFCEntities.DUCK, 6638359, 2785342);
    public static final RegistryObject<Item> QUAIL_EGG = TFCItems.registerSpawnEgg(TFCEntities.QUAIL, 8421797, 0xDDDDDD);
    public static final RegistryObject<Item> RABBIT_EGG = TFCItems.registerSpawnEgg(TFCEntities.RABBIT, 10051392, 7555121);
    public static final RegistryObject<Item> FOX_EGG = TFCItems.registerSpawnEgg(TFCEntities.FOX, 14005919, 1339625);
    public static final RegistryObject<Item> BOAR_EGG = TFCItems.registerSpawnEgg(TFCEntities.BOAR, 8421797, 26163);
    public static final RegistryObject<Item> WILDEBEEST_EGG = TFCItems.registerSpawnEgg(TFCEntities.WILDEBEEST, 4141604, 8613981);
    public static final RegistryObject<Item> OCELOT_EGG = TFCItems.registerSpawnEgg(TFCEntities.OCELOT, 15720061, 5653556);
    public static final RegistryObject<Item> BONGO_EGG = TFCItems.registerSpawnEgg(TFCEntities.BONGO, 11753782, 26163);
    public static final RegistryObject<Item> CARIBOU_EGG = TFCItems.registerSpawnEgg(TFCEntities.CARIBOU, 62149756, 13812401);
    public static final RegistryObject<Item> DEER_EGG = TFCItems.registerSpawnEgg(TFCEntities.DEER, 7289618, 26163);
    public static final RegistryObject<Item> GAZELLE_EGG = TFCItems.registerSpawnEgg(TFCEntities.GAZELLE, 3941399, 12550711);
    public static final RegistryObject<Item> MOOSE_EGG = TFCItems.registerSpawnEgg(TFCEntities.MOOSE, 6638359, 0xDDDDDD);
    public static final RegistryObject<Item> GROUSE_EGG = TFCItems.registerSpawnEgg(TFCEntities.GROUSE, 12429432, 0xDDDDDD);
    public static final RegistryObject<Item> PHEASANT_EGG = TFCItems.registerSpawnEgg(TFCEntities.PHEASANT, 15047696, 16789);
    public static final RegistryObject<Item> TURKEY_EGG = TFCItems.registerSpawnEgg(TFCEntities.TURKEY, 7703987, 15821690);
    public static final RegistryObject<Item> PEAFOWL_EGG = TFCItems.registerSpawnEgg(TFCEntities.PEAFOWL, 215987, 3972434);
    public static final RegistryObject<Item> RAT_EGG = TFCItems.registerSpawnEgg(TFCEntities.RAT, 14139790, 12623485);
    public static final RegistryObject<Item> DONKEY_EGG = TFCItems.registerSpawnEgg(TFCEntities.DONKEY, 5457209, 8811878);
    public static final RegistryObject<Item> MULE_EGG = TFCItems.registerSpawnEgg(TFCEntities.MULE, 1769984, 5321501);
    public static final RegistryObject<Item> HORSE_EGG = TFCItems.registerSpawnEgg(TFCEntities.HORSE, 12623485, 0xEEE500);
    public static final RegistryObject<Item> CAT_EGG = TFCItems.registerSpawnEgg(TFCEntities.CAT, 15714446, 9794134);
    public static final RegistryObject<Item> DOG_EGG = TFCItems.registerSpawnEgg(TFCEntities.DOG, 0xD7D3D3, 13545366);
    public static final RegistryObject<Item> PANDA_EGG = TFCItems.registerSpawnEgg(TFCEntities.PANDA, 0xE7E7E7, 0x1B1B22);
    public static final RegistryObject<Item> UNFIRED_BRICK = TFCItems.register("ceramic/unfired_brick");
    public static final RegistryObject<Item> UNFIRED_CRUCIBLE = TFCItems.register("ceramic/unfired_crucible");
    public static final RegistryObject<Item> UNFIRED_FLOWER_POT = TFCItems.register("ceramic/unfired_flower_pot");
    public static final RegistryObject<Item> UNFIRED_PAN = TFCItems.register("ceramic/unfired_pan");
    public static final RegistryObject<Item> UNFIRED_BLOWPIPE = TFCItems.register("ceramic/unfired_blowpipe");
    public static final RegistryObject<Item> UNFIRED_BOWL = TFCItems.register("ceramic/unfired_bowl");
    public static final RegistryObject<Item> UNFIRED_FIRE_BRICK = TFCItems.register("ceramic/unfired_fire_brick");
    public static final RegistryObject<Item> FIRE_BRICK = TFCItems.register("ceramic/fire_brick");
    public static final RegistryObject<Item> UNFIRED_JUG = TFCItems.register("ceramic/unfired_jug");
    public static final RegistryObject<Item> JUG = TFCItems.register("ceramic/jug", () -> new JugItem(new Item.Properties().m_41487_(1), (Supplier<Integer>)TFCConfig.SERVER.jugCapacity, TFCTags.Fluids.USABLE_IN_JUG));
    public static final RegistryObject<Item> UNFIRED_POT = TFCItems.register("ceramic/unfired_pot");
    public static final RegistryObject<Item> POT = TFCItems.register("ceramic/pot");
    public static final RegistryObject<Item> UNFIRED_SPINDLE_HEAD = TFCItems.register("ceramic/unfired_spindle_head");
    public static final RegistryObject<Item> SPINDLE_HEAD = TFCItems.register("ceramic/spindle_head");
    public static final RegistryObject<Item> UNFIRED_VESSEL = TFCItems.register("ceramic/unfired_vessel");
    public static final RegistryObject<Item> VESSEL = TFCItems.register("ceramic/vessel", () -> new VesselItem(new Item.Properties()));
    public static final Map<DyeColor, RegistryObject<Item>> UNFIRED_GLAZED_VESSELS = Helpers.mapOfKeys(DyeColor.class, color -> TFCItems.register("ceramic/" + color + "_unfired_vessel"));
    public static final Map<DyeColor, RegistryObject<Item>> GLAZED_VESSELS = Helpers.mapOfKeys(DyeColor.class, color -> TFCItems.register("ceramic/" + color + "_glazed_vessel", () -> new VesselItem(new Item.Properties())));
    public static final Map<Metal.ItemType, RegistryObject<Item>> UNFIRED_MOLDS = Helpers.mapOfKeys(Metal.ItemType.class, Metal.ItemType::hasMold, type -> TFCItems.register("ceramic/unfired_" + type.name() + "_mold"));
    public static final Map<Metal.ItemType, RegistryObject<Item>> MOLDS = Helpers.mapOfKeys(Metal.ItemType.class, Metal.ItemType::hasMold, type -> TFCItems.register("ceramic/" + type.name() + "_mold", () -> new MoldItem((Metal.ItemType)((Object)type), new Item.Properties())));
    public static final RegistryObject<Item> UNFIRED_BELL_MOLD = TFCItems.register("ceramic/unfired_bell_mold");
    public static final RegistryObject<Item> BELL_MOLD = TFCItems.register("ceramic/bell_mold", () -> new MoldItem(TFCConfig.SERVER.moldBellCapacity, TFCTags.Fluids.USABLE_IN_BELL_MOLD, new Item.Properties()));
    public static final RegistryObject<Item> UNFIRED_FIRE_INGOT_MOLD = TFCItems.register("ceramic/unfired_fire_ingot_mold");
    public static final RegistryObject<Item> FIRE_INGOT_MOLD = TFCItems.register("ceramic/fire_ingot_mold", () -> new MoldItem(TFCConfig.SERVER.moldFireIngotCapacity, TFCTags.Fluids.USABLE_IN_INGOT_MOLD, new Item.Properties()));
    public static final RegistryObject<Item> UNFIRED_LARGE_VESSEL = TFCItems.register("ceramic/unfired_large_vessel");
    public static final Map<DyeColor, RegistryObject<Item>> UNFIRED_GLAZED_LARGE_VESSELS = Helpers.mapOfKeys(DyeColor.class, color -> TFCItems.register("ceramic/unfired_large_vessel/" + color));
    public static final Map<FluidId, RegistryObject<BucketItem>> FLUID_BUCKETS = FluidId.mapOf(fluid -> TFCItems.register("bucket/" + fluid.name(), () -> new BucketItem(fluid.fluid(), new Item.Properties().m_41495_(Items.f_42446_).m_41487_(1))));
    public static final RegistryObject<FluidContainerItem> RED_STEEL_BUCKET = TFCItems.register("metal/bucket/red_steel", () -> new FluidContainerItem(new Item.Properties(), () -> 1000, TFCTags.Fluids.USABLE_IN_RED_STEEL_BUCKET, true, true));
    public static final RegistryObject<FluidContainerItem> BLUE_STEEL_BUCKET = TFCItems.register("metal/bucket/blue_steel", () -> new FluidContainerItem(new Item.Properties(), () -> 1000, TFCTags.Fluids.USABLE_IN_BLUE_STEEL_BUCKET, true, true));
    public static final RegistryObject<MobBucketItem> COD_BUCKET = TFCItems.register("bucket/cod", () -> new MobBucketItem(TFCEntities.COD, TFCFluids.SALT_WATER.source(), () -> SoundEvents.f_11779_, new Item.Properties().m_41495_(Items.f_42446_).m_41487_(1)));
    public static final RegistryObject<MobBucketItem> PUFFERFISH_BUCKET = TFCItems.register("bucket/pufferfish", () -> new MobBucketItem(TFCEntities.PUFFERFISH, TFCFluids.SALT_WATER.source(), () -> SoundEvents.f_11779_, new Item.Properties().m_41495_(Items.f_42446_).m_41487_(1)));
    public static final RegistryObject<MobBucketItem> JELLYFISH_BUCKET = TFCItems.register("bucket/jellyfish", () -> new MobBucketItem(TFCEntities.JELLYFISH, TFCFluids.SALT_WATER.source(), () -> SoundEvents.f_11779_, new Item.Properties().m_41495_(Items.f_42446_).m_41487_(1)));
    public static final RegistryObject<MobBucketItem> TROPICAL_FISH_BUCKET = TFCItems.register("bucket/tropical_fish", () -> new MobBucketItem(TFCEntities.TROPICAL_FISH, TFCFluids.SALT_WATER.source(), () -> SoundEvents.f_11779_, new Item.Properties().m_41495_(Items.f_42446_).m_41487_(1)));
    public static final Map<Fish, RegistryObject<MobBucketItem>> FRESHWATER_FISH_BUCKETS = Helpers.mapOfKeys(Fish.class, fish -> TFCItems.register("bucket/" + fish.getSerializedName(), () -> new MobBucketItem((Supplier)TFCEntities.FRESHWATER_FISH.get(fish), () -> Fluids.f_76193_, () -> SoundEvents.f_11779_, new Item.Properties().m_41495_(Items.f_42446_).m_41487_(1))));

    public static void editItemMaxDamage() {
        ((ItemAccessor)Items.f_42409_).accessor$setMaxDamage(TFCTiers.STEEL.m_6609_());
    }

    private static <T extends EntityType<? extends Mob>> RegistryObject<Item> registerSpawnEgg(RegistryObject<T> entity, int color1, int color2) {
        return TFCItems.register("spawn_egg/" + entity.getId().m_135815_(), () -> new ForgeSpawnEggItem((Supplier)entity, color1, color2, new Item.Properties()));
    }

    private static RegistryObject<Item> register(String name) {
        return TFCItems.register(name, () -> new Item(new Item.Properties()));
    }

    private static <T extends Item> RegistryObject<T> register(String name, Supplier<T> item) {
        return ITEMS.register(name.toLowerCase(Locale.ROOT), item);
    }
}

