/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.items;

import net.dries007.tfc.common.blockentities.JarsBlockEntity;
import net.dries007.tfc.common.blocks.JarShelfBlock;
import net.dries007.tfc.common.blocks.JarsBlock;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.devices.BottomSupportedDeviceBlock;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class JarItem
extends Item {
    private final ResourceLocation model;
    private final boolean hasContainerItem;

    public JarItem(Item.Properties properties, String fruit, boolean hasContainerItem) {
        this(properties, Helpers.identifier("block/jar/" + fruit), hasContainerItem);
    }

    public JarItem(Item.Properties properties, ResourceLocation model, boolean hasContainerItem) {
        super(properties);
        this.model = model;
        this.hasContainerItem = hasContainerItem;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Block block;
        Level level = context.m_43725_();
        ItemStack held = context.m_43722_();
        BlockPos pos = context.m_8083_();
        BlockPos above = pos.m_7494_();
        Direction dir = context.m_43719_();
        BlockState stateUp = level.m_8055_(above);
        Player player = context.m_43723_();
        if (dir == Direction.UP && BottomSupportedDeviceBlock.canSurvive((LevelReader)level, above) && stateUp.m_60795_()) {
            JarsBlockEntity jars;
            IItemHandler inv;
            level.m_46597_(above, ((Block)TFCBlocks.JARS.get()).m_49966_());
            BlockEntity blockEntity = level.m_7702_(above);
            if (blockEntity instanceof JarsBlockEntity && (inv = Helpers.getCapability((ICapabilityProvider)(jars = (JarsBlockEntity)blockEntity), Capabilities.ITEM)) != null) {
                int slot = JarItem.getSlot(context);
                ItemStack leftover = inv.insertItem(slot, held.m_41620_(1), false);
                if (player != null) {
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)leftover);
                    level.m_46597_(above, JarsBlock.updateStateValues((LevelAccessor)level, above, level.m_8055_(above)));
                }
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        BlockEntity inv = level.m_7702_(above);
        if (inv instanceof JarsBlockEntity) {
            JarsBlockEntity jars = (JarsBlockEntity)inv;
            int slot = JarItem.getSlot(context);
            IItemHandler inv2 = Helpers.getCapability((ICapabilityProvider)jars, Capabilities.ITEM);
            if (inv2 != null) {
                ItemStack leftover = inv2.insertItem(slot, held.m_41620_(1), false);
                if (player != null) {
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)leftover);
                }
                level.m_46597_(above, JarsBlock.updateStateValues((LevelAccessor)level, above, level.m_8055_(above)));
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        }
        if (dir == Direction.UP && (block = stateUp.m_60734_()) instanceof JarShelfBlock) {
            JarShelfBlock block2 = (JarShelfBlock)block;
            if (player != null) {
                return block2.m_6227_(stateUp, level, above, player, context.m_43724_(), new BlockHitResult(context.m_43720_(), Direction.UP, above, true));
            }
        }
        return InteractionResult.PASS;
    }

    private static int getSlot(UseOnContext context) {
        Vec3 location = context.m_43720_();
        boolean x = (double)Math.round(location.f_82479_) < location.f_82479_;
        boolean z = (double)Math.round(location.f_82481_) < location.f_82481_;
        int slot = (x ? 1 : 0) + (z ? 2 : 0);
        return slot;
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return this.hasContainerItem;
    }

    public ItemStack getCraftingRemainingItem(ItemStack itemStack) {
        return new ItemStack((ItemLike)TFCItems.EMPTY_JAR.get());
    }

    public ResourceLocation getModel() {
        return this.model;
    }
}

