/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.items;

import java.util.function.Supplier;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.capabilities.food.TFCFoodData;
import net.dries007.tfc.common.items.FluidContainerItem;
import net.dries007.tfc.util.Drinkable;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class GlassBottleItem
extends FluidContainerItem {
    public static final int DRINK_AMOUNT = 100;
    private final Supplier<Double> breakChance;

    public GlassBottleItem(Item.Properties properties, Supplier<Integer> capacity, Supplier<Double> breakChance, TagKey<Fluid> whitelist) {
        super(properties, capacity, whitelist, false, false);
        this.breakChance = breakChance;
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entity) {
        IFluidHandler handler = stack.getCapability(Capabilities.FLUID_ITEM).resolve().orElse(null);
        if (handler != null) {
            FluidStack drained = handler.drain(100, IFluidHandler.FluidAction.EXECUTE);
            if (entity instanceof Player) {
                Player player = (Player)entity;
                Drinkable drinkable = Drinkable.get(drained.getFluid());
                if (drinkable != null && !level.f_46443_) {
                    drinkable.onDrink(player, drained.getAmount());
                }
            }
            if ((double)entity.m_217043_().m_188501_() < this.breakChance.get()) {
                stack.m_41774_(1);
                level.m_5594_(null, entity.m_20183_(), (SoundEvent)TFCSounds.CERAMIC_BREAK.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
        return stack;
    }

    @Override
    protected InteractionResultHolder<ItemStack> afterFillFailed(IFluidHandler handler, Level level, Player player, ItemStack stack, InteractionHand hand) {
        level.m_5594_(player, player.m_20183_(), (SoundEvent)TFCSounds.JUG_BLOW.get(), SoundSource.PLAYERS, 1.0f, 1.3f + (float)(player.m_20154_().f_82480_ / 2.0));
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public int m_8105_(ItemStack stack) {
        return 32;
    }

    @Override
    protected InteractionResultHolder<ItemStack> afterEmptyFailed(IFluidHandler handler, Level level, Player player, ItemStack stack, InteractionHand hand) {
        if (player.m_6144_()) {
            level.m_5594_(player, player.m_20183_(), SoundEvents.f_11778_, SoundSource.PLAYERS, 0.5f, 1.2f);
            handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE);
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        Drinkable drinkable = Drinkable.get(handler.getFluidInTank(0).getFluid());
        if (drinkable != null) {
            TFCFoodData food;
            FoodData foodData;
            if (!drinkable.mayDrinkWhenFull() && (foodData = player.m_36324_()) instanceof TFCFoodData && (food = (TFCFoodData)foodData).getThirst() >= 100.0f) {
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            return ItemUtils.m_150959_((Level)level, (Player)player, (InteractionHand)hand);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public int m_142159_(ItemStack stack) {
        return stack.getCapability(Capabilities.FLUID_ITEM).map(cap -> {
            int color = RenderHelpers.getFluidColor(cap.getFluidInTank(0));
            int r = FastColor.ARGB32.m_13665_((int)color);
            int g = FastColor.ARGB32.m_13667_((int)color);
            int b = FastColor.ARGB32.m_13669_((int)color);
            return FastColor.ARGB32.m_13660_((int)0, (int)r, (int)g, (int)b);
        }).orElse(1048575);
    }

    public int m_142158_(ItemStack stack) {
        return stack.getCapability(Capabilities.FLUID_ITEM).map(cap -> (int)Mth.m_14036_((float)((float)cap.getFluidInTank(0).getAmount() / (float)((Integer)this.capacity.get()).intValue() * 13.0f), (float)1.0f, (float)13.0f)).orElse(0);
    }

    public boolean m_142522_(ItemStack stack) {
        return stack.getCapability(Capabilities.FLUID_ITEM).map(cap -> !cap.getFluidInTank(0).isEmpty()).orElse(false);
    }
}

