/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.fluids;

import java.util.Map;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.mixin.accessor.FlowingFluidAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.fluids.ForgeFlowingFluid;

public abstract class MixingFluid
extends ForgeFlowingFluid {
    public static short m_76058_(BlockPos from, BlockPos to) {
        int deltaX = to.m_123341_() - from.m_123341_();
        int deltaZ = to.m_123343_() - from.m_123343_();
        return (short)((deltaX + 128 & 0xFF) << 8 | deltaZ + 128 & 0xFF);
    }

    protected MixingFluid(ForgeFlowingFluid.Properties properties) {
        super(properties);
    }

    public int m_76019_(LevelReader worldIn, BlockPos pos) {
        int adjacentSources = 0;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos adjacentPos = pos.m_121945_(direction);
            FluidState adjacentFluid = worldIn.m_6425_(adjacentPos);
            if (!this.m_76096_(adjacentFluid)) continue;
            ++adjacentSources;
        }
        return adjacentSources;
    }

    public boolean m_76096_(FluidState stateIn) {
        return stateIn.m_76152_().m_6212_((Fluid)this) && stateIn.m_76170_();
    }

    public void m_76014_(Level level, BlockPos pos, FluidState sourceFluid, BlockState sourceState) {
        int adjacentAmount = sourceFluid.m_76186_() - this.m_6713_((LevelReader)level);
        if (((Boolean)sourceFluid.m_61143_((Property)f_75947_)).booleanValue()) {
            adjacentAmount = 7;
        }
        if (adjacentAmount > 0) {
            Map map = this.m_76079_(level, pos, sourceState);
            for (Map.Entry entry : map.entrySet()) {
                BlockState destState;
                Direction direction = (Direction)entry.getKey();
                FluidState spreadFluid = (FluidState)entry.getValue();
                BlockPos destPos = pos.m_121945_(direction);
                if (!this.m_75977_((BlockGetter)level, pos, sourceState, direction, destPos, destState = level.m_8055_(destPos), level.m_6425_(destPos), spreadFluid.m_76152_())) continue;
                this.m_6364_((LevelAccessor)level, destPos, destState, direction, spreadFluid);
            }
        }
    }

    protected void m_76010_(Level level, BlockPos pos, FluidState stateIn) {
        if (!stateIn.m_76178_()) {
            BlockState blockStateAt = level.m_8055_(pos);
            BlockPos posBelow = pos.m_7495_();
            BlockState blockStateBelow = level.m_8055_(posBelow);
            FluidState fluidstate = this.m_76035_(level, posBelow, blockStateBelow);
            if (this.m_75977_((BlockGetter)level, pos, blockStateAt, Direction.DOWN, posBelow, blockStateBelow, level.m_6425_(posBelow), fluidstate.m_76152_())) {
                this.m_6364_((LevelAccessor)level, posBelow, blockStateBelow, Direction.DOWN, fluidstate);
                if (this.m_76019_((LevelReader)level, pos) >= 3) {
                    this.m_76014_(level, pos, stateIn, blockStateAt);
                }
            } else if (stateIn.m_76170_() || !((FlowingFluidAccessor)((Object)this)).invoke$isWaterHole((BlockGetter)level, fluidstate.m_76152_(), pos, blockStateAt, posBelow, blockStateBelow)) {
                this.m_76014_(level, pos, stateIn, blockStateAt);
            }
        }
    }

    protected FluidState m_76035_(Level level, BlockPos pos, BlockState blockStateIn) {
        return FluidHelpers.getNewFluidWithMixing((FlowingFluid)this, level, pos, blockStateIn, this.canConvertToSource(blockStateIn.m_60819_(), level, pos), this.m_6713_((LevelReader)level));
    }

    public void m_6292_(Level level, BlockPos pos, FluidState state) {
        if (!state.m_76170_()) {
            FluidState fluidAt = this.m_76035_(level, pos, level.m_8055_(pos));
            int spreadDelay = this.m_6886_(level, pos, state, fluidAt);
            if (fluidAt.m_76178_()) {
                state = fluidAt;
                level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            } else if (!fluidAt.equals(state)) {
                state = fluidAt;
                BlockState blockstate = fluidAt.m_76188_();
                level.m_7731_(pos, blockstate, 2);
                level.m_186469_(pos, fluidAt.m_76152_(), spreadDelay);
                level.m_46672_(pos, blockstate.m_60734_());
            }
        }
        this.m_76010_(level, pos, state);
    }

    public static class Source
    extends MixingFluid {
        public Source(ForgeFlowingFluid.Properties properties) {
            super(properties);
        }

        public boolean m_7444_(FluidState state) {
            return true;
        }

        public int m_7430_(FluidState state) {
            return 8;
        }
    }

    public static class Flowing
    extends MixingFluid {
        public Flowing(ForgeFlowingFluid.Properties properties) {
            super(properties);
        }

        public boolean m_7444_(FluidState state) {
            return false;
        }

        public int m_7430_(FluidState state) {
            return (Integer)state.m_61143_((Property)f_75948_);
        }

        protected void m_7180_(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.m_7180_(builder.m_61104_(new Property[]{f_75948_}));
        }
    }
}

