/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.fluids;

import java.util.function.Consumer;
import net.dries007.tfc.common.fluids.FluidTypeClientProperties;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;

public class ExtendedFluidType
extends FluidType {
    private final FluidTypeClientProperties clientProperties;

    public ExtendedFluidType(FluidType.Properties properties, FluidTypeClientProperties clientProperties) {
        super(properties);
        this.clientProperties = clientProperties;
    }

    public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
        consumer.accept(new IClientFluidTypeExtensions(){

            public int getTintColor() {
                return ExtendedFluidType.this.clientProperties.tintColor();
            }

            public int getTintColor(FluidState state, BlockAndTintGetter getter, BlockPos pos) {
                return ExtendedFluidType.this.clientProperties.tintColorFunction().applyAsInt(getter, pos);
            }

            public ResourceLocation getStillTexture() {
                return ExtendedFluidType.this.clientProperties.stillTexture();
            }

            public ResourceLocation getFlowingTexture() {
                return ExtendedFluidType.this.clientProperties.flowingTexture();
            }

            @Nullable
            public ResourceLocation getOverlayTexture() {
                return ExtendedFluidType.this.clientProperties.overlayTexture();
            }

            @Nullable
            public ResourceLocation getRenderOverlayTexture(Minecraft minecraft) {
                return ExtendedFluidType.this.clientProperties.renderOverlayTexture();
            }
        });
    }
}

