/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.prey;

import com.mojang.serialization.Dynamic;
import java.util.Collection;
import java.util.Optional;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.entities.BrainBreeder;
import net.dries007.tfc.common.entities.EntityHelpers;
import net.dries007.tfc.common.entities.TFCEntities;
import net.dries007.tfc.common.entities.Temptable;
import net.dries007.tfc.common.entities.prey.TFCFrogAi;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FrogVariant;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public class TFCFrog
extends Frog
implements Temptable,
BrainBreeder {
    public static final EntityDataAccessor<Boolean> DATA_IS_MALE = SynchedEntityData.m_135353_(TFCFrog.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Float> DATA_FAMILIARITY = SynchedEntityData.m_135353_(TFCFrog.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private long lastMated = Long.MIN_VALUE;
    private long nextFeedTime = Long.MIN_VALUE;

    public TFCFrog(EntityType<? extends Frog> type, Level level) {
        super(type, level);
    }

    protected Brain.Provider<Frog> m_5490_() {
        return Brain.m_21923_((Collection)f_218457_, TFCFrogAi.SENSOR_TYPES);
    }

    protected Brain<?> m_8075_(Dynamic<?> dynamic) {
        return TFCFrogAi.makeBrain((Brain<? extends Frog>)super.m_8075_(dynamic));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_IS_MALE, (Object)true);
        this.f_19804_.m_135372_(DATA_FAMILIARITY, (Object)Float.valueOf(0.0f));
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setFamiliarity(tag.m_128457_("familiarity"));
        this.setIsMale(tag.m_128471_("male"));
        this.lastMated = tag.m_128454_("lastMated");
        this.nextFeedTime = tag.m_128454_("nextFeed");
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("male", this.isMale());
        tag.m_128350_("familiarity", this.getFamiliarity());
        tag.m_128356_("lastMated", this.lastMated);
        tag.m_128356_("nextFeed", this.nextFeedTime);
    }

    public float getFamiliarity() {
        return ((Float)this.f_19804_.m_135370_(DATA_FAMILIARITY)).floatValue();
    }

    public void setFamiliarity(float familiarity) {
        this.f_19804_.m_135381_(DATA_FAMILIARITY, (Object)Float.valueOf(familiarity));
    }

    public void setIsMale(boolean male) {
        this.f_19804_.m_135381_(DATA_IS_MALE, (Object)male);
    }

    @Override
    public boolean isMale() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_MALE);
    }

    @Override
    public void setMated(long ticks) {
        this.lastMated = ticks;
    }

    public boolean m_7848_(Animal animal) {
        if (animal != this && animal instanceof TFCFrog) {
            TFCFrog other = (TFCFrog)animal;
            float min = 0.3f;
            return other.isMale() != this.isMale() && this.beenLongEnoughToMate() && other.beenLongEnoughToMate() && this.getFamiliarity() > 0.3f && other.getFamiliarity() > 0.3f && this.fedRecently() && other.fedRecently();
        }
        return false;
    }

    protected boolean beenLongEnoughToMate() {
        return Calendars.get((LevelReader)this.m_9236_()).getTicks() > this.lastMated + 288000L;
    }

    @Override
    public boolean m_6898_(ItemStack stack) {
        return !FoodCapability.isRotten(stack) && Helpers.isItem(stack, TFCTags.Items.FROG_FOOD);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType type, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag tag) {
        SpawnGroupData spawnData = super.m_6518_(level, difficulty, type, spawnGroupData, tag);
        BlockPos pos = this.m_20183_();
        ChunkData data = EntityHelpers.getChunkDataForSpawning(level, pos);
        float temp = data.getAverageTemp(pos);
        if (temp < 0.0f) {
            this.m_28464_(FrogVariant.f_218187_);
        } else {
            this.m_28464_(temp > 18.0f ? FrogVariant.f_218186_ : FrogVariant.f_218185_);
        }
        this.setIsMale(this.f_19796_.m_188499_());
        return spawnData;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob mob) {
        if (mob == this) {
            TFCFrog frog = (TFCFrog)((EntityType)TFCEntities.FROG.get()).m_20615_((Level)level);
            if (frog != null) {
                frog.m_6274_().m_21879_(MemoryModuleType.f_148199_, (Object)UniformInt.m_146622_((int)100, (int)140).m_214085_(this.f_19796_));
            }
            return frog;
        }
        if (mob instanceof TFCFrog) {
            TFCFrog animal = (TFCFrog)mob;
            this.m_27563_(level, (Animal)animal);
        }
        return null;
    }

    public void m_277117_(ServerLevel level, Animal animal, @Nullable AgeableMob mob) {
        Optional.ofNullable(this.m_27592_()).or(() -> Optional.ofNullable(animal.m_27592_())).ifPresent(player -> {
            player.m_36220_(Stats.f_12937_);
            CriteriaTriggers.f_10581_.m_147278_(player, (Animal)this, animal, mob);
        });
        this.m_27594_();
        animal.m_27594_();
        level.m_7605_((Entity)this, (byte)18);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack held = player.m_21120_(hand);
        if (this.m_6898_(held)) {
            long ticks;
            if (!this.m_9236_().f_46443_ && (ticks = Calendars.SERVER.getTicks()) > this.nextFeedTime) {
                this.setFamiliarity(this.getFamiliarity() + 0.1f);
                this.nextFeedTime = ticks + 24000L;
                this.m_142075_(player, hand, held);
                this.m_216990_(SoundEvents.f_215692_);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    private boolean fedRecently() {
        return Calendars.get((LevelReader)this.m_9236_()).getTicks() < this.nextFeedTime;
    }
}

