/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.prey;

import javax.annotation.Nullable;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.plant.fruit.Lifecycle;
import net.dries007.tfc.common.blocks.plant.fruit.SeasonalPlantBlock;
import net.dries007.tfc.common.entities.EntityHelpers;
import net.dries007.tfc.common.entities.TFCEntities;
import net.dries007.tfc.common.entities.ai.TFCAvoidEntityGoal;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.ForgeEventFactory;

public class TFCFox
extends Fox {
    private static final EntityDataAccessor<Integer> DATA_TYPE_ID_TFC = SynchedEntityData.m_135353_(TFCFox.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public TFCFox(EntityType<? extends Fox> type, Level level) {
        super(type, level);
    }

    protected void m_213945_(RandomSource source, DifficultyInstance instance) {
        if (this.f_19796_.m_188501_() < 0.15f) {
            Helpers.randomItem(TFCTags.Items.FOX_SPAWNS_WITH, this.f_19796_).ifPresent(item -> this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)item)));
        }
    }

    public Fox.Type m_28554_() {
        return Fox.Type.m_28812_((int)((Integer)this.f_19804_.m_135370_(DATA_TYPE_ID_TFC)));
    }

    public void m_28464_(Fox.Type id) {
        this.f_19804_.m_135381_(DATA_TYPE_ID_TFC, (Object)id.m_28820_());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_TYPE_ID_TFC, (Object)0);
    }

    protected void m_8099_() {
        super.m_8099_();
        EntityHelpers.removeGoalOfPriority(this.f_21345_, 3);
        EntityHelpers.removeGoalOfClass(this.f_21345_, Fox.FoxEatBerriesGoal.class);
        this.f_21345_.m_25352_(4, new TFCAvoidEntityGoal<PathfinderMob>((PathfinderMob)this, PathfinderMob.class, 8.0f, 1.6f, 1.4f, TFCTags.Entities.HUNTS_LAND_PREY));
        this.f_21345_.m_25352_(10, (Goal)new TFCFoxEatBerriesGoal());
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType type, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        SpawnGroupData spawnData = super.m_6518_(level, difficulty, type, data, tag);
        ChunkData chunkData = EntityHelpers.getChunkDataForSpawning(level, this.m_20183_());
        this.m_28464_(chunkData.getAverageTemp(this.m_20183_()) < 0.0f ? Fox.Type.SNOW : Fox.Type.RED);
        return spawnData;
    }

    public TFCFox getBreedOffspring(ServerLevel level, AgeableMob other) {
        TFCFox fox = (TFCFox)((EntityType)TFCEntities.FOX.get()).m_20615_((Level)level);
        this.m_28464_(this.f_19796_.m_188499_() ? this.m_28554_() : ((TFCFox)other).m_28554_());
        return fox;
    }

    public boolean m_6898_(ItemStack stack) {
        return false;
    }

    public class TFCFoxEatBerriesGoal
    extends Fox.FoxEatBerriesGoal {
        public TFCFoxEatBerriesGoal() {
            super((Fox)TFCFox.this, 1.2, 12, 1);
        }

        protected boolean m_6465_(LevelReader level, BlockPos pos) {
            BlockState state = level.m_8055_(pos);
            return Helpers.isBlock(state, TFCTags.Blocks.FOX_RAIDABLE) && this.isFruiting(state);
        }

        protected void m_28686_() {
            BlockState currentState;
            Block block;
            TFCFox fox = TFCFox.this;
            Level level = fox.m_9236_();
            if (ForgeEventFactory.getMobGriefingEvent((Level)level, (Entity)fox) && (block = (currentState = level.m_8055_(this.f_25602_)).m_60734_()) instanceof SeasonalPlantBlock) {
                ItemStack product;
                SeasonalPlantBlock seasonal = (SeasonalPlantBlock)block;
                if (fox.m_6844_(EquipmentSlot.MAINHAND).m_41619_() && !(product = seasonal.getProductItem(fox.f_19796_)).m_41619_()) {
                    fox.m_5496_(SoundEvents.f_12457_, 1.0f, 1.0f);
                    product.m_41764_(1);
                    fox.m_8061_(EquipmentSlot.MAINHAND, product);
                    level.m_46597_(this.f_25602_, seasonal.stateAfterPicking(currentState));
                }
            }
        }

        public boolean m_8036_() {
            return super.m_8036_() && TFCFox.this.m_6844_(EquipmentSlot.MAINHAND).m_41619_();
        }

        private boolean isFruiting(BlockState state) {
            return state.m_61138_(SeasonalPlantBlock.LIFECYCLE) && state.m_61143_(SeasonalPlantBlock.LIFECYCLE) == Lifecycle.FRUITING;
        }
    }
}

