/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.misc;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.dries007.tfc.common.blockentities.TFCChestBlockEntity;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.capabilities.InventoryWrapper;
import net.dries007.tfc.common.container.ISlotCallback;
import net.dries007.tfc.common.container.RestrictedChestContainer;
import net.dries007.tfc.common.container.TFCContainerTypes;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.Container;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.ChestBoat;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class TFCChestBoat
extends ChestBoat
implements ISlotCallback {
    public static final EntityDataAccessor<ItemStack> CHEST_ITEM = SynchedEntityData.m_135353_(TFCChestBoat.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private final Supplier<? extends Item> drop;
    @Nullable
    private LazyOptional<IItemHandler> inventoryHandler;

    public TFCChestBoat(EntityType<? extends Boat> type, Level level, Supplier<? extends Item> drop) {
        super(type, level);
        this.drop = drop;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        if (this.m_214142_() != null && player.m_5833_()) {
            return null;
        }
        this.m_219913_(inv.f_35978_);
        return new RestrictedChestContainer((MenuType)TFCContainerTypes.CHEST_9x2.get(), windowId, inv, (Container)this, 2);
    }

    public void m_213560_(DamageSource source) {
        super.m_213560_(source);
        this.m_19983_(this.getChestItem().m_41777_());
    }

    public int m_6643_() {
        return 18;
    }

    public boolean m_7013_(int slot, ItemStack stack) {
        return TFCChestBlockEntity.isValid(stack);
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        return this.m_7013_(slot, stack);
    }

    public void invalidateCaps() {
        this.invalidateInventoryHandler();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap) {
        return this.getCapability(cap, null);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == Capabilities.ITEM) {
            return this.getInventoryHandler().cast();
        }
        return LazyOptional.empty();
    }

    private void invalidateInventoryHandler() {
        if (this.inventoryHandler != null) {
            this.inventoryHandler.invalidate();
            this.inventoryHandler = null;
        }
    }

    private LazyOptional<IItemHandler> getInventoryHandler() {
        if (this.inventoryHandler != null) {
            return this.inventoryHandler;
        }
        InventoryWrapper itemHandler = new InventoryWrapper((Container)this, this);
        this.inventoryHandler = LazyOptional.of(() -> itemHandler);
        return this.inventoryHandler;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CHEST_ITEM, (Object)ItemStack.f_41583_);
    }

    protected void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setChestItem(ItemStack.m_41712_((CompoundTag)tag.m_128469_("chestItem")));
    }

    protected void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128365_("chestItem", (Tag)this.getChestItem().m_41739_(new CompoundTag()));
    }

    public EntityType<?> m_6095_() {
        return super.m_6095_();
    }

    public Item m_38369_() {
        return this.drop.get();
    }

    public ItemStack getChestItem() {
        return (ItemStack)this.f_19804_.m_135370_(CHEST_ITEM);
    }

    public void setChestItem(ItemStack stack) {
        this.f_19804_.m_135381_(CHEST_ITEM, (Object)stack.m_41777_());
    }
}

