/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.livestock.pet;

import java.util.List;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.entities.EntityHelpers;
import net.dries007.tfc.common.entities.livestock.MammalProperties;
import net.dries007.tfc.common.entities.livestock.TFCAnimalProperties;
import net.dries007.tfc.common.entities.livestock.pet.TamableMammal;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.CatVariantTags;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class TFCCat
extends TamableMammal {
    public static final EntityDataAccessor<CatVariant> DATA_VARIANT = SynchedEntityData.m_135353_(TFCCat.class, (EntityDataSerializer)EntityDataSerializers.f_238114_);
    private static final List<ResourceKey<CatVariant>> LEGACY_CAT_VARIANTS = List.of(CatVariant.f_218140_, CatVariant.f_218141_, CatVariant.f_218142_, CatVariant.f_218143_, CatVariant.f_218144_, CatVariant.f_218145_, CatVariant.f_218146_, CatVariant.f_218147_, CatVariant.f_218148_, CatVariant.f_218149_, CatVariant.f_218150_);

    public TFCCat(EntityType<? extends TamableMammal> type, Level level) {
        super(type, level, TFCSounds.CAT, TFCConfig.SERVER.catConfig);
    }

    @Override
    public boolean willListenTo(TamableMammal.Command command, boolean isClientSide) {
        if (!isClientSide && command == TamableMammal.Command.SIT && this.m_217043_().m_188501_() < 0.1f) {
            return false;
        }
        return super.willListenTo(command, isClientSide);
    }

    @Override
    public void createGenes(CompoundTag tag, TFCAnimalProperties male) {
        super.createGenes(tag, male);
        if (male instanceof TFCCat) {
            TFCCat maleCat = (TFCCat)male;
            tag.m_128359_("variant", this.f_19796_.m_188499_() ? maleCat.getVariant().toString() : this.getVariant().toString());
        }
    }

    @Override
    public void applyGenes(CompoundTag tag, MammalProperties baby) {
        super.applyGenes(tag, baby);
        if (baby instanceof TFCCat) {
            TFCCat cat = (TFCCat)baby;
            CatVariant variant = (CatVariant)BuiltInRegistries.f_256754_.m_7745_(ResourceLocation.m_135820_((String)EntityHelpers.getStringOrDefault(tag, "variant", CatVariant.f_218141_.toString())));
            if (variant != null) {
                cat.setVariant(variant);
            }
        }
    }

    @Override
    public void initCommonAnimalData(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason) {
        super.initCommonAnimalData(level, difficulty, reason);
        boolean fullMoon = level.m_46940_() > 0.9f;
        TagKey key = fullMoon ? CatVariantTags.f_215842_ : CatVariantTags.f_215841_;
        BuiltInRegistries.f_256754_.m_203561_(key).m_213653_(this.f_19796_).ifPresent(holder -> this.setVariant((CatVariant)holder.get()));
        ServerLevel serverlevel = level.m_6018_();
        if (serverlevel.m_215010_().m_220491_(this.m_20183_(), StructureTags.f_215888_).m_73603_()) {
            this.setVariant((CatVariant)BuiltInRegistries.f_256754_.m_123013_(CatVariant.f_218150_));
            this.m_21530_();
        }
    }

    @Override
    public boolean m_6779_(LivingEntity entity) {
        return super.m_6779_(entity) && Helpers.isEntity((Entity)entity, TFCTags.Entities.HUNTED_BY_CATS);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_VARIANT, (Object)((CatVariant)BuiltInRegistries.f_256754_.m_123013_(CatVariant.f_218141_)));
    }

    public CatVariant getVariant() {
        return (CatVariant)this.f_19804_.m_135370_(DATA_VARIANT);
    }

    public void setVariant(CatVariant type) {
        this.f_19804_.m_135381_(DATA_VARIANT, (Object)type);
    }

    public ResourceLocation getTextureLocation() {
        return this.getVariant().f_218151_();
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        ResourceLocation key = BuiltInRegistries.f_256754_.m_7981_((Object)this.getVariant());
        if (key != null) {
            tag.m_128359_("variant", key.toString());
        }
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        CatVariant variant;
        super.m_7378_(tag);
        if (tag.m_128425_("variant", 8) && (variant = (CatVariant)BuiltInRegistries.f_256754_.m_7745_(ResourceLocation.m_135820_((String)tag.m_128461_("variant")))) != null) {
            this.setVariant(variant);
        }
    }

    @Override
    public TagKey<Item> getFoodTag() {
        return TFCTags.Items.CAT_FOOD;
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return size.f_20378_ * 0.5f;
    }

    @Override
    public void receiveCommand(ServerPlayer player, TamableMammal.Command command) {
        if (this.m_269323_() != null && this.m_269323_().equals((Object)player)) {
            this.m_5496_(SoundEvents.f_11793_, this.m_6121_(), this.m_6100_());
        }
        super.receiveCommand(player, command);
    }
}

