/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.livestock;

import com.mojang.serialization.Dynamic;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.capabilities.egg.EggCapability;
import net.dries007.tfc.common.capabilities.egg.IEgg;
import net.dries007.tfc.common.entities.EntityHelpers;
import net.dries007.tfc.common.entities.Pluckable;
import net.dries007.tfc.common.entities.ai.livestock.LivestockAi;
import net.dries007.tfc.common.entities.ai.livestock.OviparousAi;
import net.dries007.tfc.common.entities.livestock.ProducingAnimal;
import net.dries007.tfc.common.entities.livestock.TFCAnimalProperties;
import net.dries007.tfc.config.animals.OviparousAnimalConfig;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.events.AnimalProductEvent;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public abstract class OviparousAnimal
extends ProducingAnimal
implements Pluckable {
    public float flapping = 1.0f;
    public float oFlap;
    public float flap;
    public float oFlapSpeed;
    public float flapSpeed;
    private float nextFlap = 1.0f;
    private final ForgeConfigSpec.IntValue hatchDays;
    private long lastPlucked = Long.MIN_VALUE;
    private boolean crowed;
    private final boolean isCrowingBird;

    public static AttributeSupplier.Builder createAttributes() {
        return Chicken.m_28263_().m_22268_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), 1.5);
    }

    public OviparousAnimal(EntityType<? extends OviparousAnimal> type, Level level, TFCSounds.EntitySound sounds, OviparousAnimalConfig config, boolean isCrowingBird) {
        super(type, level, sounds, config.inner());
        this.isCrowingBird = isCrowingBird;
        this.hatchDays = config.hatchDays();
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        EntityHelpers.getLongOrDefault(tag, "plucked", Long.MIN_VALUE);
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128356_("plucked", this.lastPlucked);
    }

    @Override
    public long getLastPluckedTick() {
        return this.lastPlucked;
    }

    @Override
    public void setLastPluckedTick(long tick) {
        this.lastPlucked = tick;
    }

    protected float m_6118_() {
        if (!this.f_21342_.m_24995_() || this.f_21342_.m_25001_() <= this.m_20186_() + 0.5 && this.f_21342_.m_24999_() > (double)1.1f) {
            return super.m_6118_() * 1.2f;
        }
        return super.m_6118_();
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        if (this.m_9236_().m_46467_() % 20L == 0L && this.f_19796_.m_188503_(3) == 0 && this.m_6274_().m_21968_().filter(p -> p == Activity.f_37991_).isPresent()) {
            this.m_21569_().m_24901_();
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        long time = this.m_9236_().m_46468_() % 24000L;
        if (this.isCrowingBird && !this.crowed && time > 0L && time < 1000L && this.f_19796_.m_188503_(10) == 0) {
            if (this.getGender().toBool()) {
                this.m_5496_((SoundEvent)TFCSounds.ROOSTER_CRY.get(), this.m_6121_() * 1.2f, this.m_6100_());
            } else if (this.m_7515_() != null) {
                this.m_5496_(this.m_7515_(), this.m_6121_() * 0.5f, this.m_6100_());
            }
            this.crowed = true;
        }
        if (time > 1000L) {
            this.crowed = false;
        }
    }

    protected Brain.Provider<? extends OviparousAnimal> m_5490_() {
        return Brain.m_21923_(OviparousAi.MEMORY_TYPES, OviparousAi.SENSOR_TYPES);
    }

    @Override
    protected Brain<?> m_8075_(Dynamic<?> dynamic) {
        return OviparousAi.makeBrain((Brain<? extends OviparousAnimal>)this.m_5490_().m_22073_(dynamic));
    }

    public Brain<? extends OviparousAnimal> m_6274_() {
        return super.m_6274_();
    }

    @Override
    public void tickBrain() {
        this.m_6274_().m_21865_((ServerLevel)this.m_9236_(), (LivingEntity)this);
        LivestockAi.updateActivity(this);
    }

    protected boolean m_142039_() {
        return this.f_146794_ > this.nextFlap;
    }

    protected void m_142043_() {
        this.nextFlap = this.f_146794_ + this.flapSpeed / 2.0f;
    }

    protected float m_6431_(Pose pose, EntityDimensions dims) {
        return dims.f_20378_ * 0.92f;
    }

    public void m_8107_() {
        super.m_8107_();
        this.oFlap = this.flap;
        this.oFlapSpeed = this.flapSpeed;
        this.flapSpeed += (this.m_20096_() ? -1.0f : 4.0f) * 0.3f;
        this.flapSpeed = Mth.m_14036_((float)this.flapSpeed, (float)0.0f, (float)1.0f);
        if (this.m_20159_()) {
            this.flapSpeed = 0.0f;
        }
        if (!this.m_20096_() && this.flapping < 1.0f) {
            this.flapping = 1.0f;
        }
        this.flapping *= 0.9f;
        Vec3 move = this.m_20184_();
        if (!this.m_20096_() && move.f_82480_ < 0.0) {
            this.m_20256_(move.m_82542_(1.0, 0.6, 1.0));
        }
        this.flap += this.flapping * 2.0f;
    }

    @Override
    public boolean hasProduct() {
        return this.getGender() == TFCAnimalProperties.Gender.FEMALE && this.getAgeType() == TFCAnimalProperties.Age.ADULT && (this.getProducedTick() <= 0L || this.getProductsCooldown() <= 0L);
    }

    public boolean m_142535_(float amount, float speed, DamageSource src) {
        return false;
    }

    public ItemStack makeEgg() {
        AnimalProductEvent event;
        OviparousAnimal baby;
        IEgg egg;
        ItemStack stack = new ItemStack((ItemLike)Items.f_42521_);
        if (this.isFertilized() && (egg = EggCapability.get(stack)) != null && (baby = (OviparousAnimal)this.m_6095_().m_20615_(this.m_9236_())) != null) {
            baby.setGender(TFCAnimalProperties.Gender.valueOf(this.f_19796_.m_188499_()));
            baby.setBirthDay(Calendars.SERVER.getTotalDays());
            baby.setFamiliarity(this.getFamiliarity() < 0.9f ? this.getFamiliarity() / 2.0f : this.getFamiliarity() * 0.9f);
            egg.setFertilized((Entity)baby, Calendars.SERVER.getTotalDays() + (long)((Integer)this.hatchDays.get()).intValue());
        }
        if (!MinecraftForge.EVENT_BUS.post((Event)(event = new AnimalProductEvent(this.m_9236_(), this.m_20183_(), null, (TFCAnimalProperties)this, stack, ItemStack.f_41583_, 1)))) {
            this.addUses(event.getUses());
        }
        return event.getProduct();
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        return this.pluck(player, hand, (LivingEntity)this) ? InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_) : super.m_6071_(player, hand);
    }

    @Override
    public MutableComponent getProductReadyName() {
        return Component.m_237115_((String)"tfc.jade.product.eggs");
    }
}

