/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.aquatic;

import java.util.Locale;
import net.dries007.tfc.client.TFCSounds;
import net.minecraft.sounds.SoundEvents;

public enum Fish {
    BLUEGILL(25994, 14934404),
    CRAPPIE(16073455, 14079429),
    LAKE_TROUT(7370132, 9404781),
    LARGEMOUTH_BASS(6397015, 10256215),
    RAINBOW_TROUT(13183175, 13203978),
    SALMON(10489616, 951412),
    SMALLMOUTH_BASS(10256215, 6397015);

    private final String serializedName;
    private final int color1;
    private final int color2;

    private Fish(int color1, int color2) {
        this.color1 = color1;
        this.color2 = color2;
        this.serializedName = this.name().toLowerCase(Locale.ROOT);
    }

    public String getSerializedName() {
        return this.serializedName;
    }

    public TFCSounds.FishSound makeSound() {
        if (this == SALMON) {
            return new TFCSounds.FishSound(() -> SoundEvents.f_12327_, () -> SoundEvents.f_12328_, () -> SoundEvents.f_12330_, () -> SoundEvents.f_12329_);
        }
        return TFCSounds.createFish(this.serializedName);
    }

    public float getWidth() {
        return this == BLUEGILL ? 0.5f : 0.7f;
    }

    public float getHeight() {
        return this == BLUEGILL ? 0.3f : 0.4f;
    }

    public int getEggColor2() {
        return this.color2;
    }

    public int getEggColor1() {
        return this.color1;
    }
}

