/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.ai.prey;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.entities.EntityHelpers;
import net.dries007.tfc.common.entities.TFCEntities;
import net.dries007.tfc.common.entities.livestock.pet.TFCCat;
import net.dries007.tfc.mixin.accessor.OcelotAccessor;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public class TFCOcelot
extends Ocelot {
    public static final EntityDataAccessor<Float> DATA_FAMILIARITY = SynchedEntityData.m_135353_(TFCOcelot.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private long nextFeedTime = Long.MIN_VALUE;

    public TFCOcelot(EntityType<? extends Ocelot> type, Level level) {
        super(type, level);
    }

    protected void m_8099_() {
        super.m_8099_();
        EntityHelpers.removeGoalOfPriority(this.f_21345_, 3);
        EntityHelpers.removeGoalOfPriority(this.f_21345_, 9);
        EntityHelpers.removeGoalOfPriority(this.f_21346_, 1);
        this.f_21345_.m_25352_(3, (Goal)new OcelotTemptGoal(this, 0.6, Ingredient.m_204132_(TFCTags.Items.CAT_FOOD), true));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, true, e -> !(e instanceof Player) && Helpers.isEntity((Entity)e, TFCTags.Entities.HUNTED_BY_CATS)));
    }

    public boolean m_6785_(double distance) {
        return false;
    }

    public float getFamiliarity() {
        return ((Float)this.f_19804_.m_135370_(DATA_FAMILIARITY)).floatValue();
    }

    public void setFamiliarity(float amount) {
        this.f_19804_.m_135381_(DATA_FAMILIARITY, (Object)Float.valueOf(Mth.m_14036_((float)amount, (float)0.0f, (float)1.0f)));
    }

    public void addFamiliarity(float amount) {
        this.setFamiliarity(this.getFamiliarity() + amount);
    }

    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FAMILIARITY, (Object)Float.valueOf(0.0f));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128350_("familiarity", this.getFamiliarity());
        tag.m_128356_("nextFeed", this.nextFeedTime);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setFamiliarity(EntityHelpers.getFloatOrDefault(tag, "familiarity", 0.0f));
        this.nextFeedTime = EntityHelpers.getLongOrDefault(tag, "nextFeed", Long.MIN_VALUE);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack held = player.m_21120_(hand);
        if (this.m_6898_(held)) {
            long ticks;
            if (!this.m_9236_().f_46443_ && (ticks = Calendars.SERVER.getTicks()) > this.nextFeedTime) {
                this.addFamiliarity(0.1f);
                ((OcelotAccessor)((Object)this)).invoke$setTrusting(true);
                this.nextFeedTime = ticks + 24000L;
                if (!player.m_7500_()) {
                    held.m_41774_(1);
                }
                this.m_5496_(this.m_7866_(held), this.m_6121_(), this.m_6100_());
                if (this.getFamiliarity() > 0.99f) {
                    Level level;
                    boolean wasBaby = this.m_6162_();
                    TFCCat cat = (TFCCat)this.m_21406_((EntityType)TFCEntities.CAT.get(), false);
                    if (cat != null && (level = this.m_9236_()) instanceof ServerLevelAccessor) {
                        ServerLevelAccessor server = (ServerLevelAccessor)level;
                        cat.m_6518_(server, this.m_9236_().m_6436_(this.m_20183_()), MobSpawnType.CONVERSION, null, null);
                        if (!wasBaby) {
                            cat.setBirthDay(Calendars.get((LevelReader)this.m_9236_()).getTotalDays() - 120L);
                        }
                    }
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public boolean m_6898_(ItemStack stack) {
        return !FoodCapability.isRotten(stack) && Helpers.isItem(stack, TFCTags.Items.CAT_FOOD);
    }

    public boolean m_6914_(LevelReader level) {
        return level.m_45784_((Entity)this) && !level.m_46855_(this.m_20191_());
    }

    public void m_27595_(@Nullable Player player) {
    }

    public static class OcelotTemptGoal
    extends TemptGoal {
        private final Ocelot ocelot;

        public OcelotTemptGoal(Ocelot ocelot, double speedMod, Ingredient ingredient, boolean canScare) {
            super((PathfinderMob)ocelot, speedMod, ingredient, canScare);
            this.ocelot = ocelot;
        }

        protected boolean m_7497_() {
            return super.m_7497_() && !((OcelotAccessor)this.ocelot).invoke$isTrusting();
        }
    }
}

