/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.entities.ai.prey;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Set;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.entities.ai.FastGateBehavior;
import net.dries007.tfc.common.entities.ai.SetLookTarget;
import net.dries007.tfc.common.entities.ai.predator.PredatorAi;
import net.dries007.tfc.common.entities.ai.prey.AvoidPredatorBehavior;
import net.dries007.tfc.common.entities.ai.prey.PrepareRamNearestTargetTFC;
import net.dries007.tfc.common.entities.ai.prey.PreyAi;
import net.dries007.tfc.common.entities.ai.prey.RamTargetTFC;
import net.dries007.tfc.common.entities.prey.RammingPrey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BabyFollowAdult;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.EraseMemoryIf;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetAwayFrom;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.schedule.Activity;

public class RammingPreyAi {
    public static final int RAM_PREPARE_TIME = 20;
    public static final int RAM_MIN_DISTANCE = 3;
    public static final int RAM_MAX_DISTANCE = 9;
    private static final float SPEED_MULTIPLIER_WHEN_PREPARING_TO_RAM = 1.6f;
    private static final float SPEED_MULTIPLIER_WHEN_RAMMING = 3.0f;
    public static final float ADULT_RAM_KNOCKBACK_FORCE = 2.5f;
    public static final float BABY_RAM_KNOCKBACK_FORCE = 1.0f;
    private static final UniformInt TIME_BETWEEN_RAMS_MALE = UniformInt.m_146622_((int)600, (int)1200);
    private static final UniformInt TIME_BETWEEN_RAMS_FEMALE = UniformInt.m_146622_((int)1000, (int)2000);
    private static final TargetingConditions RAM_TARGET_CONDITIONS = TargetingConditions.m_148352_().m_26888_(target -> target.m_9236_().m_6857_().m_61935_(target.m_20191_()));
    private static final UniformInt RETREAT_DURATION = TimeUtil.m_145020_((int)7, (int)22);

    public static void initMemories(RammingPrey rammingPrey, RandomSource random) {
        rammingPrey.m_6274_().m_21879_(MemoryModuleType.f_148202_, (Object)(rammingPrey.isMale() ? TIME_BETWEEN_RAMS_MALE : TIME_BETWEEN_RAMS_FEMALE).m_214085_(random));
    }

    public static Brain<?> makeBrain(Brain<? extends RammingPrey> brain) {
        RammingPreyAi.initCoreActivity(brain);
        RammingPreyAi.initIdleActivity(brain);
        RammingPreyAi.initRetreatActivity(brain);
        RammingPreyAi.initRamActivity(brain);
        brain.m_21930_((Set)ImmutableSet.of((Object)Activity.f_37978_));
        brain.m_21944_(Activity.f_37979_);
        brain.m_21962_();
        return brain;
    }

    public static void initCoreActivity(Brain<? extends RammingPrey> brain) {
        brain.m_21891_(Activity.f_37978_, 0, ImmutableList.of((Object)new Swim(0.7f), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), (Object)new CountDownCooldownTicks(MemoryModuleType.f_148202_), (Object)EraseMemoryIf.m_258093_(PredatorAi::hasNearbyAttacker, (MemoryModuleType)MemoryModuleType.f_148202_), (Object)EraseMemoryIf.m_258093_(RammingPreyAi::attackerHasLeft, (MemoryModuleType)MemoryModuleType.f_26382_)));
    }

    public static void initIdleActivity(Brain<? extends RammingPrey> brain) {
        brain.m_21900_(Activity.f_37979_, ImmutableList.of((Object)Pair.of((Object)0, SetLookTarget.create(EntityType.f_20532_, 6.0f, UniformInt.m_146622_((int)30, (int)60))), (Object)Pair.of((Object)1, AvoidPredatorBehavior.create(true)), (Object)Pair.of((Object)2, (Object)BabyFollowAdult.m_257685_((UniformInt)UniformInt.m_146622_((int)5, (int)16), (float)1.25f)), (Object)Pair.of((Object)3, RammingPreyAi.createIdleMovementBehaviors())));
    }

    public static void initRetreatActivity(Brain<? extends RammingPrey> brain) {
        brain.m_21895_(Activity.f_37991_, 10, ImmutableList.of((Object)SetWalkTargetAwayFrom.m_257370_((MemoryModuleType)MemoryModuleType.f_26383_, (float)1.1f, (int)15, (boolean)false), RammingPreyAi.createIdleMovementBehaviors(), SetLookTarget.create(8.0f, UniformInt.m_146622_((int)30, (int)60)), (Object)EraseMemoryIf.m_258093_(PreyAi::wantsToStopFleeing, (MemoryModuleType)MemoryModuleType.f_26383_)), MemoryModuleType.f_26383_);
    }

    public static FastGateBehavior<RammingPrey> createIdleMovementBehaviors() {
        return FastGateBehavior.runOne(ImmutableList.of((Object)RandomStroll.m_257965_((float)1.0f), (Object)SetWalkTargetFromLookTarget.m_257764_((float)1.0f, (int)3), (Object)new DoNothing(30, 60)));
    }

    private static void initRamActivity(Brain<? extends RammingPrey> brain) {
        brain.m_21903_(Activity.f_150240_, ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new RamTargetTFC(rammingPrey -> rammingPrey.isMale() ? TIME_BETWEEN_RAMS_MALE : TIME_BETWEEN_RAMS_FEMALE, RAM_TARGET_CONDITIONS, 3.0f, rammingPrey -> rammingPrey.m_6162_() ? 1.0 : 2.5, rammingPrey -> (SoundEvent)TFCSounds.RAMMING_IMPACT.get()))), (Object)Pair.of((Object)1, new PrepareRamNearestTargetTFC<RammingPrey>(rammingPrey -> rammingPrey.isMale() ? TIME_BETWEEN_RAMS_MALE.m_142739_() : TIME_BETWEEN_RAMS_FEMALE.m_142739_(), 3, 9, 1.6f, RAM_TARGET_CONDITIONS, 20, rammingPrey -> rammingPrey.getAttackSound().get()))), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.f_148202_, (Object)MemoryStatus.VALUE_ABSENT)));
    }

    public static void updateActivity(RammingPrey prey) {
        prey.m_6274_().m_21926_((List)ImmutableList.of((Object)Activity.f_37991_, (Object)Activity.f_150240_, (Object)Activity.f_37979_));
    }

    public static boolean attackerHasLeft(LivingEntity rammingPrey) {
        return rammingPrey.m_6274_().m_21952_(MemoryModuleType.f_26382_).map(entity -> entity.m_20280_((Entity)rammingPrey) < 400.0).orElse(false) == false;
    }
}

